/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.stream;

import java.io.IOException;
import org.apache.asterix.common.exceptions.ExceptionUtils;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.input.record.reader.stream.StreamRecordReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class SemiStructuredRecordReader
extends StreamRecordReader {
    private int depth;
    private boolean prevCharEscape;
    private boolean inString;
    private char recordStart;
    private char recordEnd;
    private int recordNumber = 0;

    public SemiStructuredRecordReader(AsterixInputStream stream, String recStartString, String recEndString) throws HyracksDataException {
        super(stream);
        if (recStartString != null) {
            if (recStartString.length() != 1) {
                throw new HyracksDataException(ExceptionUtils.incorrectParameterMessage((String)"record-start", (String)"Value of size 1", (String)recStartString));
            }
            this.recordStart = recStartString.charAt(0);
        } else {
            this.recordStart = (char)123;
        }
        if (recEndString != null) {
            if (recEndString.length() != 1) {
                throw new HyracksDataException(ExceptionUtils.incorrectParameterMessage((String)"record-end", (String)"Value of size 1", (String)recEndString));
            }
            this.recordEnd = recEndString.charAt(0);
        } else {
            this.recordEnd = (char)125;
        }
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.done) {
            return false;
        }
        this.record.reset();
        boolean hasStarted = false;
        boolean hasFinished = false;
        this.prevCharEscape = false;
        this.inString = false;
        this.depth = 0;
        do {
            int appendLength;
            int startPosn = this.bufferPosn;
            if (this.bufferPosn >= this.bufferLength) {
                this.bufferPosn = 0;
                startPosn = 0;
                this.bufferLength = this.reader.read(this.inputBuffer);
                if (this.bufferLength < 0) {
                    this.close();
                    return false;
                }
            }
            if (!hasStarted) {
                while (this.bufferPosn < this.bufferLength) {
                    if (this.inputBuffer[this.bufferPosn] == this.recordStart) {
                        startPosn = this.bufferPosn++;
                        hasStarted = true;
                        this.depth = 1;
                        break;
                    }
                    if (this.inputBuffer[this.bufferPosn] != ' ' && this.inputBuffer[this.bufferPosn] != '\t' && this.inputBuffer[this.bufferPosn] != '\n' && this.inputBuffer[this.bufferPosn] != '\r') {
                        this.reader.reset();
                        this.bufferLength = 0;
                        this.bufferPosn = 0;
                        throw new IOException("Malformed input stream");
                    }
                    ++this.bufferPosn;
                }
            }
            if (hasStarted) {
                while (this.bufferPosn < this.bufferLength) {
                    if (this.inString) {
                        if (this.inputBuffer[this.bufferPosn] == '\"' && !this.prevCharEscape) {
                            this.inString = false;
                        }
                        this.prevCharEscape = this.prevCharEscape ? false : this.inputBuffer[this.bufferPosn] == '\\';
                    } else if (this.inputBuffer[this.bufferPosn] == '\"') {
                        this.inString = true;
                    } else if (this.inputBuffer[this.bufferPosn] == this.recordStart) {
                        ++this.depth;
                    } else if (this.inputBuffer[this.bufferPosn] == this.recordEnd) {
                        --this.depth;
                        if (this.depth == 0) {
                            hasFinished = true;
                            ++this.bufferPosn;
                            break;
                        }
                    }
                    ++this.bufferPosn;
                }
            }
            if ((appendLength = this.bufferPosn - startPosn) <= 0) continue;
            try {
                this.record.append(this.inputBuffer, startPosn, appendLength);
            }
            catch (IOException e) {
                this.reader.reset();
                this.bufferLength = 0;
                this.bufferPosn = 0;
                throw new IOException("Malformed input stream");
            }
        } while (!hasFinished);
        this.record.endRecord();
        ++this.recordNumber;
        return true;
    }

    @Override
    public boolean stop() {
        try {
            this.reader.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

