/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.watch;

import org.apache.asterix.active.ActiveEvent;
import org.apache.asterix.active.ActivityState;
import org.apache.asterix.active.IActiveEventSubscriber;
import org.apache.asterix.external.feed.management.FeedEventsListener;

public class FeedEventSubscriber
implements IActiveEventSubscriber {
    private final FeedEventsListener listener;
    private final ActivityState state;
    private boolean done = false;

    public FeedEventSubscriber(FeedEventsListener listener, ActivityState state) {
        this.listener = listener;
        this.state = state;
    }

    public synchronized void notify(ActiveEvent event) {
        if (this.listener.getState() == this.state || this.listener.getState() == ActivityState.FAILED || this.listener.getState() == ActivityState.STOPPED) {
            this.done = true;
            this.notifyAll();
        }
    }

    public synchronized boolean done() {
        return this.done;
    }

    public synchronized void sync() throws InterruptedException {
        while (!this.done) {
            this.wait();
        }
    }

    public synchronized void unsubscribe() {
        this.done = true;
        this.notifyAll();
    }
}

