/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.dataflow;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.feed.dataflow.FeedFrameCollector;
import org.apache.asterix.external.feed.management.FeedConnectionId;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.log4j.Logger;

public class FrameDistributor
implements IFrameWriter {
    public static final Logger LOGGER = Logger.getLogger((String)FrameDistributor.class.getName());
    private final Map<FeedConnectionId, FeedFrameCollector> registeredCollectors = new HashMap<FeedConnectionId, FeedFrameCollector>();
    private Throwable rootFailureCause = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerFrameCollector(FeedFrameCollector frameCollector) throws HyracksDataException {
        if (this.rootFailureCause != null) {
            throw new RuntimeDataException(3034, this.rootFailureCause, new Serializable[0]);
        }
        try {
            frameCollector.open();
        }
        catch (Throwable th) {
            this.rootFailureCause = th;
            try {
                frameCollector.fail();
            }
            catch (Throwable failThrowable) {
                th.addSuppressed(failThrowable);
            }
            finally {
                try {
                    frameCollector.close();
                }
                catch (Throwable closeThrowable) {
                    th.addSuppressed(closeThrowable);
                }
            }
            throw th;
        }
        this.registeredCollectors.put(frameCollector.getConnectionId(), frameCollector);
    }

    public synchronized void deregisterFrameCollector(FeedFrameCollector frameCollector) throws HyracksDataException {
        this.deregisterFrameCollector(frameCollector.getConnectionId());
    }

    public synchronized void deregisterFrameCollector(FeedConnectionId connectionId) throws HyracksDataException {
        if (this.rootFailureCause != null) {
            throw new RuntimeDataException(3034, this.rootFailureCause, new Serializable[0]);
        }
        FeedFrameCollector frameCollector = this.removeFrameCollector(connectionId);
        try {
            frameCollector.close();
        }
        catch (Throwable th) {
            this.rootFailureCause = th;
            throw th;
        }
    }

    public synchronized FeedFrameCollector removeFrameCollector(FeedConnectionId connectionId) {
        return this.registeredCollectors.remove(connectionId);
    }

    public synchronized void nextFrame(ByteBuffer frame) throws HyracksDataException {
        if (this.rootFailureCause != null) {
            throw new HyracksDataException(this.rootFailureCause);
        }
        for (FeedFrameCollector collector : this.registeredCollectors.values()) {
            try {
                collector.nextFrame(frame);
            }
            catch (Throwable th) {
                this.rootFailureCause = th;
                throw th;
            }
        }
    }

    public void fail() throws HyracksDataException {
        Collection<FeedFrameCollector> collectors = this.registeredCollectors.values();
        Iterator<FeedFrameCollector> it = collectors.iterator();
        while (it.hasNext()) {
            FeedFrameCollector collector = it.next();
            try {
                collector.fail();
            }
            catch (Throwable th) {
                while (it.hasNext()) {
                    FeedFrameCollector innerCollector = it.next();
                    try {
                        innerCollector.fail();
                    }
                    catch (Throwable innerTh) {
                        th.addSuppressed(innerTh);
                    }
                }
                throw th;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws HyracksDataException {
        Collection<FeedFrameCollector> collectors = this.registeredCollectors.values();
        Iterator<FeedFrameCollector> it = collectors.iterator();
        while (it.hasNext()) {
            FeedFrameCollector collector = it.next();
            try {
                collector.close();
            }
            catch (Throwable th) {
                while (it.hasNext()) {
                    FeedFrameCollector innerCollector = it.next();
                    try {
                        innerCollector.close();
                    }
                    catch (Throwable innerTh) {
                        th.addSuppressed(innerTh);
                    }
                    finally {
                        innerCollector.setState(FeedFrameCollector.State.FINISHED);
                    }
                }
                throw th;
            }
            finally {
                collector.setState(FeedFrameCollector.State.FINISHED);
            }
        }
    }

    public void flush() throws HyracksDataException {
        if (this.rootFailureCause != null) {
            throw new HyracksDataException(this.rootFailureCause);
        }
        for (FeedFrameCollector collector : this.registeredCollectors.values()) {
            try {
                collector.flush();
            }
            catch (Throwable th) {
                this.rootFailureCause = th;
                throw th;
            }
        }
    }

    public void open() throws HyracksDataException {
    }
}

