/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.dataflow;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.ITupleForwarder;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;

public class FrameFullTupleForwarder
implements ITupleForwarder {
    private FrameTupleAppender appender;
    private IFrame frame;
    private IFrameWriter writer;

    @Override
    public void initialize(IHyracksTaskContext ctx, IFrameWriter writer) throws HyracksDataException {
        this.appender = new FrameTupleAppender();
        this.frame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        this.writer = writer;
        this.appender.reset(this.frame, true);
    }

    @Override
    public void addTuple(ArrayTupleBuilder tb) throws HyracksDataException {
        boolean success = this.appender.append(tb.getFieldEndOffsets(), tb.getByteArray(), 0, tb.getSize());
        if (!success) {
            FrameUtils.flushFrame((ByteBuffer)this.frame.getBuffer(), (IFrameWriter)this.writer);
            this.appender.reset(this.frame, true);
            success = this.appender.append(tb.getFieldEndOffsets(), tb.getByteArray(), 0, tb.getSize());
            if (!success) {
                throw new RuntimeDataException(3001, new Serializable[0]);
            }
        }
    }

    @Override
    public void close() throws HyracksDataException {
        if (this.appender.getTupleCount() > 0) {
            FrameUtils.flushFrame((ByteBuffer)this.frame.getBuffer(), (IFrameWriter)this.writer);
        }
    }
}

