/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.dataflow;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.asterix.external.api.ITupleForwarder;
import org.apache.asterix.external.util.DataflowUtils;
import org.apache.asterix.external.util.FeedLogManager;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;

public class FeedTupleForwarder
implements ITupleForwarder {
    private final FeedLogManager feedLogManager;
    private FrameTupleAppender appender;
    private IFrame frame;
    private IFrameWriter writer;
    private boolean paused = false;
    private boolean initialized;

    public FeedTupleForwarder(FeedLogManager feedLogManager) {
        this.feedLogManager = feedLogManager;
    }

    public FeedLogManager getFeedLogManager() {
        return this.feedLogManager;
    }

    @Override
    public void initialize(IHyracksTaskContext ctx, IFrameWriter writer) throws HyracksDataException {
        if (!this.initialized) {
            this.frame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
            this.writer = writer;
            this.appender = new FrameTupleAppender(this.frame);
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTuple(ArrayTupleBuilder tb) throws HyracksDataException {
        if (this.paused) {
            FeedTupleForwarder feedTupleForwarder = this;
            synchronized (feedTupleForwarder) {
                while (this.paused) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                }
            }
        }
        DataflowUtils.addTupleToFrame(this.appender, tb, this.writer);
    }

    public void pause() {
        this.paused = true;
    }

    public synchronized void resume() {
        this.paused = false;
        this.notifyAll();
    }

    @Override
    public void close() throws HyracksDataException {
        Throwable throwable = null;
        try {
            if (this.appender.getTupleCount() > 0) {
                FrameUtils.flushFrame((ByteBuffer)this.frame.getBuffer(), (IFrameWriter)this.writer);
            }
        }
        catch (Throwable th) {
            throwable = th;
            throw th;
        }
        finally {
            try {
                this.feedLogManager.close();
            }
            catch (IOException e) {
                if (throwable != null) {
                    throwable.addSuppressed(e);
                }
                throw new HyracksDataException((Throwable)e);
            }
            catch (Throwable th) {
                if (throwable != null) {
                    throwable.addSuppressed(th);
                }
                throw th;
            }
        }
    }

    public void flush() throws HyracksDataException {
        this.appender.flush(this.writer);
    }
}

