/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.dataflow;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.dataflow.FeedTupleForwarder;
import org.apache.asterix.external.util.FeedLogManager;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.log4j.Logger;

public class FeedRecordDataFlowController<T>
extends AbstractFeedDataFlowController {
    private static final Logger LOGGER = Logger.getLogger((String)FeedRecordDataFlowController.class.getName());
    private final IRecordDataParser<T> dataParser;
    private final IRecordReader<T> recordReader;
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected static final long INTERVAL = 1000L;
    protected boolean failed = false;

    public FeedRecordDataFlowController(IHyracksTaskContext ctx, FeedTupleForwarder tupleForwarder, FeedLogManager feedLogManager, int numOfOutputFields, IRecordDataParser<T> dataParser, IRecordReader<T> recordReader) throws HyracksDataException {
        super(ctx, tupleForwarder, feedLogManager, numOfOutputFields);
        this.dataParser = dataParser;
        this.recordReader = recordReader;
        recordReader.setFeedLogManager(feedLogManager);
        recordReader.setController(this);
    }

    @Override
    public void start(IFrameWriter writer) throws HyracksDataException, InterruptedException {
        try {
            this.failed = false;
            this.tupleForwarder.initialize(this.ctx, writer);
            while (this.recordReader.hasNext()) {
                IRawRecord<T> record = this.recordReader.next();
                if (record == null) {
                    this.flush();
                    Thread.sleep(1000L);
                    continue;
                }
                this.tb.reset();
                this.parseAndForward(record);
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn((Object)"Feed has been interrupted. Closing the feed", (Throwable)e);
            this.failed = true;
            try {
                this.finish();
            }
            catch (HyracksDataException hde) {
                e.addSuppressed(hde);
            }
            throw e;
        }
        catch (Exception e) {
            this.failed = true;
            this.tupleForwarder.flush();
            LOGGER.warn((Object)"Failure while operating a feed source", (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
        this.finish();
    }

    private void finish() throws HyracksDataException {
        HyracksDataException hde = null;
        try {
            this.tupleForwarder.close();
        }
        catch (Throwable th) {
            hde = HyracksDataException.suppress(hde, (Throwable)th);
        }
        try {
            this.recordReader.close();
        }
        catch (Throwable th) {
            LOGGER.warn((Object)"Failure during while operating a feed sourcec", th);
            hde = HyracksDataException.suppress((HyracksDataException)hde, (Throwable)th);
        }
        finally {
            this.closeSignal();
        }
        if (hde != null) {
            throw hde;
        }
    }

    private void parseAndForward(IRawRecord<? extends T> record) throws IOException {
        try {
            this.dataParser.parse(record, this.tb.getDataOutput());
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Parser failed to parse record", (Throwable)e);
            this.feedLogManager.logRecord(record.toString(), "Parser failed to parse record");
            return;
        }
        this.tb.addFieldEndOffset();
        this.addMetaPart(this.tb, record);
        this.addPrimaryKeys(this.tb, record);
        this.tupleForwarder.addTuple(this.tb);
    }

    protected void addMetaPart(ArrayTupleBuilder tb, IRawRecord<? extends T> record) throws IOException {
    }

    protected void addPrimaryKeys(ArrayTupleBuilder tb, IRawRecord<? extends T> record) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSignal() {
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            this.closed.set(true);
            this.closed.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSignal() throws InterruptedException {
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            while (!this.closed.get()) {
                this.closed.wait();
            }
        }
    }

    @Override
    public boolean stop() throws HyracksDataException {
        HyracksDataException hde = null;
        if (this.recordReader.stop()) {
            if (this.failed) {
                try {
                    this.tupleForwarder.close();
                }
                catch (Throwable th) {
                    hde = HyracksDataException.suppress(hde, (Throwable)th);
                }
                try {
                    this.recordReader.close();
                }
                catch (Throwable th) {
                    hde = HyracksDataException.suppress((HyracksDataException)hde, (Throwable)th);
                }
                if (hde != null) {
                    throw hde;
                }
            } else {
                try {
                    this.waitForSignal();
                }
                catch (InterruptedException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleException(Throwable th) throws HyracksDataException {
        if (!this.recordReader.handleException(th)) {
            this.finish();
        }
        return this.closed.get();
    }

    public IRecordReader<T> getReader() {
        return this.recordReader;
    }

    public IRecordDataParser<T> getParser() {
        return this.dataParser;
    }
}

