/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.dataflow;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.ITupleForwarder;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;

public class CounterTimerTupleForwarder
implements ITupleForwarder {
    public static final String BATCH_SIZE = "batch-size";
    public static final String BATCH_INTERVAL = "batch-interval";
    private static final Logger LOGGER = Logger.getLogger(CounterTimerTupleForwarder.class.getName());
    private FrameTupleAppender appender;
    private IFrame frame;
    private IFrameWriter writer;
    private int batchSize;
    private long batchInterval;
    private int tuplesInFrame = 0;
    private TimeBasedFlushTask flushTask;
    private Timer timer;
    private Object lock = new Object();
    private boolean activeTimer = false;

    private CounterTimerTupleForwarder(int batchSize, long batchInterval) {
        this.batchSize = batchSize;
        this.batchInterval = batchInterval;
        if (batchInterval > 0L) {
            this.activeTimer = true;
        }
    }

    public static CounterTimerTupleForwarder create(Map<String, String> configuration) {
        int batchSize = -1;
        long batchInterval = 0L;
        String propValue = configuration.get(BATCH_SIZE);
        if (propValue != null) {
            batchSize = Integer.parseInt(propValue);
        }
        if ((propValue = configuration.get(BATCH_INTERVAL)) != null) {
            batchInterval = Long.parseLong(propValue);
        }
        return new CounterTimerTupleForwarder(batchSize, batchInterval);
    }

    @Override
    public void initialize(IHyracksTaskContext ctx, IFrameWriter writer) throws HyracksDataException {
        this.appender = new FrameTupleAppender();
        this.frame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        this.appender.reset(this.frame, true);
        this.writer = writer;
        if (this.activeTimer) {
            this.timer = new Timer();
            this.flushTask = new TimeBasedFlushTask(writer, this.lock);
            this.timer.scheduleAtFixedRate((TimerTask)this.flushTask, 0L, this.batchInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTuple(ArrayTupleBuilder tb) throws HyracksDataException {
        if (this.activeTimer) {
            Object object = this.lock;
            synchronized (object) {
                this.addTupleToFrame(tb);
            }
        } else {
            this.addTupleToFrame(tb);
        }
        ++this.tuplesInFrame;
    }

    private void addTupleToFrame(ArrayTupleBuilder tb) throws HyracksDataException {
        if (this.tuplesInFrame == this.batchSize || !this.appender.append(tb.getFieldEndOffsets(), tb.getByteArray(), 0, tb.getSize())) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("flushing frame containg (" + this.tuplesInFrame + ") tuples");
            }
            FrameUtils.flushFrame((ByteBuffer)this.frame.getBuffer(), (IFrameWriter)this.writer);
            this.tuplesInFrame = 0;
            this.appender.reset(this.frame, true);
            if (!this.appender.append(tb.getFieldEndOffsets(), tb.getByteArray(), 0, tb.getSize())) {
                throw new RuntimeDataException(3001, new Serializable[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HyracksDataException {
        if (this.appender.getTupleCount() > 0) {
            if (this.activeTimer) {
                Object object = this.lock;
                synchronized (object) {
                    FrameUtils.flushFrame((ByteBuffer)this.frame.getBuffer(), (IFrameWriter)this.writer);
                }
            } else {
                FrameUtils.flushFrame((ByteBuffer)this.frame.getBuffer(), (IFrameWriter)this.writer);
            }
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private class TimeBasedFlushTask
    extends TimerTask {
        private IFrameWriter writer;
        private final Object lock;

        public TimeBasedFlushTask(IFrameWriter writer, Object lock) {
            this.writer = writer;
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    if (CounterTimerTupleForwarder.this.tuplesInFrame <= 0) break block6;
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("TTL expired flushing frame (" + CounterTimerTupleForwarder.this.tuplesInFrame + ")");
                    }
                    Object object = this.lock;
                    synchronized (object) {
                        FrameUtils.flushFrame((ByteBuffer)CounterTimerTupleForwarder.this.frame.getBuffer(), (IFrameWriter)this.writer);
                        CounterTimerTupleForwarder.this.appender.reset(CounterTimerTupleForwarder.this.frame, true);
                        CounterTimerTupleForwarder.this.tuplesInFrame = 0;
                    }
                }
                catch (HyracksDataException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

