/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.config.ClusterProperties;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.replication.IReplicaResourcesManager;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.metadata.utils.SplitsAndConstraintsUtil;
import org.apache.asterix.replication.storage.LSMComponentProperties;
import org.apache.asterix.replication.storage.LSMIndexFileProperties;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.file.ILocalResourceRepository;
import org.apache.hyracks.storage.common.file.LocalResource;

public class ReplicaResourcesManager
implements IReplicaResourcesManager {
    private static final Logger LOGGER = Logger.getLogger(ReplicaResourcesManager.class.getName());
    public static final String LSM_COMPONENT_MASK_SUFFIX = "_mask";
    private static final String REPLICA_INDEX_LSN_MAP_NAME = ".LSN_MAP";
    public static final long REPLICA_INDEX_CREATION_LSN = -1L;
    private final PersistentLocalResourceRepository localRepository;
    private final Map<String, ClusterPartition[]> nodePartitions;
    private static final FilenameFilter LSM_COMPONENTS_MASKS_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(ReplicaResourcesManager.LSM_COMPONENT_MASK_SUFFIX);
        }
    };
    private static final FilenameFilter LSM_COMPONENTS_NON_MASKS_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.endsWith(ReplicaResourcesManager.LSM_COMPONENT_MASK_SUFFIX);
        }
    };
    private static final FilenameFilter LSM_INDEX_FILES_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.equalsIgnoreCase(".metadata") || !name.startsWith(".");
        }
    };

    public ReplicaResourcesManager(ILocalResourceRepository localRepository, MetadataProperties metadataProperties) {
        this.localRepository = (PersistentLocalResourceRepository)localRepository;
        this.nodePartitions = metadataProperties.getNodePartitions();
    }

    public void deleteIndexFile(LSMIndexFileProperties afp) {
        String indexPath = this.getIndexPath(afp);
        if (indexPath != null) {
            if (afp.isLSMComponentFile()) {
                String indexFilePath = indexPath + File.separator + afp.getFileName();
                File destFile = new File(indexFilePath);
                FileUtils.deleteQuietly((File)destFile);
            } else {
                FileUtils.deleteQuietly((File)new File(indexPath));
            }
        }
    }

    public String getIndexPath(LSMIndexFileProperties fileProperties) {
        fileProperties.splitFileName();
        String partitionPath = this.localRepository.getPartitionPath(fileProperties.getPartition());
        String indexPath = SplitsAndConstraintsUtil.getIndexPath((String)partitionPath, (int)fileProperties.getPartition(), (String)fileProperties.getDataverse(), (String)fileProperties.getIdxName());
        Path path = Paths.get(indexPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            File indexFolder = new File(indexPath);
            indexFolder.mkdirs();
        }
        return indexPath;
    }

    public void initializeReplicaIndexLSNMap(String indexPath, long currentLSN) throws IOException {
        HashMap<Long, Long> lsnMap = new HashMap<Long, Long>();
        lsnMap.put(-1L, currentLSN);
        this.updateReplicaIndexLSNMap(indexPath, lsnMap);
    }

    public void createRemoteLSMComponentMask(LSMComponentProperties lsmComponentProperties) throws IOException {
        String maskPath = lsmComponentProperties.getMaskPath(this);
        Path path = Paths.get(maskPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            File maskFile = new File(maskPath);
            maskFile.createNewFile();
        }
    }

    public void markLSMComponentReplicaAsValid(LSMComponentProperties lsmComponentProperties) throws IOException {
        String maskPath = lsmComponentProperties.getMaskPath(this);
        Path path = Paths.get(maskPath, new String[0]);
        Files.deleteIfExists(path);
        Map<Long, Long> lsnMap = this.getReplicaIndexLSNMap(lsmComponentProperties.getReplicaComponentPath(this));
        lsnMap.put(lsmComponentProperties.getOriginalLSN(), lsmComponentProperties.getReplicaLSN());
        this.updateReplicaIndexLSNMap(lsmComponentProperties.getReplicaComponentPath(this), lsnMap);
    }

    public Set<File> getReplicaIndexes(String replicaId) {
        ClusterPartition[] partitions;
        HashSet<File> remoteIndexesPaths = new HashSet<File>();
        for (ClusterPartition partition : partitions = this.nodePartitions.get(replicaId)) {
            remoteIndexesPaths.addAll(this.getPartitionIndexes(partition.getPartitionId()));
        }
        return remoteIndexesPaths;
    }

    public long getPartitionsMinLSN(Set<Integer> partitions) {
        long minRemoteLSN = Long.MAX_VALUE;
        for (Integer partition : partitions) {
            Set<File> remoteIndexes = this.getPartitionIndexes(partition);
            for (File indexFolder : remoteIndexes) {
                try {
                    long remoteIndexMaxLSN = this.getReplicaIndexMaxLSN(indexFolder);
                    minRemoteLSN = Math.min(minRemoteLSN, remoteIndexMaxLSN);
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, indexFolder.getAbsolutePath() + " Couldn't read LSN map for index " + indexFolder);
                }
            }
        }
        return minRemoteLSN;
    }

    public Map<Long, String> getLaggingReplicaIndexesId2PathMap(String replicaId, long targetLSN) throws IOException {
        HashMap<Long, String> laggingReplicaIndexes = new HashMap<Long, String>();
        try {
            Set<File> remoteIndexes = this.getReplicaIndexes(replicaId);
            for (File indexFolder : remoteIndexes) {
                if (this.getReplicaIndexMaxLSN(indexFolder) >= targetLSN) continue;
                File localResource = new File(indexFolder + File.separator + ".metadata");
                LocalResource resource = PersistentLocalResourceRepository.readLocalResource((File)localResource);
                laggingReplicaIndexes.put(resource.getId(), indexFolder.getAbsolutePath());
            }
        }
        catch (HyracksDataException e) {
            e.printStackTrace();
        }
        return laggingReplicaIndexes;
    }

    private long getReplicaIndexMaxLSN(File indexFolder) throws IOException {
        long remoteIndexMaxLSN = 0L;
        Map<Long, Long> lsnMap = this.getReplicaIndexLSNMap(indexFolder.getAbsolutePath());
        if (lsnMap != null) {
            for (Long lsn : lsnMap.values()) {
                remoteIndexMaxLSN = Math.max(remoteIndexMaxLSN, lsn);
            }
        }
        return remoteIndexMaxLSN;
    }

    public void cleanInvalidLSMComponents(String replicaId) {
        Set<File> remoteIndexes = this.getReplicaIndexes(replicaId);
        for (File remoteIndexFile : remoteIndexes) {
            File[] masks;
            for (File mask : masks = remoteIndexFile.listFiles(LSM_COMPONENTS_MASKS_FILTER)) {
                ReplicaResourcesManager.deleteLSMComponentFilesForMask(mask);
                mask.delete();
            }
        }
    }

    private static void deleteLSMComponentFilesForMask(File maskFile) {
        File[] lsmComponentsFiles;
        String lsmComponentTimeStamp = maskFile.getName().substring(0, maskFile.getName().length() - LSM_COMPONENT_MASK_SUFFIX.length());
        File indexFolder = maskFile.getParentFile();
        for (File lsmComponentFile : lsmComponentsFiles = indexFolder.listFiles(LSM_COMPONENTS_NON_MASKS_FILTER)) {
            if (!lsmComponentFile.getName().contains(lsmComponentTimeStamp)) continue;
            lsmComponentFile.delete();
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized Map<Long, Long> getReplicaIndexLSNMap(String indexPath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void updateReplicaIndexLSNMap(String indexPath, Map<Long, Long> lsnMap) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(indexPath + File.separator + REPLICA_INDEX_LSN_MAP_NAME);
             ObjectOutputStream oosToFos = new ObjectOutputStream(fos);){
            oosToFos.writeObject(lsnMap);
            oosToFos.flush();
        }
    }

    public Set<File> getPartitionIndexes(int partition) {
        File[] dataverseFileList;
        HashSet<File> partitionIndexes = new HashSet<File>();
        String storageDirName = ClusterProperties.INSTANCE.getStorageDirectoryName();
        String partitionStoragePath = this.localRepository.getPartitionPath(partition) + StoragePathUtil.prepareStoragePartitionPath((String)storageDirName, (int)partition);
        File partitionRoot = new File(partitionStoragePath);
        if (partitionRoot.exists() && partitionRoot.isDirectory() && (dataverseFileList = partitionRoot.listFiles()) != null) {
            for (File dataverseFile : dataverseFileList) {
                File[] indexFileList;
                if (!dataverseFile.isDirectory() || (indexFileList = dataverseFile.listFiles()) == null) continue;
                for (File indexFile : indexFileList) {
                    if (!indexFile.isDirectory()) continue;
                    partitionIndexes.add(indexFile);
                }
            }
        }
        return partitionIndexes;
    }

    public List<String> getPartitionIndexesFiles(int partition, boolean relativePath) {
        ArrayList<String> partitionFiles = new ArrayList<String>();
        Set<File> partitionIndexes = this.getPartitionIndexes(partition);
        for (File indexDir : partitionIndexes) {
            File[] indexFiles;
            if (!indexDir.isDirectory() || (indexFiles = indexDir.listFiles(LSM_INDEX_FILES_FILTER)) == null) continue;
            for (File file : indexFiles) {
                if (!relativePath) {
                    partitionFiles.add(file.getAbsolutePath());
                    continue;
                }
                partitionFiles.add(StoragePathUtil.getIndexFileRelativePath((String)file.getAbsolutePath()));
            }
        }
        return partitionFiles;
    }
}

