/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.storage;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.asterix.common.ioopcallbacks.AbstractLSMIOOperationCallback;
import org.apache.asterix.replication.logging.TxnLogUtil;
import org.apache.asterix.replication.storage.LSMIndexFileProperties;
import org.apache.asterix.replication.storage.ReplicaResourcesManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexReplicationJob;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;

public class LSMComponentProperties {
    private AtomicInteger numberOfFiles;
    private String componentId;
    private long lsnOffset;
    private long originalLSN;
    private String nodeId;
    private Long replicaLSN;
    private String maskPath = null;
    private String replicaPath = null;
    private LSMOperationType opType;

    public LSMComponentProperties(ILSMIndexReplicationJob job, String nodeId) {
        this.nodeId = nodeId;
        this.componentId = LSMComponentProperties.getLSMComponentID((String)job.getJobFiles().toArray()[0]);
        this.numberOfFiles = new AtomicInteger(job.getJobFiles().size());
        this.originalLSN = LSMComponentProperties.getLSMComponentLSN((AbstractLSMIndex)job.getLSMIndex(), job.getLSMIndexOperationContext());
        this.opType = job.getLSMOpType();
    }

    public LSMComponentProperties() {
    }

    public static long getLSMComponentLSN(AbstractLSMIndex lsmIndex, ILSMIndexOperationContext ctx) {
        long componentLSN = -1L;
        try {
            componentLSN = ((AbstractLSMIOOperationCallback)lsmIndex.getIOOperationCallback()).getComponentLSN(ctx.getComponentsToBeReplicated());
        }
        catch (HyracksDataException e) {
            e.printStackTrace();
        }
        if (componentLSN < 0L) {
            componentLSN = 0L;
        }
        return componentLSN;
    }

    public void serialize(OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        dos.writeUTF(this.componentId);
        dos.writeUTF(this.nodeId);
        dos.writeInt(this.numberOfFiles.get());
        dos.writeLong(this.originalLSN);
        dos.writeLong(this.lsnOffset);
        dos.writeInt(this.opType.ordinal());
    }

    public static LSMComponentProperties create(DataInput input) throws IOException {
        LSMComponentProperties lsmCompProp = new LSMComponentProperties();
        lsmCompProp.componentId = input.readUTF();
        lsmCompProp.nodeId = input.readUTF();
        lsmCompProp.numberOfFiles = new AtomicInteger(input.readInt());
        lsmCompProp.originalLSN = input.readLong();
        lsmCompProp.lsnOffset = input.readLong();
        lsmCompProp.opType = LSMOperationType.values()[input.readInt()];
        return lsmCompProp;
    }

    public String getMaskPath(ReplicaResourcesManager resourceManager) {
        if (this.maskPath == null) {
            LSMIndexFileProperties afp = new LSMIndexFileProperties(this);
            afp.splitFileName();
            this.maskPath = this.getReplicaComponentPath(resourceManager) + File.separator + afp.getFileName() + "_mask";
        }
        return this.maskPath;
    }

    public String getReplicaComponentPath(ReplicaResourcesManager resourceManager) {
        if (this.replicaPath == null) {
            LSMIndexFileProperties afp = new LSMIndexFileProperties(this);
            this.replicaPath = resourceManager.getIndexPath(afp);
        }
        return this.replicaPath;
    }

    public static String getLSMComponentID(String filePath) {
        String[] tokens = filePath.split(File.separator);
        int arraySize = tokens.length;
        String fileName = tokens[arraySize - 1];
        String idxName = tokens[arraySize - 2];
        String dataverse = tokens[arraySize - 3];
        String partitionName = tokens[arraySize - 4];
        StringBuilder componentId = new StringBuilder();
        componentId.append(partitionName);
        componentId.append(File.separator);
        componentId.append(dataverse);
        componentId.append(File.separator);
        componentId.append(idxName);
        componentId.append(File.separator);
        componentId.append(fileName.substring(0, fileName.lastIndexOf("_")));
        return componentId.toString();
    }

    public String getComponentId() {
        return this.componentId;
    }

    public long getOriginalLSN() {
        return this.originalLSN;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles.get();
    }

    public int markFileComplete() {
        return this.numberOfFiles.decrementAndGet();
    }

    public void setNumberOfFiles(AtomicInteger numberOfFiles) {
        this.numberOfFiles = numberOfFiles;
    }

    public Long getReplicaLSN() {
        return this.replicaLSN;
    }

    public void setReplicaLSN(Long replicaLSN) {
        this.replicaLSN = replicaLSN;
    }

    public LSMOperationType getOpType() {
        return this.opType;
    }

    public void setOpType(LSMOperationType opType) {
        this.opType = opType;
    }

    public String getNodeUniqueLSN() {
        return TxnLogUtil.getNodeUniqueLSN(this.nodeId, this.originalLSN);
    }
}

