/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.management;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.dataflow.LSMIndexUtil;
import org.apache.asterix.common.replication.IReplicaResourcesManager;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.replication.Replica;
import org.apache.asterix.common.replication.ReplicaEvent;
import org.apache.asterix.common.replication.ReplicationJob;
import org.apache.asterix.common.storage.IndexFileProperties;
import org.apache.asterix.common.transactions.IAppRuntimeContextProvider;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.asterix.replication.functions.ReplicaFilesRequest;
import org.apache.asterix.replication.functions.ReplicaIndexFlushRequest;
import org.apache.asterix.replication.functions.ReplicationProtocol;
import org.apache.asterix.replication.logging.ReplicationLogBuffer;
import org.apache.asterix.replication.logging.TxnLogReplicator;
import org.apache.asterix.replication.management.NetworkingUtil;
import org.apache.asterix.replication.management.ReplicaStateChecker;
import org.apache.asterix.replication.storage.LSMComponentProperties;
import org.apache.asterix.replication.storage.LSMIndexFileProperties;
import org.apache.asterix.replication.storage.ReplicaResourcesManager;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.application.IClusterLifecycleListener;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexReplicationJob;
import org.apache.hyracks.util.StorageUtil;

public class ReplicationManager
implements IReplicationManager {
    private static final Logger LOGGER = Logger.getLogger(ReplicationManager.class.getName());
    private static final int INITIAL_REPLICATION_FACTOR = 1;
    private static final int MAX_JOB_COMMIT_ACK_WAIT = 10000;
    private final String nodeId;
    private ExecutorService replicationListenerThreads;
    private final Map<Integer, Set<String>> jobCommitAcks;
    private final Map<Integer, ILogRecord> replicationJobsPendingAcks;
    private ByteBuffer dataBuffer;
    private final LinkedBlockingQueue<IReplicationJob> replicationJobsQ;
    private final LinkedBlockingQueue<ReplicaEvent> replicaEventsQ;
    private int replicationFactor = 1;
    private final ReplicaResourcesManager replicaResourcesManager;
    private final ILogManager logManager;
    private final IAppRuntimeContextProvider asterixAppRuntimeContextProvider;
    private final ReplicationProperties replicationProperties;
    private final Map<String, Replica> replicas;
    private final Map<String, Set<Integer>> replica2PartitionsMap;
    private final AtomicBoolean replicationSuspended;
    private AtomicBoolean terminateJobsReplication;
    private AtomicBoolean jobsReplicationSuspended;
    private static final int INITIAL_BUFFER_SIZE = StorageUtil.getIntSizeInBytes((int)4, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE);
    private final Set<String> shuttingDownReplicaIds;
    private ReplicationJobsProccessor replicationJobsProcessor;
    private final ReplicasEventsMonitor replicationMonitor;
    private static final IReplicationJob REPLICATION_JOB_POISON_PILL = new ReplicationJob(IReplicationJob.ReplicationJobType.METADATA, IReplicationJob.ReplicationOperation.REPLICATE, IReplicationJob.ReplicationExecutionType.ASYNC, null);
    private String hostIPAddressFirstOctet = null;
    private LinkedBlockingQueue<ReplicationLogBuffer> emptyLogBuffersQ;
    private LinkedBlockingQueue<ReplicationLogBuffer> pendingFlushLogBuffersQ;
    protected ReplicationLogBuffer currentTxnLogBuffer;
    private TxnLogReplicator txnlogReplicator;
    private Future<? extends Object> txnLogReplicatorTask;
    private SocketChannel[] logsRepSockets;
    private final ByteBuffer txnLogsBatchSizeBuffer = ByteBuffer.allocate(4);
    private final IReplicationStrategy replicationStrategy;
    private final PersistentLocalResourceRepository localResourceRepo;

    public ReplicationManager(String nodeId, ReplicationProperties replicationProperties, IReplicaResourcesManager remoteResoucesManager, ILogManager logManager, IAppRuntimeContextProvider asterixAppRuntimeContextProvider) {
        this.nodeId = nodeId;
        this.replicationProperties = replicationProperties;
        this.replicationStrategy = replicationProperties.getReplicationStrategy();
        this.replicaResourcesManager = (ReplicaResourcesManager)remoteResoucesManager;
        this.asterixAppRuntimeContextProvider = asterixAppRuntimeContextProvider;
        this.logManager = logManager;
        this.localResourceRepo = (PersistentLocalResourceRepository)asterixAppRuntimeContextProvider.getLocalResourceRepository();
        this.hostIPAddressFirstOctet = replicationProperties.getReplicaIPAddress(nodeId).substring(0, 3);
        this.replicas = new HashMap<String, Replica>();
        this.replicationJobsQ = new LinkedBlockingQueue();
        this.replicaEventsQ = new LinkedBlockingQueue();
        this.terminateJobsReplication = new AtomicBoolean(false);
        this.jobsReplicationSuspended = new AtomicBoolean(true);
        this.replicationSuspended = new AtomicBoolean(true);
        this.jobCommitAcks = new ConcurrentHashMap<Integer, Set<String>>();
        this.replicationJobsPendingAcks = new ConcurrentHashMap<Integer, ILogRecord>();
        this.shuttingDownReplicaIds = new HashSet<String>();
        this.dataBuffer = ByteBuffer.allocate(INITIAL_BUFFER_SIZE);
        this.replicationMonitor = new ReplicasEventsMonitor();
        Set replicaNodes = replicationProperties.getReplicationStrategy().getRemoteReplicas(nodeId);
        this.replicationListenerThreads = Executors.newCachedThreadPool();
        this.replicationJobsProcessor = new ReplicationJobsProccessor();
        Map nodePartitions = asterixAppRuntimeContextProvider.getAppContext().getMetadataProperties().getNodePartitions();
        this.replica2PartitionsMap = new HashMap<String, Set<Integer>>(replicaNodes.size());
        for (Replica replica : replicaNodes) {
            this.replicas.put(replica.getId(), replica);
            Set nodeReplicationClients = replicationProperties.getRemotePrimaryReplicasIds(replica.getId());
            ArrayList<Integer> clientPartitions = new ArrayList<Integer>();
            for (String clientId : nodeReplicationClients) {
                for (ClusterPartition clusterPartition : (ClusterPartition[])nodePartitions.get(clientId)) {
                    clientPartitions.add(clusterPartition.getPartitionId());
                }
            }
            HashSet<Integer> clientPartitonsSet = new HashSet<Integer>(clientPartitions.size());
            clientPartitonsSet.addAll(clientPartitions);
            this.replica2PartitionsMap.put(replica.getId(), clientPartitonsSet);
        }
        int numLogBuffers = replicationProperties.getLogBufferNumOfPages();
        this.emptyLogBuffersQ = new LinkedBlockingQueue(numLogBuffers);
        this.pendingFlushLogBuffersQ = new LinkedBlockingQueue(numLogBuffers);
        int logBufferSize = replicationProperties.getLogBufferPageSize();
        for (int i = 0; i < numLogBuffers; ++i) {
            this.emptyLogBuffersQ.offer(new ReplicationLogBuffer(this, logBufferSize, replicationProperties.getLogBatchSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitJob(IReplicationJob job) throws IOException {
        if (job.getExecutionType() == IReplicationJob.ReplicationExecutionType.ASYNC) {
            this.replicationJobsQ.offer(job);
        } else {
            while (this.replicationSuspended.get()) {
                AtomicBoolean atomicBoolean = this.replicationSuspended;
                synchronized (atomicBoolean) {
                    try {
                        this.replicationSuspended.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            this.processJob(job, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicateLog(ILogRecord logRecord) throws InterruptedException {
        if (logRecord.getLogType() == 1 || logRecord.getLogType() == 3) {
            while (this.replicationSuspended.get()) {
                AtomicBoolean atomicBoolean = this.replicationSuspended;
                synchronized (atomicBoolean) {
                    this.replicationSuspended.wait();
                }
            }
            Set<String> replicaIds = Collections.synchronizedSet(new HashSet());
            replicaIds.add(this.nodeId);
            this.jobCommitAcks.put(logRecord.getJobId(), replicaIds);
        }
        this.appendToLogBuffer(logRecord);
    }

    protected void getAndInitNewLargePage(int pageSize) {
        this.currentTxnLogBuffer = new ReplicationLogBuffer(this, pageSize, this.replicationProperties.getLogBufferPageSize());
        this.pendingFlushLogBuffersQ.offer(this.currentTxnLogBuffer);
    }

    protected void getAndInitNewPage() throws InterruptedException {
        this.currentTxnLogBuffer = null;
        while (this.currentTxnLogBuffer == null) {
            this.currentTxnLogBuffer = this.emptyLogBuffersQ.take();
        }
        this.currentTxnLogBuffer.reset();
        this.pendingFlushLogBuffersQ.offer(this.currentTxnLogBuffer);
    }

    private synchronized void appendToLogBuffer(ILogRecord logRecord) throws InterruptedException {
        if (!this.currentTxnLogBuffer.hasSpace(logRecord)) {
            this.currentTxnLogBuffer.isFull(true);
            if (logRecord.getLogSize() > this.getLogPageSize()) {
                this.getAndInitNewLargePage(logRecord.getLogSize());
            } else {
                this.getAndInitNewPage();
            }
        }
        this.currentTxnLogBuffer.append(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJob(IReplicationJob job, Map<String, SocketChannel> replicasSockets, ByteBuffer requestBuffer) throws IOException {
        block51: {
            try {
                String jobFile = (String)job.getJobFiles().iterator().next();
                IndexFileProperties indexFileRef = this.localResourceRepo.getIndexFileRef(jobFile);
                if (!this.replicationStrategy.isMatch(indexFileRef.getDatasetId())) {
                    return;
                }
                int jobPartitionId = indexFileRef.getPartitionId();
                ByteBuffer responseBuffer = null;
                LSMIndexFileProperties asterixFileProperties = new LSMIndexFileProperties();
                if (requestBuffer == null) {
                    requestBuffer = ByteBuffer.allocate(INITIAL_BUFFER_SIZE);
                }
                boolean isLSMComponentFile = job.getJobType() == IReplicationJob.ReplicationJobType.LSM_COMPONENT;
                try {
                    if (replicasSockets == null) {
                        replicasSockets = this.getActiveRemoteReplicasSockets();
                    }
                    int remainingFiles = job.getJobFiles().size();
                    if (job.getOperation() == IReplicationJob.ReplicationOperation.REPLICATE) {
                        ILSMIndexReplicationJob LSMComponentJob = null;
                        if (job.getJobType() == IReplicationJob.ReplicationJobType.LSM_COMPONENT) {
                            LSMComponentJob = (ILSMIndexReplicationJob)job;
                            LSMComponentProperties lsmCompProp = new LSMComponentProperties(LSMComponentJob, this.nodeId);
                            requestBuffer = ReplicationProtocol.writeLSMComponentPropertiesRequest(lsmCompProp, requestBuffer);
                            this.sendRequest(replicasSockets, requestBuffer);
                        }
                        for (String filePath : job.getJobFiles()) {
                            --remainingFiles;
                            Path path = Paths.get(filePath, new String[0]);
                            if (Files.notExists(path, new LinkOption[0])) {
                                LOGGER.log(Level.SEVERE, "File deleted before replication: " + filePath);
                                continue;
                            }
                            LOGGER.log(Level.INFO, "Replicating file: " + filePath);
                            RandomAccessFile fromFile = new RandomAccessFile(filePath, "r");
                            Throwable throwable = null;
                            try {
                                FileChannel fileChannel = fromFile.getChannel();
                                Throwable throwable2 = null;
                                try {
                                    long fileSize = fileChannel.size();
                                    if (LSMComponentJob != null) {
                                        ILSMDiskComponent diskComponent = (ILSMDiskComponent)LSMComponentJob.getLSMIndexOperationContext().getComponentsToBeReplicated().get(0);
                                        long lsnOffset = LSMIndexUtil.getComponentFileLSNOffset((ILSMIndex)LSMComponentJob.getLSMIndex(), (ILSMDiskComponent)diskComponent, (String)filePath);
                                        asterixFileProperties.initialize(filePath, fileSize, this.nodeId, isLSMComponentFile, lsnOffset, remainingFiles == 0);
                                    } else {
                                        asterixFileProperties.initialize(filePath, fileSize, this.nodeId, isLSMComponentFile, -1L, remainingFiles == 0);
                                    }
                                    requestBuffer = ReplicationProtocol.writeFileReplicationRequest(requestBuffer, asterixFileProperties, ReplicationProtocol.ReplicationRequestType.REPLICATE_FILE);
                                    Iterator<Map.Entry<String, SocketChannel>> iterator = replicasSockets.entrySet().iterator();
                                    while (iterator.hasNext()) {
                                        Map.Entry<String, SocketChannel> entry = iterator.next();
                                        if (!this.replica2PartitionsMap.get(entry.getKey()).contains(jobPartitionId)) continue;
                                        SocketChannel socketChannel = entry.getValue();
                                        try {
                                            ReplicationProtocol.ReplicationRequestType responseType;
                                            NetworkingUtil.transferBufferToChannel(socketChannel, requestBuffer);
                                            NetworkingUtil.sendFile(fileChannel, socketChannel);
                                            if (!asterixFileProperties.requiresAck() || (responseType = ReplicationManager.waitForResponse(socketChannel, responseBuffer)) == ReplicationProtocol.ReplicationRequestType.ACK) continue;
                                            throw new IOException("Could not receive ACK from replica " + entry.getKey());
                                        }
                                        catch (IOException e) {
                                            this.handleReplicationFailure(socketChannel, e);
                                            iterator.remove();
                                        }
                                        finally {
                                            requestBuffer.position(0);
                                        }
                                    }
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (fileChannel == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            fileChannel.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    fileChannel.close();
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (fromFile == null) continue;
                                if (throwable != null) {
                                    try {
                                        fromFile.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                fromFile.close();
                            }
                        }
                        break block51;
                    }
                    if (job.getOperation() == IReplicationJob.ReplicationOperation.DELETE) {
                        for (String filePath : job.getJobFiles()) {
                            asterixFileProperties.initialize(filePath, -1L, this.nodeId, isLSMComponentFile, -1L, --remainingFiles == 0);
                            ReplicationProtocol.writeFileReplicationRequest(requestBuffer, asterixFileProperties, ReplicationProtocol.ReplicationRequestType.DELETE_FILE);
                            Iterator<Map.Entry<String, SocketChannel>> iterator = replicasSockets.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry<String, SocketChannel> entry = iterator.next();
                                if (!this.replica2PartitionsMap.get(entry.getKey()).contains(jobPartitionId)) continue;
                                SocketChannel socketChannel = entry.getValue();
                                try {
                                    this.sendRequest(replicasSockets, requestBuffer);
                                    if (!asterixFileProperties.requiresAck()) continue;
                                    ReplicationManager.waitForResponse(socketChannel, responseBuffer);
                                }
                                catch (IOException e) {
                                    this.handleReplicationFailure(socketChannel, e);
                                    iterator.remove();
                                }
                                finally {
                                    requestBuffer.position(0);
                                }
                            }
                        }
                    }
                }
                finally {
                    if (job.getExecutionType() == IReplicationJob.ReplicationExecutionType.SYNC) {
                        this.closeReplicaSockets(replicasSockets);
                    }
                }
            }
            finally {
                ReplicationManager.exitReplicatedLSMComponent(job);
            }
        }
    }

    private static void exitReplicatedLSMComponent(IReplicationJob job) throws HyracksDataException {
        if (job.getOperation() == IReplicationJob.ReplicationOperation.REPLICATE && job instanceof ILSMIndexReplicationJob) {
            ILSMIndexReplicationJob aJob = (ILSMIndexReplicationJob)job;
            aJob.endReplication();
        }
    }

    private static ReplicationProtocol.ReplicationRequestType waitForResponse(SocketChannel socketChannel, ByteBuffer responseBuffer) throws IOException {
        if (responseBuffer == null) {
            responseBuffer = ByteBuffer.allocate(4);
        } else {
            responseBuffer.clear();
        }
        ReplicationProtocol.ReplicationRequestType responseFunction = ReplicationProtocol.getRequestType(socketChannel, responseBuffer);
        return responseFunction;
    }

    public boolean isReplicationEnabled() {
        return this.replicationProperties.isParticipant(this.nodeId);
    }

    public synchronized void updateReplicaInfo(Replica replicaNode) {
        Replica replica = this.replicas.get(replicaNode.getNode().getId());
        if (replica.getState() == Replica.ReplicaState.ACTIVE) {
            return;
        }
        replica.getNode().setClusterIp(replicaNode.getNode().getClusterIp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendReplication(boolean force) {
        if (this.replicationJobsProcessor != null && this.replicationJobsProcessor.isAlive()) {
            if (force) {
                this.terminateJobsReplication.set(true);
            }
            this.replicationJobsQ.offer(REPLICATION_JOB_POISON_PILL);
            AtomicBoolean atomicBoolean = this.jobsReplicationSuspended;
            synchronized (atomicBoolean) {
                while (!this.jobsReplicationSuspended.get()) {
                    try {
                        this.jobsReplicationSuspended.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        if (this.txnlogReplicator != null) {
            this.endTxnLogReplicationHandshake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishTxnLogReplicationHandshake() {
        Map<String, SocketChannel> activeRemoteReplicasSockets = this.getActiveRemoteReplicasSockets();
        this.logsRepSockets = new SocketChannel[activeRemoteReplicasSockets.size()];
        int i = 0;
        for (Map.Entry<String, SocketChannel> entry : activeRemoteReplicasSockets.entrySet()) {
            this.logsRepSockets[i] = entry.getValue();
            this.replicationListenerThreads.execute(new TxnLogsReplicationResponseListener(entry.getKey(), entry.getValue()));
            ++i;
        }
        ByteBuffer handshakeBuffer = ByteBuffer.allocate(4).putInt(ReplicationProtocol.ReplicationRequestType.REPLICATE_LOG.ordinal());
        handshakeBuffer.flip();
        for (SocketChannel replicaSocket : this.logsRepSockets) {
            try {
                NetworkingUtil.transferBufferToChannel(replicaSocket, handshakeBuffer);
            }
            catch (IOException e) {
                this.handleReplicationFailure(replicaSocket, e);
            }
            finally {
                handshakeBuffer.position(0);
            }
        }
    }

    private void handleReplicationFailure(SocketChannel socketChannel, Throwable t) {
        block4: {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Could not complete replication request.", t);
            }
            if (socketChannel.isOpen()) {
                try {
                    socketChannel.close();
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                    LOGGER.log(Level.WARNING, "Could not close socket.", e);
                }
            }
        }
        this.reportFailedReplica(this.getReplicaIdBySocket(socketChannel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endTxnLogReplicationHandshake() {
        block24: {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Terminating TxnLogReplicator thread ...");
            }
            this.txnlogReplicator.terminate();
            try {
                this.txnLogReplicatorTask.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block24;
                LOGGER.log(Level.SEVERE, "TxnLogReplicator thread terminated abnormally", e);
            }
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("TxnLogReplicator thread was terminated.");
        }
        ByteBuffer endLogRepHandshake = ByteBuffer.allocate(33).putInt(1).put((byte)0);
        endLogRepHandshake.flip();
        for (SocketChannel replicaSocket : this.logsRepSockets) {
            try {
                NetworkingUtil.transferBufferToChannel(replicaSocket, endLogRepHandshake);
            }
            catch (IOException e) {
                this.handleReplicationFailure(replicaSocket, e);
            }
            finally {
                endLogRepHandshake.position(0);
            }
        }
        if (this.logsRepSockets != null) {
            Map<Integer, Set<String>> map = this.jobCommitAcks;
            synchronized (map) {
                try {
                    long waitStartTime = System.currentTimeMillis();
                    while (!this.jobCommitAcks.isEmpty()) {
                        this.jobCommitAcks.wait(1000L);
                        long waitDuration = System.currentTimeMillis() - waitStartTime;
                        if (waitDuration <= 10000L) continue;
                        LOGGER.log(Level.SEVERE, "Timeout before receving all job ACKs from replicas. Pending jobs (" + this.jobCommitAcks.keySet().toString() + ")");
                        break;
                    }
                }
                catch (InterruptedException e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "Interrupted while waiting for jobs ACK", e);
                    }
                    Thread.currentThread().interrupt();
                }
            }
        }
        ByteBuffer byteBuffer = ReplicationProtocol.getGoodbyeBuffer();
        for (SocketChannel replicaSocket : this.logsRepSockets) {
            try {
                NetworkingUtil.transferBufferToChannel(replicaSocket, byteBuffer);
                replicaSocket.close();
            }
            catch (IOException e) {
                this.handleReplicationFailure(replicaSocket, e);
            }
            finally {
                byteBuffer.position(0);
            }
        }
        this.logsRepSockets = null;
    }

    private void sendShutdownNotifiction() throws IOException {
        Node node = new Node();
        node.setId(this.nodeId);
        node.setClusterIp(NetworkingUtil.getHostAddress(this.hostIPAddressFirstOctet));
        Replica replica = new Replica(node);
        ReplicaEvent event = new ReplicaEvent(replica, IClusterLifecycleListener.ClusterEventType.NODE_SHUTTING_DOWN);
        ByteBuffer buffer = ReplicationProtocol.writeReplicaEventRequest(event);
        Map<String, SocketChannel> replicaSockets = this.getActiveRemoteReplicasSockets();
        this.sendRequest(replicaSockets, buffer);
        this.closeReplicaSockets(replicaSockets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(Map<String, SocketChannel> replicaSockets, ByteBuffer requestBuffer) {
        Iterator<Map.Entry<String, SocketChannel>> iterator = replicaSockets.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, SocketChannel> replicaSocket = iterator.next();
            SocketChannel clientSocket = replicaSocket.getValue();
            try {
                NetworkingUtil.transferBufferToChannel(clientSocket, requestBuffer);
            }
            catch (IOException e) {
                this.handleReplicationFailure(clientSocket, e);
                iterator.remove();
            }
            finally {
                requestBuffer.position(0);
            }
        }
    }

    private void closeReplicaSockets(Map<String, SocketChannel> replicaSockets) {
        ByteBuffer goodbyeBuffer = ReplicationProtocol.getGoodbyeBuffer();
        this.sendRequest(replicaSockets, goodbyeBuffer);
        for (Map.Entry<String, SocketChannel> replicaSocket : replicaSockets.entrySet()) {
            SocketChannel clientSocket = replicaSocket.getValue();
            if (!clientSocket.isOpen()) continue;
            try {
                clientSocket.close();
            }
            catch (IOException e) {
                this.handleReplicationFailure(clientSocket, e);
            }
        }
    }

    public void initializeReplicasState() {
        for (Replica replica : this.replicas.values()) {
            this.checkReplicaState(replica.getNode().getId(), false, false);
        }
    }

    private void checkReplicaState(String replicaId, boolean async, boolean suspendReplication) {
        Replica replica = this.replicas.get(replicaId);
        ReplicaStateChecker connector = new ReplicaStateChecker(replica, this.replicationProperties.getReplicationTimeOut(), this, this.replicationProperties, suspendReplication);
        Future ft = this.asterixAppRuntimeContextProvider.getThreadExecutor().submit((Callable)connector);
        if (!async) {
            while (!ft.isDone()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateReplicaState(String replicaId, Replica.ReplicaState newState, boolean suspendReplication) throws InterruptedException {
        Replica replica = this.replicas.get(replicaId);
        if (replica.getState() == newState) {
            return;
        }
        if (suspendReplication) {
            this.replicationSuspended.set(true);
            if (newState == Replica.ReplicaState.DEAD) {
                Map<Integer, Set<String>> map = this.jobCommitAcks;
                synchronized (map) {
                    for (Integer jobId : this.jobCommitAcks.keySet()) {
                        this.addAckToJob(jobId, replicaId);
                    }
                }
            }
            this.suspendReplication(true);
        }
        replica.setState(newState);
        if (newState == Replica.ReplicaState.ACTIVE) {
            ++this.replicationFactor;
        } else if (newState == Replica.ReplicaState.DEAD && this.replicationFactor > 1) {
            --this.replicationFactor;
        }
        LOGGER.log(Level.WARNING, "Replica " + replicaId + " state changed to: " + newState.name() + ". Replication factor changed to: " + this.replicationFactor);
        if (suspendReplication) {
            this.startReplicationThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAckToJob(int jobId, String replicaId) {
        Map<Integer, Set<String>> map = this.jobCommitAcks;
        synchronized (map) {
            if (!this.jobCommitAcks.containsKey(jobId)) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Invalid job replication ACK received for jobId(" + jobId + ")");
                }
                return;
            }
            Set<String> replicaIds = this.jobCommitAcks.get(jobId);
            replicaIds.add(replicaId);
            if (this.jobCommitAcks.get(jobId).size() == this.replicationFactor && this.replicationJobsPendingAcks.containsKey(jobId)) {
                ILogRecord pendingLog;
                ILogRecord iLogRecord = pendingLog = this.replicationJobsPendingAcks.get(jobId);
                synchronized (iLogRecord) {
                    pendingLog.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasBeenReplicated(ILogRecord logRecord) {
        int jobId = logRecord.getJobId();
        if (this.jobCommitAcks.containsKey(jobId)) {
            Map<Integer, Set<String>> map = this.jobCommitAcks;
            synchronized (map) {
                if (this.jobCommitAcks.get(jobId).size() == this.replicationFactor) {
                    this.jobCommitAcks.remove(jobId);
                    this.replicationJobsPendingAcks.remove(jobId);
                    if (this.jobCommitAcks.size() == 0) {
                        this.jobCommitAcks.notifyAll();
                    }
                    return true;
                }
                this.replicationJobsPendingAcks.putIfAbsent(jobId, logRecord);
                return false;
            }
        }
        return true;
    }

    private Map<String, SocketChannel> getActiveRemoteReplicasSockets() {
        HashMap<String, SocketChannel> replicaNodesSockets = new HashMap<String, SocketChannel>();
        for (Replica replica : this.replicas.values()) {
            if (replica.getState() != Replica.ReplicaState.ACTIVE) continue;
            try {
                SocketChannel sc = this.getReplicaSocket(replica.getId());
                replicaNodesSockets.put(replica.getId(), sc);
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Could not get replica socket", e);
                }
                this.reportFailedReplica(replica.getId());
            }
        }
        return replicaNodesSockets;
    }

    private SocketChannel getReplicaSocket(String replicaId) throws IOException {
        Replica replica = this.replicationProperties.getReplicaById(replicaId);
        SocketChannel sc = SocketChannel.open();
        sc.configureBlocking(true);
        InetSocketAddress address = replica.getAddress(this.replicationProperties);
        sc.connect(new InetSocketAddress(address.getHostString(), address.getPort()));
        return sc;
    }

    public Set<String> getDeadReplicasIds() {
        HashSet<String> replicasIds = new HashSet<String>();
        for (Replica replica : this.replicas.values()) {
            if (replica.getState() != Replica.ReplicaState.DEAD) continue;
            replicasIds.add(replica.getNode().getId());
        }
        return replicasIds;
    }

    public Set<String> getActiveReplicasIds() {
        HashSet<String> replicasIds = new HashSet<String>();
        for (Replica replica : this.replicas.values()) {
            if (replica.getState() != Replica.ReplicaState.ACTIVE) continue;
            replicasIds.add(replica.getNode().getId());
        }
        return replicasIds;
    }

    public int getActiveReplicasCount() {
        return this.getActiveReplicasIds().size();
    }

    public void start() {
    }

    public void dumpState(OutputStream os) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean dumpState, OutputStream ouputStream) throws IOException {
        this.suspendReplication(false);
        if (!this.replicationStrategy.getRemoteReplicas(this.nodeId).isEmpty()) {
            this.sendShutdownNotifiction();
        }
        Set activeRemotePrimaryReplicas = this.replicationStrategy.getRemotePrimaryReplicas(this.nodeId).stream().map(Replica::getId).filter(this.getActiveReplicasIds()::contains).collect(Collectors.toSet());
        if (!activeRemotePrimaryReplicas.isEmpty()) {
            Set<String> set = this.shuttingDownReplicaIds;
            synchronized (set) {
                while (!this.shuttingDownReplicaIds.containsAll(activeRemotePrimaryReplicas)) {
                    try {
                        this.shuttingDownReplicaIds.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        LOGGER.log(Level.INFO, "Got shutdown notification from all remote replicas");
        this.asterixAppRuntimeContextProvider.getAppContext().getReplicationChannel().close();
        LOGGER.log(Level.INFO, "Replication manager stopped.");
    }

    public void reportReplicaEvent(ReplicaEvent event) {
        this.replicaEventsQ.offer(event);
    }

    public void reportFailedReplica(String replicaId) {
        Replica replica = this.replicas.get(replicaId);
        if (replica == null) {
            return;
        }
        if (replica.getState() == Replica.ReplicaState.DEAD) {
            return;
        }
        this.terminateJobsReplication.set(true);
        ReplicaEvent event = new ReplicaEvent(replica, IClusterLifecycleListener.ClusterEventType.NODE_FAILURE);
        this.reportReplicaEvent(event);
    }

    private String getReplicaIdBySocket(SocketChannel socketChannel) {
        InetSocketAddress socketAddress = NetworkingUtil.getSocketAddress(socketChannel);
        for (Replica replica : this.replicas.values()) {
            InetSocketAddress replicaAddress = replica.getAddress(this.replicationProperties);
            if (!replicaAddress.getHostName().equals(socketAddress.getHostName()) || replicaAddress.getPort() != socketAddress.getPort()) continue;
            return replica.getId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReplicationThreads() throws InterruptedException {
        this.replicationJobsProcessor = new ReplicationJobsProccessor();
        if (this.logsRepSockets == null) {
            this.establishTxnLogReplicationHandshake();
            this.getAndInitNewPage();
            this.txnlogReplicator = new TxnLogReplicator(this.emptyLogBuffersQ, this.pendingFlushLogBuffersQ);
            this.txnLogReplicatorTask = this.asterixAppRuntimeContextProvider.getThreadExecutor().submit((Callable)this.txnlogReplicator);
        }
        this.replicationJobsProcessor.start();
        if (!this.replicationMonitor.isAlive()) {
            this.replicationMonitor.start();
        }
        AtomicBoolean atomicBoolean = this.replicationSuspended;
        synchronized (atomicBoolean) {
            LOGGER.log(Level.INFO, "Replication started/resumed");
            this.replicationSuspended.set(false);
            this.replicationSuspended.notifyAll();
        }
    }

    public void requestFlushLaggingReplicaIndexes(long nonSharpCheckpointTargetLSN) throws IOException {
        long startLSN = this.logManager.getAppendLSN();
        Set<String> replicaIds = this.getActiveReplicasIds();
        if (replicaIds.isEmpty()) {
            return;
        }
        ByteBuffer requestBuffer = ByteBuffer.allocate(INITIAL_BUFFER_SIZE);
        for (String replicaId : replicaIds) {
            Map<Long, String> laggingIndexes = this.replicaResourcesManager.getLaggingReplicaIndexesId2PathMap(replicaId, nonSharpCheckpointTargetLSN);
            if (laggingIndexes.size() <= 0) continue;
            ReplicaIndexFlushRequest laggingIndexesResponse = null;
            try (SocketChannel socketChannel = this.getReplicaSocket(replicaId);){
                ReplicaIndexFlushRequest laggingIndexesRequest = new ReplicaIndexFlushRequest(laggingIndexes.keySet());
                requestBuffer = ReplicationProtocol.writeGetReplicaIndexFlushRequest(requestBuffer, laggingIndexesRequest);
                NetworkingUtil.transferBufferToChannel(socketChannel, requestBuffer);
                ReplicationProtocol.ReplicationRequestType responseFunction = ReplicationManager.waitForResponse(socketChannel, requestBuffer);
                if (responseFunction == ReplicationProtocol.ReplicationRequestType.FLUSH_INDEX) {
                    requestBuffer = ReplicationProtocol.readRequest(socketChannel, requestBuffer);
                    laggingIndexesResponse = ReplicationProtocol.readReplicaIndexFlushRequest(requestBuffer);
                }
                ReplicationProtocol.sendGoodbye(socketChannel);
            }
            if (laggingIndexesResponse == null) continue;
            for (Long resouceId : laggingIndexesResponse.getLaggingRescouresIds()) {
                String indexPath = laggingIndexes.get(resouceId);
                Map<Long, Long> indexLSNMap = this.replicaResourcesManager.getReplicaIndexLSNMap(indexPath);
                indexLSNMap.put(-1L, startLSN);
                this.replicaResourcesManager.updateReplicaIndexLSNMap(indexPath, indexLSNMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxRemoteLSN(Set<String> remoteReplicas) throws IOException {
        long maxRemoteLSN = 0L;
        ReplicationProtocol.writeGetReplicaMaxLSNRequest(this.dataBuffer);
        HashMap<String, SocketChannel> replicaSockets = new HashMap<String, SocketChannel>();
        try {
            SocketChannel clientSocket;
            for (String replicaId : remoteReplicas) {
                replicaSockets.put(replicaId, this.getReplicaSocket(replicaId));
            }
            for (Map.Entry replicaSocket : replicaSockets.entrySet()) {
                clientSocket = (SocketChannel)replicaSocket.getValue();
                NetworkingUtil.transferBufferToChannel(clientSocket, this.dataBuffer);
                this.dataBuffer.position(0);
            }
            for (Map.Entry replicaSocket : replicaSockets.entrySet()) {
                clientSocket = (SocketChannel)replicaSocket.getValue();
                NetworkingUtil.readBytes(clientSocket, this.dataBuffer, 8);
                maxRemoteLSN = Math.max(maxRemoteLSN, this.dataBuffer.getLong());
            }
        }
        finally {
            this.closeReplicaSockets(replicaSockets);
        }
        return maxRemoteLSN;
    }

    public void requestReplicaFiles(String selectedReplicaId, Set<Integer> partitionsToRecover, Set<String> existingFiles) throws IOException {
        ReplicaFilesRequest request = new ReplicaFilesRequest(partitionsToRecover, existingFiles);
        this.dataBuffer = ReplicationProtocol.writeGetReplicaFilesRequest(this.dataBuffer, request);
        try (SocketChannel socketChannel = this.getReplicaSocket(selectedReplicaId);){
            NetworkingUtil.transferBufferToChannel(socketChannel, this.dataBuffer);
            ReplicationProtocol.ReplicationRequestType responseFunction = ReplicationProtocol.getRequestType(socketChannel, this.dataBuffer);
            while (responseFunction != ReplicationProtocol.ReplicationRequestType.GOODBYE) {
                this.dataBuffer = ReplicationProtocol.readRequest(socketChannel, this.dataBuffer);
                LSMIndexFileProperties fileProperties = ReplicationProtocol.readFileReplicationRequest(this.dataBuffer);
                String indexPath = this.replicaResourcesManager.getIndexPath(fileProperties);
                String destFilePath = indexPath + File.separator + fileProperties.getFileName();
                File destFile = new File(destFilePath);
                destFile.createNewFile();
                try (RandomAccessFile fileOutputStream = new RandomAccessFile(destFile, "rw");
                     FileChannel fileChannel = fileOutputStream.getChannel();){
                    fileOutputStream.setLength(fileProperties.getFileSize());
                    NetworkingUtil.downloadFile(fileChannel, socketChannel);
                    fileChannel.force(true);
                }
                if (!fileProperties.isLSMComponentFile() && !fileProperties.getNodeId().equals(this.nodeId)) {
                    this.replicaResourcesManager.initializeReplicaIndexLSNMap(indexPath, this.logManager.getAppendLSN());
                }
                responseFunction = ReplicationProtocol.getRequestType(socketChannel, this.dataBuffer);
            }
            ReplicationProtocol.sendGoodbye(socketChannel);
        }
    }

    public int getLogPageSize() {
        return this.replicationProperties.getLogBufferPageSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void replicateTxnLogBatch(ByteBuffer buffer) {
        SocketChannel[] socketChannelArray;
        try {
            while (this.replicationSuspended.get()) {
                socketChannelArray = this.replicationSuspended;
                // MONITORENTER : this.replicationSuspended
                this.replicationSuspended.wait();
                // MONITOREXIT : socketChannelArray
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.txnLogsBatchSizeBuffer.clear();
        this.txnLogsBatchSizeBuffer.putInt(buffer.remaining());
        this.txnLogsBatchSizeBuffer.flip();
        buffer.mark();
        socketChannelArray = this.logsRepSockets;
        int n = socketChannelArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                buffer.position(buffer.limit());
                return;
            }
            SocketChannel replicaSocket = socketChannelArray[n2];
            try {
                NetworkingUtil.transferBufferToChannel(replicaSocket, this.txnLogsBatchSizeBuffer);
                NetworkingUtil.transferBufferToChannel(replicaSocket, buffer);
            }
            catch (IOException e) {
                this.handleReplicationFailure(replicaSocket, e);
            }
            finally {
                this.txnLogsBatchSizeBuffer.position(0);
                buffer.reset();
            }
            ++n2;
        }
    }

    static /* synthetic */ int access$700() {
        return INITIAL_BUFFER_SIZE;
    }

    private class TxnLogsReplicationResponseListener
    implements Runnable {
        final SocketChannel replicaSocket;
        final String replicaId;

        public TxnLogsReplicationResponseListener(String replicaId, SocketChannel replicaSocket) {
            this.replicaId = replicaId;
            this.replicaSocket = replicaSocket;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("TxnLogs Replication Listener Thread");
            LOGGER.log(Level.INFO, "Started listening on socket: " + this.replicaSocket.socket().getRemoteSocketAddress());
            try (BufferedReader incomingResponse = new BufferedReader(new InputStreamReader(this.replicaSocket.socket().getInputStream()));){
                String responseLine;
                while ((responseLine = incomingResponse.readLine()) != null) {
                    String ackFrom = ReplicationProtocol.getNodeIdFromLogAckMessage(responseLine);
                    int jobId = ReplicationProtocol.getJobIdFromLogAckMessage(responseLine);
                    ReplicationManager.this.addAckToJob(jobId, ackFrom);
                }
            }
            catch (AsynchronousCloseException e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Replication listener stopped for remote replica: " + this.replicaId, e);
                }
            }
            catch (IOException e) {
                ReplicationManager.this.handleReplicationFailure(this.replicaSocket, e);
            }
        }
    }

    private class ReplicationJobsProccessor
    extends Thread {
        Map<String, SocketChannel> replicaSockets;
        ByteBuffer reusableBuffer = ByteBuffer.allocate(ReplicationManager.access$700());

        private ReplicationJobsProccessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName("ReplicationJobsProccessor Thread");
            ReplicationManager.this.terminateJobsReplication.set(false);
            ReplicationManager.this.jobsReplicationSuspended.set(false);
            block6: while (true) {
                try {
                    while (true) {
                        if (ReplicationManager.this.terminateJobsReplication.get()) {
                            this.closeSockets();
                            break block6;
                        }
                        IReplicationJob job = (IReplicationJob)ReplicationManager.this.replicationJobsQ.take();
                        if (job == REPLICATION_JOB_POISON_PILL) {
                            ReplicationManager.this.terminateJobsReplication.set(true);
                            continue;
                        }
                        if (this.replicaSockets == null) {
                            this.replicaSockets = ReplicationManager.this.getActiveRemoteReplicasSockets();
                        }
                        ReplicationManager.this.processJob(job, this.replicaSockets, this.reusableBuffer);
                        if (!ReplicationManager.this.replicationJobsQ.isEmpty()) continue;
                        LOGGER.log(Level.INFO, "No pending replication jobs. Closing connections to replicas");
                        this.closeSockets();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "Couldn't complete processing replication job", e);
                    continue;
                }
                break;
            }
            AtomicBoolean atomicBoolean = ReplicationManager.this.jobsReplicationSuspended;
            synchronized (atomicBoolean) {
                ReplicationManager.this.jobsReplicationSuspended.set(true);
                ReplicationManager.this.jobsReplicationSuspended.notifyAll();
            }
            LOGGER.log(Level.INFO, "ReplicationJobsProccessor stopped. ");
        }

        private void closeSockets() {
            if (this.replicaSockets != null) {
                ReplicationManager.this.closeReplicaSockets(this.replicaSockets);
                this.replicaSockets.clear();
                this.replicaSockets = null;
            }
        }
    }

    private class ReplicasEventsMonitor
    extends Thread {
        ReplicaEvent event;

        private ReplicasEventsMonitor() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.event = (ReplicaEvent)ReplicationManager.this.replicaEventsQ.take();
                        switch (this.event.getEventType()) {
                            case NODE_FAILURE: {
                                this.handleReplicaFailure(this.event.getReplica().getId());
                                break;
                            }
                            case NODE_JOIN: {
                                ReplicationManager.this.updateReplicaInfo(this.event.getReplica());
                                ReplicationManager.this.checkReplicaState(this.event.getReplica().getId(), false, true);
                                break;
                            }
                            case NODE_SHUTTING_DOWN: {
                                this.handleShutdownEvent(this.event.getReplica().getId());
                                break;
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }

        public void handleReplicaFailure(String replicaId) throws InterruptedException {
            Replica replica = (Replica)ReplicationManager.this.replicas.get(replicaId);
            if (replica.getState() == Replica.ReplicaState.DEAD) {
                return;
            }
            ReplicationManager.this.updateReplicaState(replicaId, Replica.ReplicaState.DEAD, true);
            ReplicationManager.this.replicaResourcesManager.cleanInvalidLSMComponents(replicaId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleShutdownEvent(String replicaId) {
            Set set = ReplicationManager.this.shuttingDownReplicaIds;
            synchronized (set) {
                ReplicationManager.this.shuttingDownReplicaIds.add(replicaId);
                ReplicationManager.this.shuttingDownReplicaIds.notifyAll();
            }
        }
    }
}

