/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin.tokenorder;

import java.util.Collection;
import java.util.HashMap;
import org.apache.asterix.fuzzyjoin.tokenizer.Token;
import org.apache.asterix.fuzzyjoin.tokenorder.TokenRank;

public class TokenRankBufferedFrequency
implements TokenRank {
    private static final long serialVersionUID = 1L;
    private final HashMap<Token, Integer> ranksMap = new HashMap();
    private int crtRank = 0;

    @Override
    public int add(String stringWithCount) {
        int end = stringWithCount.lastIndexOf(95);
        int count = 0;
        for (int i = end + 1; i < stringWithCount.length(); ++i) {
            count = count * 10 + (stringWithCount.charAt(i) - 48);
        }
        return this.add(stringWithCount.substring(0, end), count);
    }

    public int add(String string, int count) {
        Token token = new Token(string, 0, string.length(), count);
        return this.add(token);
    }

    public int add(Token token) {
        int prevRank = this.crtRank++;
        this.ranksMap.put(token, prevRank);
        return prevRank;
    }

    @Override
    public Integer getRank(String token) {
        throw new UnsupportedOperationException();
    }

    public Integer getRank(Token token) {
        return this.ranksMap.get(token);
    }

    @Override
    public Collection<Integer> getTokenRanks(Iterable<String> tokens) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "[" + this.crtRank + ",\n " + this.ranksMap + "\n]";
    }
}

