/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ICursorInitialState;
import org.apache.hyracks.storage.am.common.api.IIndexAccessor;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.tuples.ConcatenatingTupleReference;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndex;

public class OnDiskInvertedIndexRangeSearchCursor
implements IIndexCursor {
    private final BTree btree;
    private final IIndexAccessor btreeAccessor;
    private final IInvertedIndex invIndex;
    private final IIndexOperationContext opCtx;
    private final IInvertedListCursor invListCursor;
    private boolean unpinNeeded;
    private final IIndexCursor btreeCursor;
    private RangePredicate btreePred;
    private final PermutingTupleReference tokenTuple;
    private ConcatenatingTupleReference concatTuple;

    public OnDiskInvertedIndexRangeSearchCursor(IInvertedIndex invIndex, IIndexOperationContext opCtx) {
        this.btree = ((OnDiskInvertedIndex)invIndex).getBTree();
        this.btreeAccessor = this.btree.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        this.invIndex = invIndex;
        this.opCtx = opCtx;
        int[] fieldPermutation = new int[invIndex.getTokenTypeTraits().length];
        for (int i = 0; i < invIndex.getTokenTypeTraits().length; ++i) {
            fieldPermutation[i] = i;
        }
        this.tokenTuple = new PermutingTupleReference(fieldPermutation);
        this.btreeCursor = this.btreeAccessor.createSearchCursor(false);
        this.concatTuple = new ConcatenatingTupleReference(2);
        this.invListCursor = invIndex.createInvertedListCursor();
        this.unpinNeeded = false;
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException, IndexException {
        this.btreePred = (RangePredicate)searchPred;
        try {
            this.btreeAccessor.search(this.btreeCursor, (ISearchPredicate)this.btreePred);
        }
        catch (IndexException e) {
            throw new HyracksDataException((Throwable)e);
        }
        this.invListCursor.pinPages();
        this.unpinNeeded = true;
    }

    public boolean hasNext() throws HyracksDataException, IndexException {
        if (this.invListCursor.hasNext()) {
            return true;
        }
        if (this.unpinNeeded) {
            this.invListCursor.unpinPages();
            this.unpinNeeded = false;
        }
        if (!this.btreeCursor.hasNext()) {
            return false;
        }
        this.btreeCursor.next();
        this.tokenTuple.reset(this.btreeCursor.getTuple());
        try {
            this.invIndex.openInvertedListCursor(this.invListCursor, (ITupleReference)this.tokenTuple, this.opCtx);
        }
        catch (IndexException e) {
            throw new HyracksDataException((Throwable)e);
        }
        this.invListCursor.pinPages();
        this.invListCursor.hasNext();
        this.unpinNeeded = true;
        this.concatTuple.reset();
        this.concatTuple.addTuple((ITupleReference)this.tokenTuple);
        return true;
    }

    public void next() throws HyracksDataException {
        this.invListCursor.next();
        if (this.concatTuple.hasMaxTuples()) {
            this.concatTuple.removeLastTuple();
        }
        this.concatTuple.addTuple(this.invListCursor.getTuple());
    }

    public void close() throws HyracksDataException {
        if (this.unpinNeeded) {
            this.invListCursor.unpinPages();
            this.unpinNeeded = false;
        }
        this.btreeCursor.close();
    }

    public void reset() throws HyracksDataException, IndexException {
        if (this.unpinNeeded) {
            this.invListCursor.unpinPages();
            this.unpinNeeded = false;
        }
        this.btreeCursor.close();
    }

    public ITupleReference getTuple() {
        return this.concatTuple;
    }
}

