/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.FixedSizeTupleReference;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class FixedSizeElementInvertedListCursor
implements IInvertedListCursor {
    private final IBufferCache bufferCache;
    private final int fileId;
    private final int elementSize;
    private int currentElementIx;
    private int currentOff;
    private int currentPageIx;
    private int startPageId;
    private int endPageId;
    private int startOff;
    private int numElements;
    private final FixedSizeTupleReference tuple;
    private ICachedPage[] pages = new ICachedPage[10];
    private int[] elementIndexes = new int[10];
    private boolean pinned = false;

    public FixedSizeElementInvertedListCursor(IBufferCache bufferCache, int fileId, ITypeTraits[] invListFields) {
        this.bufferCache = bufferCache;
        this.fileId = fileId;
        this.currentElementIx = 0;
        this.currentPageIx = 0;
        int tmp = 0;
        for (int i = 0; i < invListFields.length; ++i) {
            tmp += invListFields[i].getFixedLength();
        }
        this.elementSize = tmp;
        this.currentOff = -this.elementSize;
        this.tuple = new FixedSizeTupleReference(invListFields);
    }

    @Override
    public boolean hasNext() {
        return this.currentElementIx < this.numElements;
    }

    @Override
    public void next() {
        if (this.currentOff + 2 * this.elementSize > this.bufferCache.getPageSize()) {
            ++this.currentPageIx;
            this.currentOff = 0;
        } else {
            this.currentOff += this.elementSize;
        }
        ++this.currentElementIx;
        this.tuple.reset(this.pages[this.currentPageIx].getBuffer().array(), this.currentOff);
    }

    @Override
    public void pinPages() throws HyracksDataException {
        if (this.pinned) {
            return;
        }
        int pix = 0;
        for (int i = this.startPageId; i <= this.endPageId; ++i) {
            this.pages[pix] = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)i), false);
            this.pages[pix].acquireReadLatch();
            ++pix;
        }
        this.pinned = true;
    }

    @Override
    public void unpinPages() throws HyracksDataException {
        int numPages = this.endPageId - this.startPageId + 1;
        for (int i = 0; i < numPages; ++i) {
            this.pages[i].releaseReadLatch();
            this.bufferCache.unpin(this.pages[i]);
        }
        this.pinned = false;
    }

    private void positionCursor(int elementIx) {
        int numPages = this.endPageId - this.startPageId + 1;
        this.currentPageIx = this.binarySearch(this.elementIndexes, 0, numPages, elementIx);
        if (this.currentPageIx < 0) {
            throw new IndexOutOfBoundsException("Requested index: " + elementIx + " from array with numElements: " + this.numElements);
        }
        if (this.currentPageIx == 0) {
            this.currentOff = this.startOff + elementIx * this.elementSize;
        } else {
            int relativeElementIx = elementIx - this.elementIndexes[this.currentPageIx - 1] - 1;
            this.currentOff = relativeElementIx * this.elementSize;
        }
        this.currentElementIx = elementIx;
        this.tuple.reset(this.pages[this.currentPageIx].getBuffer().array(), this.currentOff);
    }

    @Override
    public boolean containsKey(ITupleReference searchTuple, MultiComparator invListCmp) throws HyracksDataException {
        int begin = 0;
        int end = this.numElements - 1;
        while (begin <= end) {
            int mid = (begin + end) / 2;
            this.positionCursor(mid);
            int cmp = invListCmp.compare(searchTuple, (ITupleReference)this.tuple);
            if (cmp < 0) {
                end = mid - 1;
                continue;
            }
            if (cmp > 0) {
                begin = mid + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public void reset(int startPageId, int endPageId, int startOff, int numElements) {
        this.startPageId = startPageId;
        this.endPageId = endPageId;
        this.startOff = startOff;
        this.numElements = numElements;
        this.currentElementIx = 0;
        this.currentPageIx = 0;
        this.currentOff = startOff - this.elementSize;
        int numPages = endPageId - startPageId + 1;
        if (numPages > this.pages.length) {
            this.pages = new ICachedPage[endPageId - startPageId + 1];
            this.elementIndexes = new int[endPageId - startPageId + 1];
        }
        int cumulElements = (this.bufferCache.getPageSize() - startOff) / this.elementSize;
        this.elementIndexes[0] = cumulElements - 1;
        for (int i = 1; i < numPages - 1; ++i) {
            this.elementIndexes[i] = this.elementIndexes[i - 1] + this.bufferCache.getPageSize() / this.elementSize;
        }
        this.elementIndexes[numPages - 1] = numElements - 1;
    }

    @Override
    public String printInvList(ISerializerDeserializer[] serdes) throws HyracksDataException {
        int oldCurrentOff = this.currentOff;
        int oldCurrentPageId = this.currentPageIx;
        int oldCurrentElementIx = this.currentElementIx;
        this.currentOff = this.startOff - this.elementSize;
        this.currentPageIx = 0;
        this.currentElementIx = 0;
        StringBuilder strBuilder = new StringBuilder();
        while (this.hasNext()) {
            this.next();
            for (int i = 0; i < this.tuple.getFieldCount(); ++i) {
                ByteArrayInputStream inStream = new ByteArrayInputStream(this.tuple.getFieldData(i), this.tuple.getFieldStart(i), this.tuple.getFieldLength(i));
                DataInputStream dataIn = new DataInputStream(inStream);
                Object o = serdes[i].deserialize((DataInput)dataIn);
                strBuilder.append(o.toString());
                if (i + 1 >= this.tuple.getFieldCount()) continue;
                strBuilder.append(",");
            }
            strBuilder.append(" ");
        }
        this.currentOff = oldCurrentOff;
        this.currentPageIx = oldCurrentPageId;
        this.currentElementIx = oldCurrentElementIx;
        return strBuilder.toString();
    }

    @Override
    public String printCurrentElement(ISerializerDeserializer[] serdes) throws HyracksDataException {
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < this.tuple.getFieldCount(); ++i) {
            ByteArrayInputStream inStream = new ByteArrayInputStream(this.tuple.getFieldData(i), this.tuple.getFieldStart(i), this.tuple.getFieldLength(i));
            DataInputStream dataIn = new DataInputStream(inStream);
            Object o = serdes[i].deserialize((DataInput)dataIn);
            strBuilder.append(o.toString());
            if (i + 1 >= this.tuple.getFieldCount()) continue;
            strBuilder.append(",");
        }
        return strBuilder.toString();
    }

    private int binarySearch(int[] arr, int arrStart, int arrLength, int key) {
        int begin = arrStart;
        int end = arrStart + arrLength - 1;
        while (begin <= end) {
            int mid = (begin + end) / 2;
            int cmp = key - arr[mid];
            if (cmp < 0) {
                end = mid - 1;
                continue;
            }
            if (cmp > 0) {
                begin = mid + 1;
                continue;
            }
            return mid;
        }
        if (begin > arr.length - 1) {
            return -1;
        }
        if (key < arr[begin]) {
            return begin;
        }
        return -1;
    }

    @Override
    public int compareTo(IInvertedListCursor invListCursor) {
        return this.numElements - invListCursor.size();
    }

    @Override
    public int getEndPageId() {
        return this.endPageId;
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public int getStartOff() {
        return this.startOff;
    }

    @Override
    public int getStartPageId() {
        return this.startPageId;
    }

    public int getOffset() {
        return this.currentOff;
    }

    public ICachedPage getPage() {
        return this.pages[this.currentPageIx];
    }

    @Override
    public ITupleReference getTuple() {
        return this.tuple;
    }
}

