/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.inmemory;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.api.TreeIndexException;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.common.tuples.ConcatenatingTupleReference;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;

public class InMemoryInvertedListCursor
implements IInvertedListCursor {
    private RangePredicate btreePred;
    private BTree.BTreeAccessor btreeAccessor;
    private IIndexCursor btreeCursor;
    private boolean cursorNeedsClose = false;
    private IIndexCursor countingCursor;
    private MultiComparator tokenFieldsCmp;
    private MultiComparator btreeCmp;
    private final PermutingTupleReference resultTuple;
    private final ConcatenatingTupleReference btreeSearchTuple;
    private final ArrayTupleBuilder tokenTupleBuilder;
    private final ArrayTupleReference tokenTuple = new ArrayTupleReference();
    private int numElements = -1;

    public InMemoryInvertedListCursor(int invListFieldCount, int tokenFieldCount) {
        int[] fieldPermutation = new int[invListFieldCount];
        for (int i = 0; i < invListFieldCount; ++i) {
            fieldPermutation[i] = tokenFieldCount + i;
        }
        this.resultTuple = new PermutingTupleReference(fieldPermutation);
        this.btreeSearchTuple = new ConcatenatingTupleReference(2);
        this.tokenTupleBuilder = new ArrayTupleBuilder(tokenFieldCount);
    }

    public void prepare(BTree.BTreeAccessor btreeAccessor, RangePredicate btreePred, MultiComparator tokenFieldsCmp, MultiComparator btreeCmp) throws HyracksDataException, IndexException {
        if (this.btreeAccessor != btreeAccessor) {
            this.btreeAccessor = btreeAccessor;
            this.btreeCursor = btreeAccessor.createSearchCursor(false);
            this.countingCursor = btreeAccessor.createCountingSearchCursor();
            this.btreePred = btreePred;
            this.btreePred.setLowKeyComparator(tokenFieldsCmp);
            this.btreePred.setHighKeyComparator(tokenFieldsCmp);
            this.tokenFieldsCmp = tokenFieldsCmp;
            this.btreeCmp = btreeCmp;
        }
    }

    @Override
    public int compareTo(IInvertedListCursor cursor) {
        return this.size() - cursor.size();
    }

    public void reset(ITupleReference tuple) throws HyracksDataException, IndexException {
        this.numElements = -1;
        TupleUtils.copyTuple((ArrayTupleBuilder)this.tokenTupleBuilder, (ITupleReference)tuple, (int)tuple.getFieldCount());
        this.tokenTuple.reset(this.tokenTupleBuilder.getFieldEndOffsets(), this.tokenTupleBuilder.getByteArray());
        this.btreeSearchTuple.reset();
        this.btreeSearchTuple.addTuple((ITupleReference)this.tokenTuple);
        this.btreeCursor.reset();
        this.countingCursor.reset();
    }

    @Override
    public void reset(int startPageId, int endPageId, int startOff, int numElements) {
    }

    @Override
    public void pinPages() throws HyracksDataException, IndexException {
        this.btreePred.setLowKeyComparator(this.tokenFieldsCmp);
        this.btreePred.setHighKeyComparator(this.tokenFieldsCmp);
        this.btreePred.setLowKey((ITupleReference)this.tokenTuple, true);
        this.btreePred.setHighKey((ITupleReference)this.tokenTuple, true);
        this.btreeAccessor.search(this.btreeCursor, (ISearchPredicate)this.btreePred);
        this.cursorNeedsClose = true;
    }

    @Override
    public void unpinPages() throws HyracksDataException {
        if (this.cursorNeedsClose) {
            this.btreeCursor.close();
            this.cursorNeedsClose = false;
        }
    }

    @Override
    public boolean hasNext() throws HyracksDataException, IndexException {
        return this.btreeCursor.hasNext();
    }

    @Override
    public void next() throws HyracksDataException {
        this.btreeCursor.next();
    }

    @Override
    public ITupleReference getTuple() {
        this.resultTuple.reset(this.btreeCursor.getTuple());
        return this.resultTuple;
    }

    @Override
    public int size() {
        if (this.numElements < 0) {
            this.btreePred.setLowKeyComparator(this.tokenFieldsCmp);
            this.btreePred.setHighKeyComparator(this.tokenFieldsCmp);
            this.btreePred.setLowKey((ITupleReference)this.tokenTuple, true);
            this.btreePred.setHighKey((ITupleReference)this.tokenTuple, true);
            try {
                this.btreeAccessor.search(this.countingCursor, (ISearchPredicate)this.btreePred);
                while (this.countingCursor.hasNext()) {
                    this.countingCursor.next();
                    ITupleReference countTuple = this.countingCursor.getTuple();
                    this.numElements = IntegerPointable.getInteger((byte[])countTuple.getFieldData(0), (int)countTuple.getFieldStart(0));
                }
            }
            catch (HyracksDataException e) {
                e.printStackTrace();
            }
            catch (IndexException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.countingCursor.close();
                }
                catch (HyracksDataException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.numElements;
    }

    @Override
    public int getStartPageId() {
        return 0;
    }

    @Override
    public int getEndPageId() {
        return 0;
    }

    @Override
    public int getStartOff() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(ITupleReference searchTuple, MultiComparator invListCmp) throws HyracksDataException, IndexException {
        this.unpinPages();
        this.btreeSearchTuple.addTuple(searchTuple);
        this.btreePred.setLowKeyComparator(this.btreeCmp);
        this.btreePred.setHighKeyComparator(this.btreeCmp);
        this.btreePred.setLowKey((ITupleReference)this.btreeSearchTuple, true);
        this.btreePred.setHighKey((ITupleReference)this.btreeSearchTuple, true);
        try {
            this.btreeAccessor.search(this.btreeCursor, (ISearchPredicate)this.btreePred);
        }
        catch (TreeIndexException e) {
            this.btreeSearchTuple.removeLastTuple();
            throw new HyracksDataException((Throwable)e);
        }
        boolean containsKey = false;
        try {
            containsKey = this.btreeCursor.hasNext();
        }
        finally {
            this.btreeCursor.close();
            this.btreeCursor.reset();
            this.btreeSearchTuple.removeLastTuple();
        }
        return containsKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String printInvList(ISerializerDeserializer[] serdes) throws HyracksDataException, IndexException {
        StringBuilder strBuilder = new StringBuilder();
        try {
            while (this.btreeCursor.hasNext()) {
                this.btreeCursor.next();
                ITupleReference tuple = this.btreeCursor.getTuple();
                ByteArrayInputStream inStream = new ByteArrayInputStream(tuple.getFieldData(1), tuple.getFieldStart(1), tuple.getFieldLength(1));
                DataInputStream dataIn = new DataInputStream(inStream);
                Object o = serdes[0].deserialize((DataInput)dataIn);
                strBuilder.append(o.toString() + " ");
            }
        }
        finally {
            this.btreeCursor.close();
            this.btreeCursor.reset();
        }
        try {
            this.btreeAccessor.search(this.btreeCursor, (ISearchPredicate)this.btreePred);
        }
        catch (TreeIndexException e) {
            throw new HyracksDataException((Throwable)e);
        }
        return strBuilder.toString();
    }

    @Override
    public String printCurrentElement(ISerializerDeserializer[] serdes) throws HyracksDataException {
        return null;
    }
}

