/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.inmemory;

import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexTokenizingTupleIterator;

public class InMemoryInvertedIndexOpContext
implements IIndexOperationContext {
    public IndexOperation op;
    public final BTree btree;
    public RangePredicate btreePred;
    public BTree.BTreeAccessor btreeAccessor;
    public MultiComparator btreeCmp;
    public IBinaryComparatorFactory[] tokenCmpFactories;
    public MultiComparator tokenFieldsCmp;
    protected final IBinaryTokenizerFactory tokenizerFactory;
    public InvertedIndexTokenizingTupleIterator tupleIter;

    public InMemoryInvertedIndexOpContext(BTree btree, IBinaryComparatorFactory[] tokenCmpFactories, IBinaryTokenizerFactory tokenizerFactory) {
        this.btree = btree;
        this.tokenCmpFactories = tokenCmpFactories;
        this.tokenizerFactory = tokenizerFactory;
    }

    public void setOperation(IndexOperation newOp) {
        switch (newOp) {
            case INSERT: 
            case DELETE: {
                if (this.tupleIter != null) break;
                this.setTokenizingTupleIterator();
                break;
            }
            case SEARCH: {
                if (this.btreePred != null) break;
                this.btreePred = new RangePredicate(null, null, true, true, null, null);
                this.btreeAccessor = (BTree.BTreeAccessor)this.btree.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                this.btreeCmp = MultiComparator.create((IBinaryComparatorFactory[])this.btree.getComparatorFactories());
                this.tokenFieldsCmp = MultiComparator.create((IBinaryComparatorFactory[])this.tokenCmpFactories);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operation " + newOp);
            }
        }
        this.op = newOp;
    }

    public void reset() {
        this.op = null;
    }

    public IndexOperation getOperation() {
        return this.op;
    }

    protected void setTokenizingTupleIterator() {
        IBinaryTokenizer tokenizer = this.tokenizerFactory.createTokenizer();
        this.tupleIter = new InvertedIndexTokenizingTupleIterator(this.tokenCmpFactories.length, this.btree.getFieldCount() - this.tokenCmpFactories.length, tokenizer);
    }
}

