/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.inmemory;

import org.apache.hyracks.api.context.IHyracksCommonContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearcher;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.inmemory.InMemoryInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchPredicate;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.TOccurrenceSearcher;

public class InMemoryInvertedIndexAccessor
implements IInvertedIndexAccessor {
    protected final IHyracksCommonContext hyracksCtx = new OnDiskInvertedIndex.DefaultHyracksCommonContext();
    protected final IInvertedIndexSearcher searcher;
    protected IIndexOperationContext opCtx;
    protected InMemoryInvertedIndex index;
    protected BTree.BTreeAccessor btreeAccessor;

    public InMemoryInvertedIndexAccessor(InMemoryInvertedIndex index, IIndexOperationContext opCtx) throws HyracksDataException {
        this.opCtx = opCtx;
        this.index = index;
        this.searcher = this.createSearcher();
        this.btreeAccessor = (BTree.BTreeAccessor)index.getBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
    }

    public void insert(ITupleReference tuple) throws HyracksDataException, IndexException {
        this.opCtx.setOperation(IndexOperation.INSERT);
        this.index.insert(tuple, this.btreeAccessor, this.opCtx);
    }

    public void delete(ITupleReference tuple) throws HyracksDataException, IndexException {
        this.opCtx.setOperation(IndexOperation.DELETE);
        this.index.delete(tuple, this.btreeAccessor, this.opCtx);
    }

    public IIndexCursor createSearchCursor(boolean exclusive) {
        return new OnDiskInvertedIndexSearchCursor(this.searcher, this.index.getInvListTypeTraits().length);
    }

    public void search(IIndexCursor cursor, ISearchPredicate searchPred) throws HyracksDataException, IndexException {
        this.searcher.search((OnDiskInvertedIndexSearchCursor)cursor, (InvertedIndexSearchPredicate)searchPred, this.opCtx);
    }

    @Override
    public IInvertedListCursor createInvertedListCursor() {
        return this.index.createInvertedListCursor();
    }

    @Override
    public void openInvertedListCursor(IInvertedListCursor listCursor, ITupleReference searchKey) throws HyracksDataException, IndexException {
        this.index.openInvertedListCursor(listCursor, searchKey, this.opCtx);
    }

    @Override
    public IIndexCursor createRangeSearchCursor() {
        IBTreeLeafFrame leafFrame = (IBTreeLeafFrame)this.index.getBTree().getLeafFrameFactory().createFrame();
        return new BTreeRangeSearchCursor(leafFrame, false);
    }

    @Override
    public void rangeSearch(IIndexCursor cursor, ISearchPredicate searchPred) throws IndexException, HyracksDataException {
        this.btreeAccessor.search(cursor, searchPred);
    }

    public BTree.BTreeAccessor getBTreeAccessor() {
        return this.btreeAccessor;
    }

    public void update(ITupleReference tuple) throws HyracksDataException, IndexException {
        throw new UnsupportedOperationException("Update not supported by in-memory inverted index.");
    }

    public void upsert(ITupleReference tuple) throws HyracksDataException, IndexException {
        throw new UnsupportedOperationException("Upsert not supported by in-memory inverted index.");
    }

    protected IInvertedIndexSearcher createSearcher() throws HyracksDataException {
        return new TOccurrenceSearcher(this.hyracksCtx, this.index);
    }
}

