/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ICursorInitialState;
import org.apache.hyracks.storage.am.common.api.IIndexAccessor;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.BloomFilterAwareBTreePointSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.exceptions.OccurrenceThresholdPanicException;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDiskComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexSearchCursorInitialState;

public class LSMInvertedIndexSearchCursor
implements IIndexCursor {
    private IIndexAccessor currentAccessor;
    private IIndexCursor currentCursor;
    private int accessorIndex = -1;
    private boolean tupleConsumed = true;
    private ILSMHarness harness;
    private List<IIndexAccessor> indexAccessors;
    private ISearchPredicate searchPred;
    private ISearchOperationCallback searchCallback;
    private IIndexCursor[] deletedKeysBTreeCursors;
    private List<IIndexAccessor> deletedKeysBTreeAccessors;
    private RangePredicate keySearchPred;
    private ILSMIndexOperationContext opCtx;
    private List<ILSMComponent> operationalComponents;

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        LSMInvertedIndexSearchCursorInitialState lsmInitState = (LSMInvertedIndexSearchCursorInitialState)initialState;
        this.harness = lsmInitState.getLSMHarness();
        this.operationalComponents = lsmInitState.getOperationalComponents();
        this.indexAccessors = lsmInitState.getIndexAccessors();
        this.opCtx = lsmInitState.getOpContext();
        this.accessorIndex = 0;
        this.searchPred = searchPred;
        this.searchCallback = lsmInitState.getSearchOperationCallback();
        this.deletedKeysBTreeAccessors = lsmInitState.getDeletedKeysBTreeAccessors();
        this.deletedKeysBTreeCursors = new IIndexCursor[this.deletedKeysBTreeAccessors.size()];
        for (int i = 0; i < this.operationalComponents.size(); ++i) {
            ILSMComponent component = this.operationalComponents.get(i);
            this.deletedKeysBTreeCursors[i] = component.getType() == ILSMComponent.LSMComponentType.MEMORY ? this.deletedKeysBTreeAccessors.get(i).createSearchCursor(false) : new BloomFilterAwareBTreePointSearchCursor((IBTreeLeafFrame)lsmInitState.getgetDeletedKeysBTreeLeafFrameFactory().createFrame(), false, ((LSMInvertedIndexDiskComponent)this.operationalComponents.get(i)).getBloomFilter());
        }
        MultiComparator keyCmp = lsmInitState.getKeyComparator();
        this.keySearchPred = new RangePredicate(null, null, true, true, keyCmp, keyCmp);
    }

    protected boolean isDeleted(ITupleReference key) throws HyracksDataException, IndexException {
        this.keySearchPred.setLowKey(key, true);
        this.keySearchPred.setHighKey(key, true);
        for (int i = 0; i < this.accessorIndex; ++i) {
            this.deletedKeysBTreeCursors[i].reset();
            try {
                this.deletedKeysBTreeAccessors.get(i).search(this.deletedKeysBTreeCursors[i], (ISearchPredicate)this.keySearchPred);
                if (!this.deletedKeysBTreeCursors[i].hasNext()) continue;
                boolean bl = true;
                return bl;
            }
            catch (IndexException e) {
                throw new HyracksDataException((Throwable)e);
            }
            finally {
                this.deletedKeysBTreeCursors[i].close();
            }
        }
        return false;
    }

    private boolean nextValidTuple() throws HyracksDataException, IndexException {
        while (this.currentCursor.hasNext()) {
            this.currentCursor.next();
            if (this.isDeleted(this.currentCursor.getTuple())) continue;
            this.tupleConsumed = false;
            return true;
        }
        return false;
    }

    public boolean hasNext() throws HyracksDataException, IndexException {
        if (!this.tupleConsumed) {
            return true;
        }
        if (this.currentCursor != null) {
            if (this.nextValidTuple()) {
                return true;
            }
            this.currentCursor.close();
            ++this.accessorIndex;
        }
        while (this.accessorIndex < this.indexAccessors.size()) {
            this.currentAccessor = this.indexAccessors.get(this.accessorIndex);
            this.currentCursor = this.currentAccessor.createSearchCursor(false);
            try {
                this.currentAccessor.search(this.currentCursor, this.searchPred);
            }
            catch (OccurrenceThresholdPanicException e) {
                throw e;
            }
            catch (IndexException e) {
                throw new HyracksDataException((Throwable)e);
            }
            if (this.nextValidTuple()) {
                return true;
            }
            this.currentCursor.close();
            ++this.accessorIndex;
        }
        return false;
    }

    public void next() throws HyracksDataException {
        this.tupleConsumed = true;
        if (!this.searchCallback.proceed(this.currentCursor.getTuple())) {
            this.searchCallback.reconcile(this.currentCursor.getTuple());
        }
    }

    public void close() throws HyracksDataException {
        this.reset();
    }

    public void reset() throws HyracksDataException {
        try {
            if (this.currentCursor != null) {
                this.currentCursor.close();
                this.currentCursor = null;
            }
            this.accessorIndex = 0;
        }
        finally {
            if (this.harness != null) {
                this.harness.endSearch(this.opCtx);
            }
        }
    }

    public ITupleReference getTuple() {
        return this.currentCursor.getTuple();
    }
}

