/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.util.ArrayList;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ICursorInitialState;
import org.apache.hyracks.storage.am.common.api.IIndexAccessor;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.BloomFilterAwareBTreePointSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDiskComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexRangeSearchCursorInitialState;

public class LSMInvertedIndexRangeSearchCursor
extends LSMIndexSearchCursor {
    private IIndexCursor[] deletedKeysBTreeCursors;
    protected ArrayList<IIndexAccessor> deletedKeysBTreeAccessors;
    protected PermutingTupleReference keysOnlyTuple;
    protected RangePredicate keySearchPred;

    public LSMInvertedIndexRangeSearchCursor(ILSMIndexOperationContext opCtx) {
        super(opCtx, false);
    }

    public void next() throws HyracksDataException {
        super.next();
    }

    public void open(ICursorInitialState initState, ISearchPredicate searchPred) throws IndexException, HyracksDataException {
        int i;
        LSMInvertedIndexRangeSearchCursorInitialState lsmInitState = (LSMInvertedIndexRangeSearchCursorInitialState)initState;
        this.cmp = lsmInitState.getOriginalKeyComparator();
        int numComponents = lsmInitState.getNumComponents();
        this.rangeCursors = new IIndexCursor[numComponents];
        for (i = 0; i < numComponents; ++i) {
            IInvertedIndexAccessor invIndexAccessor = (IInvertedIndexAccessor)lsmInitState.getIndexAccessors().get(i);
            this.rangeCursors[i] = invIndexAccessor.createRangeSearchCursor();
            invIndexAccessor.rangeSearch(this.rangeCursors[i], lsmInitState.getSearchPredicate());
        }
        this.lsmHarness = lsmInitState.getLSMHarness();
        this.operationalComponents = lsmInitState.getOperationalComponents();
        this.includeMutableComponent = lsmInitState.getIncludeMemComponent();
        this.keysOnlyTuple = lsmInitState.getKeysOnlyTuple();
        this.deletedKeysBTreeAccessors = lsmInitState.getDeletedKeysBTreeAccessors();
        if (!this.deletedKeysBTreeAccessors.isEmpty()) {
            this.deletedKeysBTreeCursors = new IIndexCursor[this.deletedKeysBTreeAccessors.size()];
            for (i = 0; i < this.operationalComponents.size(); ++i) {
                ILSMComponent component = (ILSMComponent)this.operationalComponents.get(i);
                this.deletedKeysBTreeCursors[i] = component.getType() == ILSMComponent.LSMComponentType.MEMORY ? this.deletedKeysBTreeAccessors.get(i).createSearchCursor(false) : new BloomFilterAwareBTreePointSearchCursor((IBTreeLeafFrame)lsmInitState.getgetDeletedKeysBTreeLeafFrameFactory().createFrame(), false, ((LSMInvertedIndexDiskComponent)((Object)this.operationalComponents.get(i))).getBloomFilter());
            }
        }
        MultiComparator keyCmp = lsmInitState.getKeyComparator();
        this.keySearchPred = new RangePredicate((ITupleReference)this.keysOnlyTuple, (ITupleReference)this.keysOnlyTuple, true, true, keyCmp, keyCmp);
        this.setPriorityQueueComparator();
        this.initPriorityQueue();
    }

    protected boolean isDeleted(LSMIndexSearchCursor.PriorityQueueElement checkElement) throws HyracksDataException, IndexException {
        this.keysOnlyTuple.reset(checkElement.getTuple());
        int end = checkElement.getCursorIndex();
        for (int i = 0; i < end; ++i) {
            this.deletedKeysBTreeCursors[i].reset();
            try {
                this.deletedKeysBTreeAccessors.get(i).search(this.deletedKeysBTreeCursors[i], (ISearchPredicate)this.keySearchPred);
                if (!this.deletedKeysBTreeCursors[i].hasNext()) continue;
                boolean bl = true;
                return bl;
            }
            catch (IndexException e) {
                throw new HyracksDataException((Throwable)e);
            }
            finally {
                this.deletedKeysBTreeCursors[i].close();
            }
        }
        return false;
    }
}

