/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.util.LinkedList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.IIndexAccessor;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexMemoryComponent;

public class LSMInvertedIndexOpContext
extends AbstractLSMIndexOperationContext {
    private static final int NUM_DOCUMENT_FIELDS = 1;
    private IndexOperation op;
    private final List<ILSMComponent> componentHolder = new LinkedList<ILSMComponent>();
    private final List<ILSMDiskComponent> componentsToBeMerged = new LinkedList<ILSMDiskComponent>();
    private final List<ILSMDiskComponent> componentsToBeReplicated = new LinkedList<ILSMDiskComponent>();
    private IModificationOperationCallback modificationCallback;
    private ISearchOperationCallback searchCallback;
    public PermutingTupleReference keysOnlyTuple;
    public IInvertedIndexAccessor[] mutableInvIndexAccessors;
    public IIndexAccessor[] deletedKeysBTreeAccessors;
    public IInvertedIndexAccessor currentMutableInvIndexAccessors;
    public IIndexAccessor currentDeletedKeysBTreeAccessors;
    public final PermutingTupleReference indexTuple;
    public final MultiComparator filterCmp;
    public final PermutingTupleReference filterTuple;
    public ISearchPredicate searchPredicate;

    public LSMInvertedIndexOpContext(List<ILSMMemoryComponent> mutableComponents, IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback, int[] invertedIndexFields, int[] filterFields) throws HyracksDataException {
        this.modificationCallback = modificationCallback;
        this.searchCallback = searchCallback;
        this.mutableInvIndexAccessors = new IInvertedIndexAccessor[mutableComponents.size()];
        this.deletedKeysBTreeAccessors = new IIndexAccessor[mutableComponents.size()];
        for (int i = 0; i < mutableComponents.size(); ++i) {
            LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)mutableComponents.get(i);
            this.mutableInvIndexAccessors[i] = (IInvertedIndexAccessor)mutableComponent.getInvIndex().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            this.deletedKeysBTreeAccessors[i] = mutableComponent.getDeletedKeysBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        }
        assert (mutableComponents.size() > 0);
        LSMInvertedIndexMemoryComponent c = (LSMInvertedIndexMemoryComponent)mutableComponents.get(0);
        int numKeyFields = c.getInvIndex().getInvListTypeTraits().length;
        int[] keyFieldPermutation = new int[numKeyFields];
        for (int i = 0; i < numKeyFields; ++i) {
            keyFieldPermutation[i] = 1 + i;
        }
        this.keysOnlyTuple = new PermutingTupleReference(keyFieldPermutation);
        if (filterFields != null) {
            this.indexTuple = new PermutingTupleReference(invertedIndexFields);
            this.filterCmp = MultiComparator.create((IBinaryComparatorFactory[])c.getLSMComponentFilter().getFilterCmpFactories());
            this.filterTuple = new PermutingTupleReference(filterFields);
        } else {
            this.indexTuple = null;
            this.filterCmp = null;
            this.filterTuple = null;
        }
    }

    public void reset() {
        super.reset();
        this.componentHolder.clear();
        this.componentsToBeMerged.clear();
        this.componentsToBeReplicated.clear();
    }

    public void setOperation(IndexOperation newOp) throws HyracksDataException {
        this.reset();
        this.op = newOp;
    }

    public IndexOperation getOperation() {
        return this.op;
    }

    public List<ILSMComponent> getComponentHolder() {
        return this.componentHolder;
    }

    public ISearchOperationCallback getSearchOperationCallback() {
        return this.searchCallback;
    }

    public IModificationOperationCallback getModificationCallback() {
        return this.modificationCallback;
    }

    public void setCurrentMutableComponentId(int currentMutableComponentId) {
        this.currentMutableInvIndexAccessors = this.mutableInvIndexAccessors[currentMutableComponentId];
        this.currentDeletedKeysBTreeAccessors = this.deletedKeysBTreeAccessors[currentMutableComponentId];
    }

    public List<ILSMDiskComponent> getComponentsToBeMerged() {
        return this.componentsToBeMerged;
    }

    public void setSearchPredicate(ISearchPredicate searchPredicate) {
        this.searchPredicate = searchPredicate;
    }

    public ISearchPredicate getSearchPredicate() {
        return this.searchPredicate;
    }

    public List<ILSMDiskComponent> getComponentsToBeReplicated() {
        return this.componentsToBeReplicated;
    }
}

