/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomCalculations;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterSpecification;
import org.apache.hyracks.storage.am.btree.frames.BTreeLeafFrameType;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.ICursorInitialState;
import org.apache.hyracks.storage.am.common.api.IIndexAccessor;
import org.apache.hyracks.storage.am.common.api.IIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.exceptions.TreeIndexDuplicateKeyException;
import org.apache.hyracks.storage.am.common.impls.AbstractSearchPredicate;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.freepage.VirtualFreePageManager;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.BTreeFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.BlockingIOOperationCallbackWrapper;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDeletedKeysBTreeMergeCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDiskComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexFlushOperation;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexMemoryComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexMergeOperation;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexOpContext;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexRangeSearchCursorInitialState;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexSearchCursorInitialState;
import org.apache.hyracks.storage.am.lsm.invertedindex.inmemory.InMemoryInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.inmemory.InMemoryInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndexFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchPredicate;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexUtils;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public class LSMInvertedIndex
extends AbstractLSMIndex
implements IInvertedIndex {
    protected final IBinaryTokenizerFactory tokenizerFactory;
    protected final ILSMDiskComponentFactory componentFactory;
    protected final ITypeTraits[] invListTypeTraits;
    protected final IBinaryComparatorFactory[] invListCmpFactories;
    protected final ITypeTraits[] tokenTypeTraits;
    protected final IBinaryComparatorFactory[] tokenCmpFactories;
    private final int[] invertedIndexFields;
    private final int[] filterFieldsForNonBulkLoadOps;
    private final int[] invertedIndexFieldsForNonBulkLoadOps;

    public LSMInvertedIndex(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, OnDiskInvertedIndexFactory diskInvIndexFactory, BTreeFactory deletedKeysBTreeFactory, BloomFilterFactory bloomFilterFactory, ILSMComponentFilterFactory filterFactory, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, double bloomFilterFalsePositiveRate, ILSMIndexFileManager fileManager, IFileMapProvider diskFileMapProvider, ITypeTraits[] invListTypeTraits, IBinaryComparatorFactory[] invListCmpFactories, ITypeTraits[] tokenTypeTraits, IBinaryComparatorFactory[] tokenCmpFactories, IBinaryTokenizerFactory tokenizerFactory, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, int[] invertedIndexFields, int[] filterFields, int[] filterFieldsForNonBulkLoadOps, int[] invertedIndexFieldsForNonBulkLoadOps, boolean durable) throws IndexException, HyracksDataException {
        super(ioManager, virtualBufferCaches, diskInvIndexFactory.getBufferCache(), fileManager, diskFileMapProvider, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, filterFrameFactory, filterManager, filterFields, durable);
        this.tokenizerFactory = tokenizerFactory;
        this.invListTypeTraits = invListTypeTraits;
        this.invListCmpFactories = invListCmpFactories;
        this.tokenTypeTraits = tokenTypeTraits;
        this.tokenCmpFactories = tokenCmpFactories;
        this.invertedIndexFields = invertedIndexFields;
        this.filterFieldsForNonBulkLoadOps = filterFieldsForNonBulkLoadOps;
        this.invertedIndexFieldsForNonBulkLoadOps = invertedIndexFieldsForNonBulkLoadOps;
        this.componentFactory = new LSMInvertedIndexDiskComponentFactory(diskInvIndexFactory, (TreeIndexFactory<BTree>)deletedKeysBTreeFactory, bloomFilterFactory, filterFactory);
        int i = 0;
        for (IVirtualBufferCache virtualBufferCache : virtualBufferCaches) {
            InMemoryInvertedIndex memInvIndex = this.createInMemoryInvertedIndex(virtualBufferCache, new VirtualFreePageManager((IBufferCache)virtualBufferCache), i);
            BTree deleteKeysBTree = BTreeUtils.createBTree((IBufferCache)virtualBufferCache, (IPageManager)new VirtualFreePageManager((IBufferCache)virtualBufferCache), (IFileMapProvider)virtualBufferCache.getFileMapProvider(), (ITypeTraits[])invListTypeTraits, (IBinaryComparatorFactory[])invListCmpFactories, (BTreeLeafFrameType)BTreeLeafFrameType.REGULAR_NSM, (FileReference)ioManager.resolveAbsolutePath(fileManager.getBaseDir() + "_virtual_del_" + i));
            LSMInvertedIndexMemoryComponent mutableComponent = new LSMInvertedIndexMemoryComponent(memInvIndex, deleteKeysBTree, virtualBufferCache, i == 0, filterFactory == null ? null : filterFactory.createFilter());
            this.memoryComponents.add(mutableComponent);
            ++i;
        }
    }

    public synchronized void create() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to create the index since it is activated.");
        }
        this.fileManager.deleteDirs();
        this.fileManager.createDirs();
        this.diskComponents.clear();
    }

    public synchronized void activate() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to activate the index since it is already activated.");
        }
        try {
            List immutableComponents = this.diskComponents;
            immutableComponents.clear();
            List validFileReferences = this.fileManager.cleanupAndGetValidFiles();
            for (LSMComponentFileReferences lsmComonentFileReference : validFileReferences) {
                LSMInvertedIndexDiskComponent component;
                try {
                    component = this.createDiskInvIndexComponent(this.componentFactory, lsmComonentFileReference.getInsertIndexFileReference(), lsmComonentFileReference.getDeleteIndexFileReference(), lsmComonentFileReference.getBloomFilterFileReference(), false);
                }
                catch (IndexException e) {
                    throw new HyracksDataException((Throwable)e);
                }
                immutableComponents.add(component);
            }
            this.isActivated = true;
        }
        catch (IndexException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void clear() throws HyracksDataException {
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to clear the index since it is not activated.");
        }
        this.clearMemoryComponents();
        List immutableComponents = this.diskComponents;
        for (ILSMDiskComponent c : immutableComponents) {
            LSMInvertedIndexDiskComponent component = (LSMInvertedIndexDiskComponent)c;
            component.getBloomFilter().deactivate();
            component.getInvIndex().deactivate();
            component.getDeletedKeysBTree().deactivate();
            component.getBloomFilter().destroy();
            component.getInvIndex().destroy();
            component.getDeletedKeysBTree().destroy();
        }
        immutableComponents.clear();
    }

    public synchronized void deactivate(boolean flushOnExit) throws HyracksDataException {
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to deactivate the index since it is already deactivated.");
        }
        if (flushOnExit) {
            BlockingIOOperationCallbackWrapper cb = new BlockingIOOperationCallbackWrapper(this.ioOpCallback);
            ILSMIndexAccessor accessor = this.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            accessor.scheduleFlush((ILSMIOOperationCallback)cb);
            try {
                cb.waitForIO();
            }
            catch (InterruptedException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        List immutableComponents = this.diskComponents;
        for (ILSMDiskComponent c : immutableComponents) {
            LSMInvertedIndexDiskComponent component = (LSMInvertedIndexDiskComponent)c;
            component.getBloomFilter().deactivate();
            component.getInvIndex().deactivate();
            component.getDeletedKeysBTree().deactivate();
        }
        this.deallocateMemoryComponents();
        this.isActivated = false;
    }

    public synchronized void deactivate() throws HyracksDataException {
        this.deactivate(true);
    }

    public synchronized void destroy() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to destroy the index since it is activated.");
        }
        for (ILSMComponent c : this.memoryComponents) {
            LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)c;
            mutableComponent.getInvIndex().destroy();
            mutableComponent.getDeletedKeysBTree().destroy();
        }
        List immutableComponents = this.diskComponents;
        for (ILSMDiskComponent c : immutableComponents) {
            LSMInvertedIndexDiskComponent component = (LSMInvertedIndexDiskComponent)c;
            component.getInvIndex().destroy();
            component.getDeletedKeysBTree().destroy();
            component.getBloomFilter().destroy();
        }
        this.fileManager.deleteDirs();
    }

    public void getOperationalComponents(ILSMIndexOperationContext ctx) throws HyracksDataException {
        List immutableComponents = this.diskComponents;
        List operationalComponents = ctx.getComponentHolder();
        int cmc = this.currentMutableComponentId.get();
        ctx.setCurrentMutableComponentId(cmc);
        operationalComponents.clear();
        switch (ctx.getOperation()) {
            case FLUSH: 
            case DELETE: 
            case INSERT: 
            case UPSERT: {
                operationalComponents.add(this.memoryComponents.get(cmc));
                break;
            }
            case SEARCH: {
                if (this.memoryComponentsAllocated) {
                    this.addOperationalMutableComponents(operationalComponents);
                }
                if (this.filterManager != null) {
                    for (ILSMComponent c : immutableComponents) {
                        if (!c.getLSMComponentFilter().satisfy(((AbstractSearchPredicate)ctx.getSearchPredicate()).getMinFilterTuple(), ((AbstractSearchPredicate)ctx.getSearchPredicate()).getMaxFilterTuple(), ((LSMInvertedIndexOpContext)ctx).filterCmp)) continue;
                        operationalComponents.add(c);
                    }
                    break;
                }
                operationalComponents.addAll(immutableComponents);
                break;
            }
            case MERGE: {
                operationalComponents.addAll(ctx.getComponentsToBeMerged());
                break;
            }
            case FULL_MERGE: {
                operationalComponents.addAll(immutableComponents);
                break;
            }
            case REPLICATE: {
                operationalComponents.addAll(ctx.getComponentsToBeReplicated());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + ctx.getOperation() + " not supported.");
            }
        }
    }

    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException, IndexException {
        ITupleReference indexTuple;
        LSMInvertedIndexOpContext ctx = (LSMInvertedIndexOpContext)ictx;
        if (ctx.indexTuple != null) {
            ctx.indexTuple.reset(tuple);
            indexTuple = ctx.indexTuple;
        } else {
            indexTuple = tuple;
        }
        ctx.getModificationCallback().before(indexTuple);
        ctx.getModificationCallback().found(null, indexTuple);
        switch (ctx.getOperation()) {
            case INSERT: {
                ctx.currentMutableInvIndexAccessors.insert(indexTuple);
                break;
            }
            case DELETE: {
                ctx.currentMutableInvIndexAccessors.delete(indexTuple);
                ctx.keysOnlyTuple.reset(indexTuple);
                try {
                    ctx.currentDeletedKeysBTreeAccessors.insert((ITupleReference)ctx.keysOnlyTuple);
                }
                catch (TreeIndexDuplicateKeyException treeIndexDuplicateKeyException) {}
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + ctx.getOperation() + " not supported.");
            }
        }
        if (ctx.filterTuple != null) {
            ctx.filterTuple.reset(tuple);
            ((ILSMMemoryComponent)this.memoryComponents.get(this.currentMutableComponentId.get())).getLSMComponentFilter().update((ITupleReference)ctx.filterTuple, ctx.filterCmp);
        }
    }

    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException, IndexException {
        List operationalComponents = ictx.getComponentHolder();
        int numComponents = operationalComponents.size();
        boolean includeMutableComponent = false;
        ArrayList<IIndexAccessor> indexAccessors = new ArrayList<IIndexAccessor>(numComponents);
        ArrayList<IIndexAccessor> deletedKeysBTreeAccessors = new ArrayList<IIndexAccessor>(numComponents);
        for (int i = 0; i < operationalComponents.size(); ++i) {
            ITreeIndexAccessor deletedKeysAccessor;
            IIndexAccessor invIndexAccessor;
            ILSMComponent component = (ILSMComponent)operationalComponents.get(i);
            if (component.getType() == ILSMComponent.LSMComponentType.MEMORY) {
                includeMutableComponent = true;
                invIndexAccessor = ((LSMInvertedIndexMemoryComponent)component).getInvIndex().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                indexAccessors.add(invIndexAccessor);
                deletedKeysAccessor = ((LSMInvertedIndexMemoryComponent)component).getDeletedKeysBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                deletedKeysBTreeAccessors.add((IIndexAccessor)deletedKeysAccessor);
                continue;
            }
            invIndexAccessor = ((LSMInvertedIndexDiskComponent)component).getInvIndex().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            indexAccessors.add(invIndexAccessor);
            deletedKeysAccessor = ((LSMInvertedIndexDiskComponent)component).getDeletedKeysBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            deletedKeysBTreeAccessors.add((IIndexAccessor)deletedKeysAccessor);
        }
        ICursorInitialState initState = this.createCursorInitialState(pred, (IIndexOperationContext)ictx, includeMutableComponent, indexAccessors, deletedKeysBTreeAccessors, operationalComponents);
        cursor.open(initState, pred);
    }

    private ICursorInitialState createCursorInitialState(ISearchPredicate pred, IIndexOperationContext ictx, boolean includeMutableComponent, ArrayList<IIndexAccessor> indexAccessors, ArrayList<IIndexAccessor> deletedKeysBTreeAccessors, List<ILSMComponent> operationalComponents) {
        Object initState = null;
        PermutingTupleReference keysOnlyTuple = this.createKeysOnlyTupleReference();
        MultiComparator keyCmp = MultiComparator.create((IBinaryComparatorFactory[])this.invListCmpFactories);
        if (pred instanceof InvertedIndexSearchPredicate) {
            initState = new LSMInvertedIndexSearchCursorInitialState(keyCmp, keysOnlyTuple, indexAccessors, deletedKeysBTreeAccessors, ((LSMInvertedIndexMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()))).getDeletedKeysBTree().getLeafFrameFactory(), ictx, includeMutableComponent, this.lsmHarness, operationalComponents);
        } else {
            LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
            InMemoryInvertedIndex memInvIndex = (InMemoryInvertedIndex)mutableComponent.getInvIndex();
            MultiComparator tokensAndKeysCmp = MultiComparator.create((IBinaryComparatorFactory[])memInvIndex.getBTree().getComparatorFactories());
            initState = new LSMInvertedIndexRangeSearchCursorInitialState(tokensAndKeysCmp, keyCmp, keysOnlyTuple, ((LSMInvertedIndexMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()))).getDeletedKeysBTree().getLeafFrameFactory(), includeMutableComponent, this.lsmHarness, indexAccessors, deletedKeysBTreeAccessors, pred, operationalComponents);
        }
        return initState;
    }

    private PermutingTupleReference createKeysOnlyTupleReference() {
        int[] keyFieldPermutation = new int[this.invListTypeTraits.length];
        int numTokenFields = this.tokenTypeTraits.length;
        for (int i = 0; i < this.invListTypeTraits.length; ++i) {
            keyFieldPermutation[i] = numTokenFields + i;
        }
        return new PermutingTupleReference(keyFieldPermutation);
    }

    public void scheduleFlush(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        ILSMComponent flushingComponent = (ILSMComponent)ctx.getComponentHolder().get(0);
        LSMComponentFileReferences componentFileRefs = this.fileManager.getRelFlushFileReference();
        LSMInvertedIndexOpContext opCtx = this.createOpContext((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        opCtx.setOperation(IndexOperation.FLUSH);
        opCtx.getComponentHolder().add(flushingComponent);
        this.ioScheduler.scheduleOperation((ILSMIOOperation)new LSMInvertedIndexFlushOperation(new LSMInvertedIndexAccessor(this.lsmHarness, (ILSMIndexOperationContext)opCtx), flushingComponent, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent flush(ILSMIOOperation operation) throws HyracksDataException, IndexException {
        LSMInvertedIndexFlushOperation flushOp = (LSMInvertedIndexFlushOperation)operation;
        LSMInvertedIndexDiskComponent component = this.createDiskInvIndexComponent(this.componentFactory, flushOp.getDictBTreeFlushTarget(), flushOp.getDeletedKeysBTreeFlushTarget(), flushOp.getBloomFilterFlushTarget(), true);
        IInvertedIndex diskInvertedIndex = component.getInvIndex();
        LSMInvertedIndexMemoryComponent flushingComponent = (LSMInvertedIndexMemoryComponent)flushOp.getFlushingComponent();
        InMemoryInvertedIndexAccessor memInvIndexAccessor = (InMemoryInvertedIndexAccessor)flushingComponent.getInvIndex().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        BTree.BTreeAccessor memBTreeAccessor = memInvIndexAccessor.getBTreeAccessor();
        RangePredicate nullPred = new RangePredicate(null, null, true, true, null, null);
        ITreeIndexCursor scanCursor = memBTreeAccessor.createSearchCursor(false);
        memBTreeAccessor.search((IIndexCursor)scanCursor, (ISearchPredicate)nullPred);
        IIndexBulkLoader invIndexBulkLoader = diskInvertedIndex.createBulkLoader(1.0f, false, 0L, false);
        try {
            while (scanCursor.hasNext()) {
                scanCursor.next();
                invIndexBulkLoader.add(scanCursor.getTuple());
            }
        }
        finally {
            scanCursor.close();
        }
        if (component.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMinTuple());
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMaxTuple());
            this.filterManager.updateFilter(component.getLSMComponentFilter(), filterTuples);
            this.filterManager.writeFilter(component.getLSMComponentFilter(), (ITreeIndex)((OnDiskInvertedIndex)component.getInvIndex()).getBTree());
        }
        flushingComponent.getMetadata().copy(component.getMetadata());
        invIndexBulkLoader.end();
        ITreeIndexAccessor deletedKeysBTreeAccessor = flushingComponent.getDeletedKeysBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        ITreeIndexCursor btreeCountingCursor = ((BTree.BTreeAccessor)deletedKeysBTreeAccessor).createCountingSearchCursor();
        deletedKeysBTreeAccessor.search((IIndexCursor)btreeCountingCursor, (ISearchPredicate)nullPred);
        long numBTreeTuples = 0L;
        try {
            while (btreeCountingCursor.hasNext()) {
                btreeCountingCursor.next();
                ITupleReference countTuple = btreeCountingCursor.getTuple();
                numBTreeTuples = IntegerPointable.getInteger((byte[])countTuple.getFieldData(0), (int)countTuple.getFieldStart(0));
            }
        }
        finally {
            btreeCountingCursor.close();
        }
        int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numBTreeTuples);
        BloomFilterSpecification bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)this.bloomFilterFalsePositiveRate);
        BTree diskDeletedKeysBTree = component.getDeletedKeysBTree();
        IIndexCursor deletedKeysScanCursor = deletedKeysBTreeAccessor.createSearchCursor(false);
        deletedKeysBTreeAccessor.search(deletedKeysScanCursor, (ISearchPredicate)nullPred);
        IIndexBulkLoader deletedKeysBTreeBulkLoader = diskDeletedKeysBTree.createBulkLoader(1.0f, false, 0L, false);
        IIndexBulkLoader builder = component.getBloomFilter().createBuilder(numBTreeTuples, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements());
        try {
            while (deletedKeysScanCursor.hasNext()) {
                deletedKeysScanCursor.next();
                deletedKeysBTreeBulkLoader.add(deletedKeysScanCursor.getTuple());
                builder.add(deletedKeysScanCursor.getTuple());
            }
        }
        finally {
            deletedKeysScanCursor.close();
            builder.end();
        }
        deletedKeysBTreeBulkLoader.end();
        return component;
    }

    public void scheduleMerge(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException, IndexException {
        LSMInvertedIndexOpContext ictx = this.createOpContext((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        ictx.setOperation(IndexOperation.MERGE);
        List mergingComponents = ctx.getComponentHolder();
        LSMInvertedIndexRangeSearchCursor cursor = new LSMInvertedIndexRangeSearchCursor((ILSMIndexOperationContext)ictx);
        LSMInvertedIndexDiskComponent firstComponent = (LSMInvertedIndexDiskComponent)((Object)mergingComponents.get(0));
        OnDiskInvertedIndex firstInvIndex = (OnDiskInvertedIndex)firstComponent.getInvIndex();
        String firstFileName = firstInvIndex.getBTree().getFileReference().getFile().getName();
        LSMInvertedIndexDiskComponent lastComponent = (LSMInvertedIndexDiskComponent)((Object)mergingComponents.get(mergingComponents.size() - 1));
        OnDiskInvertedIndex lastInvIndex = (OnDiskInvertedIndex)lastComponent.getInvIndex();
        String lastFileName = lastInvIndex.getBTree().getFileReference().getFile().getName();
        LSMComponentFileReferences relMergeFileRefs = this.fileManager.getRelMergeFileReference(firstFileName, lastFileName);
        LSMInvertedIndexAccessor accessor = new LSMInvertedIndexAccessor(this.lsmHarness, ctx);
        this.ioScheduler.scheduleOperation((ILSMIOOperation)new LSMInvertedIndexMergeOperation(accessor, mergingComponents, (IIndexCursor)cursor, relMergeFileRefs.getInsertIndexFileReference(), relMergeFileRefs.getDeleteIndexFileReference(), relMergeFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent merge(ILSMIOOperation operation) throws HyracksDataException, IndexException {
        LSMInvertedIndexMergeOperation mergeOp = (LSMInvertedIndexMergeOperation)operation;
        IIndexCursor cursor = mergeOp.getCursor();
        RangePredicate mergePred = new RangePredicate(null, null, true, true, null, null);
        ILSMIndexOperationContext opCtx = ((LSMIndexSearchCursor)cursor).getOpCtx();
        opCtx.getComponentHolder().addAll(mergeOp.getMergingComponents());
        this.search(opCtx, cursor, (ISearchPredicate)mergePred);
        LSMInvertedIndexDiskComponent component = this.createDiskInvIndexComponent(this.componentFactory, mergeOp.getDictBTreeMergeTarget(), mergeOp.getDeletedKeysBTreeMergeTarget(), mergeOp.getBloomFilterMergeTarget(), true);
        IInvertedIndex mergedDiskInvertedIndex = component.getInvIndex();
        if (mergeOp.getMergingComponents().get(mergeOp.getMergingComponents().size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1)) {
            LSMInvertedIndexDeletedKeysBTreeMergeCursor btreeCursor = new LSMInvertedIndexDeletedKeysBTreeMergeCursor(opCtx);
            this.search(opCtx, (IIndexCursor)btreeCursor, (ISearchPredicate)mergePred);
            BTree btree = component.getDeletedKeysBTree();
            IIndexBulkLoader btreeBulkLoader = btree.createBulkLoader(1.0f, true, 0L, false);
            long numElements = 0L;
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                numElements += ((LSMInvertedIndexDiskComponent)mergeOp.getMergingComponents().get(i)).getBloomFilter().getNumElements();
            }
            int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElements);
            BloomFilterSpecification bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)this.bloomFilterFalsePositiveRate);
            IIndexBulkLoader builder = component.getBloomFilter().createBuilder(numElements, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements());
            try {
                while (btreeCursor.hasNext()) {
                    btreeCursor.next();
                    ITupleReference tuple = btreeCursor.getTuple();
                    btreeBulkLoader.add(tuple);
                    builder.add(tuple);
                }
            }
            finally {
                btreeCursor.close();
                builder.end();
            }
            btreeBulkLoader.end();
        } else {
            BTree btree = component.getDeletedKeysBTree();
            IIndexBulkLoader btreeBulkLoader = btree.createBulkLoader(1.0f, true, 0L, false);
            btreeBulkLoader.end();
        }
        IIndexBulkLoader invIndexBulkLoader = mergedDiskInvertedIndex.createBulkLoader(1.0f, true, 0L, false);
        try {
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference tuple = cursor.getTuple();
                invIndexBulkLoader.add(tuple);
            }
        }
        finally {
            cursor.close();
        }
        if (component.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                ITupleReference min = mergeOp.getMergingComponents().get(i).getLSMComponentFilter().getMinTuple();
                ITupleReference max = mergeOp.getMergingComponents().get(i).getLSMComponentFilter().getMaxTuple();
                if (min != null) {
                    filterTuples.add(min);
                }
                if (max == null) continue;
                filterTuples.add(max);
            }
            this.filterManager.updateFilter(component.getLSMComponentFilter(), filterTuples);
            this.filterManager.writeFilter(component.getLSMComponentFilter(), (ITreeIndex)((OnDiskInvertedIndex)component.getInvIndex()).getBTree());
        }
        invIndexBulkLoader.end();
        return component;
    }

    public IIndexBulkLoader createBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws IndexException {
        try {
            return new LSMInvertedIndexBulkLoader(fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex);
        }
        catch (HyracksDataException e) {
            throw new IndexException((Exception)((Object)e));
        }
    }

    protected InMemoryInvertedIndex createInMemoryInvertedIndex(IVirtualBufferCache virtualBufferCache, VirtualFreePageManager virtualFreePageManager, int id) throws IndexException, HyracksDataException {
        return InvertedIndexUtils.createInMemoryBTreeInvertedindex((IBufferCache)virtualBufferCache, (IPageManager)virtualFreePageManager, this.invListTypeTraits, this.invListCmpFactories, this.tokenTypeTraits, this.tokenCmpFactories, this.tokenizerFactory, this.ioManager.resolveAbsolutePath(this.fileManager.getBaseDir() + "_virtual_vocab_" + id));
    }

    protected LSMInvertedIndexDiskComponent createDiskInvIndexComponent(ILSMDiskComponentFactory factory, FileReference dictBTreeFileRef, FileReference btreeFileRef, FileReference bloomFilterFileRef, boolean create) throws HyracksDataException, IndexException {
        LSMInvertedIndexDiskComponent component = (LSMInvertedIndexDiskComponent)factory.createComponent(new LSMComponentFileReferences(dictBTreeFileRef, btreeFileRef, bloomFilterFileRef));
        if (create) {
            component.getInvIndex().create();
            component.getDeletedKeysBTree().create();
            component.getBloomFilter().create();
        }
        component.getInvIndex().activate();
        component.getDeletedKeysBTree().activate();
        component.getBloomFilter().activate();
        if (component.getLSMComponentFilter() != null && !create) {
            this.filterManager.readFilter(component.getLSMComponentFilter(), (ITreeIndex)((OnDiskInvertedIndex)component.getInvIndex()).getBTree());
        }
        return component;
    }

    public ILSMIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) throws HyracksDataException {
        return new LSMInvertedIndexAccessor(this.lsmHarness, (ILSMIndexOperationContext)this.createOpContext(modificationCallback, searchCallback));
    }

    private LSMInvertedIndexOpContext createOpContext(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) throws HyracksDataException {
        return new LSMInvertedIndexOpContext(this.memoryComponents, modificationCallback, searchCallback, this.invertedIndexFieldsForNonBulkLoadOps, this.filterFieldsForNonBulkLoadOps);
    }

    @Override
    public IInvertedListCursor createInvertedListCursor() {
        throw new UnsupportedOperationException("Cannot create inverted list cursor on lsm inverted index.");
    }

    @Override
    public void openInvertedListCursor(IInvertedListCursor listCursor, ITupleReference searchKey, IIndexOperationContext ictx) throws HyracksDataException, IndexException {
        throw new UnsupportedOperationException("Cannot open inverted list cursor on lsm inverted index.");
    }

    @Override
    public ITypeTraits[] getInvListTypeTraits() {
        return this.invListTypeTraits;
    }

    @Override
    public IBinaryComparatorFactory[] getInvListCmpFactories() {
        return this.invListCmpFactories;
    }

    public long getMemoryAllocationSize() {
        long size = 0L;
        for (ILSMComponent c : this.memoryComponents) {
            LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)c;
            IBufferCache virtualBufferCache = mutableComponent.getInvIndex().getBufferCache();
            size += (long)(virtualBufferCache.getNumPages() * virtualBufferCache.getPageSize());
        }
        return size;
    }

    @Override
    public ITypeTraits[] getTokenTypeTraits() {
        return this.tokenTypeTraits;
    }

    @Override
    public IBinaryComparatorFactory[] getTokenCmpFactories() {
        return this.tokenCmpFactories;
    }

    public IBinaryTokenizerFactory getTokenizerFactory() {
        return this.tokenizerFactory;
    }

    public void markAsValid(ILSMDiskComponent lsmComponent) throws HyracksDataException {
        LSMInvertedIndexDiskComponent invIndexComponent = (LSMInvertedIndexDiskComponent)lsmComponent;
        OnDiskInvertedIndex invIndex = (OnDiskInvertedIndex)invIndexComponent.getInvIndex();
        IBufferCache bufferCache = invIndex.getBufferCache();
        this.markAsValidInternal(invIndex.getBufferCache(), invIndexComponent.getBloomFilter());
        bufferCache.force(invIndex.getInvListsFileId(), true);
        this.markAsValidInternal((ITreeIndex)invIndex.getBTree());
        this.markAsValidInternal((ITreeIndex)invIndexComponent.getDeletedKeysBTree());
    }

    public void validate() throws HyracksDataException {
        this.validateMemoryComponents();
        List immutableComponents = this.diskComponents;
        for (ILSMDiskComponent c : immutableComponents) {
            LSMInvertedIndexDiskComponent component = (LSMInvertedIndexDiskComponent)c;
            component.getInvIndex().validate();
            component.getDeletedKeysBTree().validate();
        }
    }

    public String toString() {
        return "LSMInvertedIndex [" + this.fileManager.getBaseDir() + "]";
    }

    public boolean hasMemoryComponents() {
        return true;
    }

    public boolean isPrimaryIndex() {
        return false;
    }

    public Set<String> getLSMComponentPhysicalFiles(ILSMComponent lsmComponent) {
        HashSet<String> files = new HashSet<String>();
        LSMInvertedIndexDiskComponent invIndexComponent = (LSMInvertedIndexDiskComponent)lsmComponent;
        OnDiskInvertedIndex invIndex = (OnDiskInvertedIndex)invIndexComponent.getInvIndex();
        files.add(invIndex.getInvListsFile().getFile().getAbsolutePath());
        files.add(invIndex.getBTree().getFileReference().getFile().getAbsolutePath());
        files.add(invIndexComponent.getBloomFilter().getFileReference().getFile().getAbsolutePath());
        files.add(invIndexComponent.getDeletedKeysBTree().getFileReference().getFile().getAbsolutePath());
        return files;
    }

    public synchronized void allocateMemoryComponents() throws HyracksDataException {
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to allocate memory components since the index is not active.");
        }
        if (this.memoryComponentsAllocated) {
            return;
        }
        for (ILSMComponent c : this.memoryComponents) {
            LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)c;
            ((IVirtualBufferCache)mutableComponent.getInvIndex().getBufferCache()).open();
            mutableComponent.getInvIndex().create();
            mutableComponent.getInvIndex().activate();
            mutableComponent.getDeletedKeysBTree().create();
            mutableComponent.getDeletedKeysBTree().activate();
        }
        this.memoryComponentsAllocated = true;
    }

    private void addOperationalMutableComponents(List<ILSMComponent> operationalComponents) {
        int cmc = this.currentMutableComponentId.get();
        int numMutableComponents = this.memoryComponents.size();
        for (int i = 0; i < numMutableComponents - 1; ++i) {
            ILSMComponent c = (ILSMComponent)this.memoryComponents.get((cmc + i + 1) % numMutableComponents);
            LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)c;
            if (!mutableComponent.isReadable()) continue;
            operationalComponents.add(0, (ILSMComponent)mutableComponent);
        }
        operationalComponents.add(0, (ILSMComponent)this.memoryComponents.get(cmc));
    }

    private synchronized void clearMemoryComponents() throws HyracksDataException {
        if (this.memoryComponentsAllocated) {
            for (ILSMComponent c : this.memoryComponents) {
                LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)c;
                mutableComponent.getInvIndex().clear();
                mutableComponent.getDeletedKeysBTree().clear();
                mutableComponent.reset();
            }
        }
    }

    private synchronized void validateMemoryComponents() throws HyracksDataException {
        if (this.memoryComponentsAllocated) {
            for (ILSMComponent c : this.memoryComponents) {
                LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)c;
                mutableComponent.getInvIndex().validate();
                mutableComponent.getDeletedKeysBTree().validate();
            }
        }
    }

    private synchronized void deallocateMemoryComponents() throws HyracksDataException {
        if (this.memoryComponentsAllocated) {
            for (ILSMComponent c : this.memoryComponents) {
                LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)c;
                mutableComponent.getInvIndex().deactivate();
                mutableComponent.getDeletedKeysBTree().deactivate();
                mutableComponent.getInvIndex().destroy();
                mutableComponent.getDeletedKeysBTree().destroy();
                ((IVirtualBufferCache)mutableComponent.getInvIndex().getBufferCache()).close();
            }
            this.memoryComponentsAllocated = false;
        }
    }

    public class LSMInvertedIndexBulkLoader
    implements IIndexBulkLoader {
        private final ILSMDiskComponent component;
        private final IIndexBulkLoader invIndexBulkLoader;
        private final IIndexBulkLoader deletedKeysBTreeBulkLoader;
        private boolean cleanedUpArtifacts = false;
        private boolean isEmptyComponent = true;
        public final PermutingTupleReference indexTuple;
        public final PermutingTupleReference filterTuple;
        public final MultiComparator filterCmp;

        public LSMInvertedIndexBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws IndexException, HyracksDataException {
            if (checkIfEmptyIndex && !LSMInvertedIndex.this.isEmptyIndex()) {
                throw new IndexException("Cannot load an index that is not empty");
            }
            try {
                this.component = this.createBulkLoadTarget();
            }
            catch (HyracksDataException | IndexException e) {
                throw new IndexException((Exception)e);
            }
            this.invIndexBulkLoader = ((LSMInvertedIndexDiskComponent)this.component).getInvIndex().createBulkLoader(fillFactor, verifyInput, numElementsHint, false);
            this.deletedKeysBTreeBulkLoader = ((LSMInvertedIndexDiskComponent)this.component).getDeletedKeysBTree().createBulkLoader(fillFactor, verifyInput, numElementsHint, false);
            if (LSMInvertedIndex.this.filterFields != null) {
                this.indexTuple = new PermutingTupleReference(LSMInvertedIndex.this.invertedIndexFields);
                this.filterCmp = MultiComparator.create((IBinaryComparatorFactory[])this.component.getLSMComponentFilter().getFilterCmpFactories());
                this.filterTuple = new PermutingTupleReference(LSMInvertedIndex.this.filterFields);
            } else {
                this.indexTuple = null;
                this.filterCmp = null;
                this.filterTuple = null;
            }
        }

        public void add(ITupleReference tuple) throws IndexException, HyracksDataException {
            try {
                ITupleReference t;
                if (this.indexTuple != null) {
                    this.indexTuple.reset(tuple);
                    t = this.indexTuple;
                } else {
                    t = tuple;
                }
                this.invIndexBulkLoader.add(t);
                if (this.filterTuple != null) {
                    this.filterTuple.reset(tuple);
                    this.component.getLSMComponentFilter().update((ITupleReference)this.filterTuple, this.filterCmp);
                }
            }
            catch (RuntimeException | HyracksDataException | IndexException e) {
                this.cleanupArtifacts();
                throw e;
            }
            if (this.isEmptyComponent) {
                this.isEmptyComponent = false;
            }
        }

        protected void cleanupArtifacts() throws HyracksDataException {
            if (!this.cleanedUpArtifacts) {
                this.cleanedUpArtifacts = true;
                ((LSMInvertedIndexDiskComponent)this.component).getInvIndex().deactivate();
                ((LSMInvertedIndexDiskComponent)this.component).getInvIndex().destroy();
                ((LSMInvertedIndexDiskComponent)this.component).getDeletedKeysBTree().deactivate();
                ((LSMInvertedIndexDiskComponent)this.component).getDeletedKeysBTree().destroy();
                ((LSMInvertedIndexDiskComponent)this.component).getBloomFilter().deactivate();
                ((LSMInvertedIndexDiskComponent)this.component).getBloomFilter().destroy();
            }
        }

        public void end() throws IndexException, HyracksDataException {
            if (!this.cleanedUpArtifacts) {
                if (this.component.getLSMComponentFilter() != null) {
                    LSMInvertedIndex.this.filterManager.writeFilter(this.component.getLSMComponentFilter(), (ITreeIndex)((OnDiskInvertedIndex)((LSMInvertedIndexDiskComponent)this.component).getInvIndex()).getBTree());
                }
                this.invIndexBulkLoader.end();
                this.deletedKeysBTreeBulkLoader.end();
                if (this.isEmptyComponent) {
                    this.cleanupArtifacts();
                } else {
                    LSMInvertedIndex.this.ioOpCallback.afterOperation(LSMOperationType.FLUSH, null, this.component);
                    LSMInvertedIndex.this.lsmHarness.addBulkLoadedComponent(this.component);
                }
            }
        }

        public void abort() throws HyracksDataException {
            if (this.invIndexBulkLoader != null) {
                this.invIndexBulkLoader.abort();
            }
            if (this.deletedKeysBTreeBulkLoader != null) {
                this.deletedKeysBTreeBulkLoader.abort();
            }
        }

        private ILSMDiskComponent createBulkLoadTarget() throws HyracksDataException, IndexException {
            LSMComponentFileReferences componentFileRefs = LSMInvertedIndex.this.fileManager.getRelFlushFileReference();
            return LSMInvertedIndex.this.createDiskInvIndexComponent(LSMInvertedIndex.this.componentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
        }
    }
}

