/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.dataflow;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizer;

public class BinaryTokenizerOperatorNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    private final IHyracksTaskContext ctx;
    private final IBinaryTokenizer tokenizer;
    private final int docField;
    private final int[] keyFields;
    private final boolean addNumTokensKey;
    private final boolean writeKeyFieldsFirst;
    private final RecordDescriptor inputRecDesc;
    private final RecordDescriptor outputRecDesc;
    private FrameTupleAccessor accessor;
    private ArrayTupleBuilder builder;
    private GrowableArray builderData;
    private FrameTupleAppender appender;

    public BinaryTokenizerOperatorNodePushable(IHyracksTaskContext ctx, RecordDescriptor inputRecDesc, RecordDescriptor outputRecDesc, IBinaryTokenizer tokenizer, int docField, int[] keyFields, boolean addNumTokensKey, boolean writeKeyFieldsFirst) {
        this.ctx = ctx;
        this.tokenizer = tokenizer;
        this.docField = docField;
        this.keyFields = keyFields;
        this.addNumTokensKey = addNumTokensKey;
        this.inputRecDesc = inputRecDesc;
        this.outputRecDesc = outputRecDesc;
        this.writeKeyFieldsFirst = writeKeyFieldsFirst;
    }

    public void open() throws HyracksDataException {
        this.writer.open();
        this.accessor = new FrameTupleAccessor(this.inputRecDesc);
        this.builder = new ArrayTupleBuilder(this.outputRecDesc.getFieldCount());
        this.builderData = this.builder.getFieldData();
        this.appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.ctx), true);
    }

    /*
     * Unable to fully structure code
     */
    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        tupleCount = this.accessor.getTupleCount();
        for (i = 0; i < tupleCount; ++i) {
            numTokens = 0;
            this.tokenizer.reset(this.accessor.getBuffer().array(), this.accessor.getTupleStartOffset(i) + this.accessor.getFieldSlotsLength() + this.accessor.getFieldStartOffset(i, this.docField), this.accessor.getFieldLength(i, this.docField));
            if (this.addNumTokensKey) {
                numTokens = this.tokenizer.getTokensCount();
            }
            while (this.tokenizer.hasNext()) {
                this.tokenizer.next();
                this.builder.reset();
                if (!this.writeKeyFieldsFirst) {
                    try {
                        token = this.tokenizer.getToken();
                        token.serializeToken(this.builderData);
                        this.builder.addFieldEndOffset();
                        if (this.addNumTokensKey) {
                            this.builder.getDataOutput().writeShort(numTokens);
                            this.builder.addFieldEndOffset();
                        }
                    }
                    catch (IOException e) {
                        throw new HyracksDataException(e.getMessage());
                    }
                    for (k = 0; k < this.keyFields.length; ++k) {
                        this.builder.addField((IFrameTupleAccessor)this.accessor, i, this.keyFields[k]);
                    }
                } else {
                    for (k = 0; k < this.keyFields.length; ++k) {
                        this.builder.addField((IFrameTupleAccessor)this.accessor, i, this.keyFields[k]);
                    }
                    try {
                        token = this.tokenizer.getToken();
                        token.serializeToken(this.builderData);
                        this.builder.addFieldEndOffset();
                        if (!this.addNumTokensKey) ** GOTO lbl39
                        this.builder.getDataOutput().writeShort(numTokens);
                        this.builder.addFieldEndOffset();
                    }
                    catch (IOException e) {
                        throw new HyracksDataException(e.getMessage());
                    }
                }
lbl39:
                // 3 sources

                FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (int[])this.builder.getFieldEndOffsets(), (byte[])this.builder.getByteArray(), (int)0, (int)this.builder.getSize());
            }
        }
    }

    public void close() throws HyracksDataException {
        try {
            this.appender.write(this.writer, true);
        }
        finally {
            this.writer.close();
        }
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }

    public void flush() throws HyracksDataException {
        this.appender.flush(this.writer);
    }
}

