/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;

public class OperatorExpressionVisitor
extends AbstractSqlppExpressionScopingVisitor {
    private static final String CONCAT = "concat";

    public OperatorExpressionVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    public Expression visit(OperatorExpr operatorExpr, ILangExpression arg) throws CompilationException {
        ArrayList<Object> newExprList = new ArrayList<Object>();
        for (Expression expr : operatorExpr.getExprList()) {
            newExprList.add(expr.accept((ILangVisitor)this, (Object)operatorExpr));
        }
        operatorExpr.setExprList(newExprList);
        OperatorType opType = (OperatorType)operatorExpr.getOpList().get(0);
        switch (opType) {
            case LIKE: 
            case NOT_LIKE: {
                return this.processLikeOperator(operatorExpr, opType);
            }
            case IN: 
            case NOT_IN: {
                return this.processInOperator(operatorExpr, opType);
            }
            case CONCAT: {
                return this.processConcatOperator(operatorExpr);
            }
            case BETWEEN: 
            case NOT_BETWEEN: {
                return this.processBetweenOperator(operatorExpr, opType);
            }
        }
        return operatorExpr;
    }

    private Expression processLikeOperator(OperatorExpr operatorExpr, OperatorType opType) {
        CallExpr likeExpr = new CallExpr(new FunctionSignature(null, "like", 2), operatorExpr.getExprList());
        if (opType == OperatorType.LIKE) {
            return likeExpr;
        }
        return new CallExpr(new FunctionSignature(null, "not", 1), new ArrayList<CallExpr>(Collections.singletonList(likeExpr)));
    }

    private Expression processInOperator(OperatorExpr operatorExpr, OperatorType opType) throws CompilationException {
        VariableExpr bindingVar = new VariableExpr(this.context.newVariable());
        Expression itemExpr = (Expression)operatorExpr.getExprList().get(0);
        Expression collectionExpr = (Expression)operatorExpr.getExprList().get(1);
        OperatorExpr comparison = new OperatorExpr();
        comparison.addOperand(itemExpr);
        comparison.addOperand((Expression)bindingVar);
        comparison.setCurrentop(true);
        if (opType == OperatorType.IN) {
            comparison.addOperator("=");
            return new QuantifiedExpression(QuantifiedExpression.Quantifier.SOME, new ArrayList<QuantifiedPair>(Collections.singletonList(new QuantifiedPair(bindingVar, collectionExpr))), (Expression)comparison);
        }
        comparison.addOperator("!=");
        return new QuantifiedExpression(QuantifiedExpression.Quantifier.EVERY, new ArrayList<QuantifiedPair>(Collections.singletonList(new QuantifiedPair(bindingVar, collectionExpr))), (Expression)comparison);
    }

    private Expression processConcatOperator(OperatorExpr operatorExpr) {
        return new CallExpr(new FunctionSignature(null, CONCAT, 1), operatorExpr.getExprList());
    }

    private Expression processBetweenOperator(OperatorExpr operatorExpr, OperatorType opType) throws CompilationException {
        Expression target = (Expression)operatorExpr.getExprList().get(0);
        Expression left = (Expression)operatorExpr.getExprList().get(1);
        Expression right = (Expression)operatorExpr.getExprList().get(2);
        Expression leftComparison = this.createLessThanExpression(left, target, operatorExpr.getHints());
        Expression rightComparison = this.createLessThanExpression(target, right, operatorExpr.getHints());
        OperatorExpr andExpr = new OperatorExpr();
        andExpr.addOperand(leftComparison);
        andExpr.addOperand(rightComparison);
        andExpr.addOperator("and");
        return opType == OperatorType.BETWEEN ? andExpr : new CallExpr(new FunctionSignature(null, "not", 1), new ArrayList<OperatorExpr>(Collections.singletonList(andExpr)));
    }

    private Expression createLessThanExpression(Expression lhs, Expression rhs, List<IExpressionAnnotation> hints) throws CompilationException {
        OperatorExpr comparison = new OperatorExpr();
        comparison.addOperand(lhs);
        comparison.addOperand(rhs);
        comparison.addOperator("<=");
        if (hints != null) {
            for (IExpressionAnnotation hint : hints) {
                comparison.addHint(hint);
            }
        }
        return comparison;
    }
}

