/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.annotations.AutoDataGen;
import org.apache.asterix.common.annotations.DateBetweenYearsDataGen;
import org.apache.asterix.common.annotations.DatetimeAddRandHoursDataGen;
import org.apache.asterix.common.annotations.DatetimeBetweenYearsDataGen;
import org.apache.asterix.common.annotations.FieldIntervalDataGen;
import org.apache.asterix.common.annotations.FieldValFileDataGen;
import org.apache.asterix.common.annotations.FieldValFileSameIndexDataGen;
import org.apache.asterix.common.annotations.IRecordFieldDataGen;
import org.apache.asterix.common.annotations.InsertRandIntDataGen;
import org.apache.asterix.common.annotations.ListDataGen;
import org.apache.asterix.common.annotations.ListValFileDataGen;
import org.apache.asterix.common.annotations.SkipSecondaryIndexSearchExpressionAnnotation;
import org.apache.asterix.common.annotations.TypeDataGen;
import org.apache.asterix.common.annotations.UndeclaredFieldsDataGen;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.UpdateClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.context.RootScopeFactory;
import org.apache.asterix.lang.common.context.Scope;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.OrderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.RecordTypeDefinition;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.expression.TypeReferenceExpression;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.UnorderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.DoubleLiteral;
import org.apache.asterix.lang.common.literal.FalseLiteral;
import org.apache.asterix.lang.common.literal.FloatLiteral;
import org.apache.asterix.lang.common.literal.LongIntegerLiteral;
import org.apache.asterix.lang.common.literal.MissingLiteral;
import org.apache.asterix.lang.common.literal.NullLiteral;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.literal.TrueLiteral;
import org.apache.asterix.lang.common.parser.ScopeChecker;
import org.apache.asterix.lang.common.statement.CompactStatement;
import org.apache.asterix.lang.common.statement.ConnectFeedStatement;
import org.apache.asterix.lang.common.statement.CreateDataverseStatement;
import org.apache.asterix.lang.common.statement.CreateFeedPolicyStatement;
import org.apache.asterix.lang.common.statement.CreateFeedStatement;
import org.apache.asterix.lang.common.statement.CreateFunctionStatement;
import org.apache.asterix.lang.common.statement.CreateIndexStatement;
import org.apache.asterix.lang.common.statement.DatasetDecl;
import org.apache.asterix.lang.common.statement.DataverseDecl;
import org.apache.asterix.lang.common.statement.DataverseDropStatement;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.DisconnectFeedStatement;
import org.apache.asterix.lang.common.statement.DropDatasetStatement;
import org.apache.asterix.lang.common.statement.ExternalDetailsDecl;
import org.apache.asterix.lang.common.statement.FeedDropStatement;
import org.apache.asterix.lang.common.statement.FeedPolicyDropStatement;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.FunctionDropStatement;
import org.apache.asterix.lang.common.statement.IDatasetDetailsDecl;
import org.apache.asterix.lang.common.statement.IndexDropStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.InternalDetailsDecl;
import org.apache.asterix.lang.common.statement.LoadStatement;
import org.apache.asterix.lang.common.statement.NodeGroupDropStatement;
import org.apache.asterix.lang.common.statement.NodegroupDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.statement.RefreshExternalDatasetStatement;
import org.apache.asterix.lang.common.statement.RunStatement;
import org.apache.asterix.lang.common.statement.SetStatement;
import org.apache.asterix.lang.common.statement.StartFeedStatement;
import org.apache.asterix.lang.common.statement.StopFeedStatement;
import org.apache.asterix.lang.common.statement.TypeDecl;
import org.apache.asterix.lang.common.statement.TypeDropStatement;
import org.apache.asterix.lang.common.statement.UpdateStatement;
import org.apache.asterix.lang.common.statement.UpsertStatement;
import org.apache.asterix.lang.common.statement.WriteStatement;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.optype.JoinType;
import org.apache.asterix.lang.sqlpp.optype.SetOpType;
import org.apache.asterix.lang.sqlpp.parser.JavaCharStream;
import org.apache.asterix.lang.sqlpp.parser.ParseException;
import org.apache.asterix.lang.sqlpp.parser.SQLPPParserConstants;
import org.apache.asterix.lang.sqlpp.parser.SQLPPParserTokenManager;
import org.apache.asterix.lang.sqlpp.parser.Token;
import org.apache.asterix.lang.sqlpp.parser.TokenMgrError;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.ExpressionToVariableUtil;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.IndexedNLJoinExpressionAnnotation;

class SQLPPParser
extends ScopeChecker
implements IParser,
SQLPPParserConstants {
    private static final String AUTO_HINT = "auto";
    private static final String BROADCAST_JOIN_HINT = "bcast";
    private static final String COMPOSE_VAL_FILES_HINT = "compose-val-files";
    private static final String DATE_BETWEEN_YEARS_HINT = "date-between-years";
    private static final String DATETIME_ADD_RAND_HOURS_HINT = "datetime-add-rand-hours";
    private static final String DATETIME_BETWEEN_YEARS_HINT = "datetime-between-years";
    private static final String HASH_GROUP_BY_HINT = "hash";
    private static final String INDEXED_NESTED_LOOP_JOIN_HINT = "indexnl";
    private static final String INMEMORY_HINT = "inmem";
    private static final String INSERT_RAND_INT_HINT = "insert-rand-int";
    private static final String INTERVAL_HINT = "interval";
    private static final String LIST_HINT = "list";
    private static final String LIST_VAL_FILE_HINT = "list-val-file";
    private static final String RANGE_HINT = "range";
    private static final String SKIP_SECONDARY_INDEX_SEARCH_HINT = "skip-index";
    private static final String VAL_FILE_HINT = "val-files";
    private static final String VAL_FILE_SAME_INDEX_HINT = "val-file-same-idx";
    private static final String GEN_FIELDS_HINT = "gen-fields";
    private static final String DGEN_HINT = "dgen";
    protected static final boolean REPORT_EXPECTED_TOKENS = false;
    public SQLPPParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[177];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private final JJCalls[] jj_2_rtns = new JJCalls[11];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private static String getHint(Token t) {
        if (t.specialToken == null) {
            return null;
        }
        String s = t.specialToken.image;
        int n = s.length();
        if (n < 2) {
            return null;
        }
        return s.substring(1).trim();
    }

    private static IRecordFieldDataGen parseFieldDataGen(String hint) throws ParseException {
        FieldValFileDataGen rfdg = null;
        String[] splits = hint.split(" +");
        if (splits[0].equals(VAL_FILE_HINT)) {
            File[] valFiles = new File[splits.length - 1];
            for (int k = 1; k < splits.length; ++k) {
                valFiles[k - 1] = new File(splits[k]);
            }
            rfdg = new FieldValFileDataGen(valFiles);
        } else if (splits[0].equals(VAL_FILE_SAME_INDEX_HINT)) {
            rfdg = new FieldValFileSameIndexDataGen(new File(splits[1]), splits[2]);
        } else if (splits[0].equals(LIST_VAL_FILE_HINT)) {
            rfdg = new ListValFileDataGen(new File(splits[1]), Integer.parseInt(splits[2]), Integer.parseInt(splits[3]));
        } else if (splits[0].equals(LIST_HINT)) {
            rfdg = new ListDataGen(Integer.parseInt(splits[1]), Integer.parseInt(splits[2]));
        } else if (splits[0].equals(INTERVAL_HINT)) {
            FieldIntervalDataGen.ValueType vt;
            if (splits[1].equals("int")) {
                vt = FieldIntervalDataGen.ValueType.INT;
            } else if (splits[1].equals("long")) {
                vt = FieldIntervalDataGen.ValueType.LONG;
            } else if (splits[1].equals("float")) {
                vt = FieldIntervalDataGen.ValueType.FLOAT;
            } else if (splits[1].equals("double")) {
                vt = FieldIntervalDataGen.ValueType.DOUBLE;
            } else {
                throw new ParseException("Unknown type for interval data gen: " + splits[1]);
            }
            rfdg = new FieldIntervalDataGen(vt, splits[2], splits[3]);
        } else if (splits[0].equals(INSERT_RAND_INT_HINT)) {
            rfdg = new InsertRandIntDataGen(splits[1], splits[2]);
        } else if (splits[0].equals(DATE_BETWEEN_YEARS_HINT)) {
            rfdg = new DateBetweenYearsDataGen(Integer.parseInt(splits[1]), Integer.parseInt(splits[2]));
        } else if (splits[0].equals(DATETIME_BETWEEN_YEARS_HINT)) {
            rfdg = new DatetimeBetweenYearsDataGen(Integer.parseInt(splits[1]), Integer.parseInt(splits[2]));
        } else if (splits[0].equals(DATETIME_ADD_RAND_HOURS_HINT)) {
            rfdg = new DatetimeAddRandHoursDataGen(Integer.parseInt(splits[1]), Integer.parseInt(splits[2]), splits[3]);
        } else if (splits[0].equals(AUTO_HINT)) {
            rfdg = new AutoDataGen(splits[1]);
        }
        return rfdg;
    }

    public SQLPPParser(String s) {
        this(new StringReader(s));
        super.setInput(s);
    }

    public static void main(String[] args) throws ParseException, TokenMgrError, IOException, FileNotFoundException, CompilationException {
        File file = new File(args[0]);
        BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        SQLPPParser parser = new SQLPPParser(fis);
        List<Statement> st = parser.parse();
    }

    public List<Statement> parse() throws CompilationException {
        try {
            return this.Statement();
        }
        catch (Error e) {
            throw new CompilationException((Throwable)new ParseException(e.getMessage()));
        }
        catch (ParseException e) {
            throw new CompilationException("Syntax error: " + this.getMessage(e));
        }
    }

    protected String getMessage(ParseException pe) {
        Token currentToken = pe.currentToken;
        if (currentToken == null) {
            return pe.getMessage();
        }
        int[][] expectedTokenSequences = pe.expectedTokenSequences;
        String[] tokenImage = pe.tokenImage;
        String sep = " ";
        StringBuilder expected = null;
        int maxSize = this.appendExpected(expected, expectedTokenSequences, tokenImage);
        Token tok = currentToken.next;
        int line = tok.beginLine;
        String message = "In line " + line + " >>" + this.getLine(line) + "<<" + sep + "Encountered ";
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                message = message + " ";
            }
            if (tok.kind == 0) {
                message = message + SQLPPParser.fixQuotes((String)tokenImage[0]);
                break;
            }
            String fixedTokenImage = tokenImage[tok.kind];
            if (!tok.image.equalsIgnoreCase(SQLPPParser.stripQuotes((String)fixedTokenImage))) {
                message = message + SQLPPParser.fixQuotes((String)fixedTokenImage) + " ";
            }
            message = message + quot + SQLPPParser.addEscapes((String)tok.image) + quot;
            tok = tok.next;
        }
        message = message + " at column " + currentToken.next.beginColumn + "." + sep;
        return message;
    }

    public final List<Statement> Statement() throws ParseException, ParseException {
        this.scopeStack.push(RootScopeFactory.createRootScope((ScopeChecker)this));
        ArrayList<Statement> decls = new ArrayList<Statement>();
        Statement stmt = null;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 22: 
                case 24: 
                case 26: 
                case 28: 
                case 30: 
                case 34: 
                case 36: 
                case 42: 
                case 55: 
                case 63: 
                case 64: 
                case 67: 
                case 70: 
                case 83: 
                case 87: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 102: 
                case 103: 
                case 104: 
                case 109: 
                case 110: 
                case 115: 
                case 118: 
                case 119: 
                case 121: 
                case 138: 
                case 140: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 148: 
                case 149: 
                case 153: 
                case 154: 
                case 164: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block9;
                }
            }
            stmt = this.SingleStatement();
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 128: {
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        break block10;
                    }
                }
                this.jj_consume_token(128);
            }
            decls.add(stmt);
        }
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 128: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block11;
                }
            }
            this.jj_consume_token(128);
        }
        this.jj_consume_token(0);
        return decls;
    }

    public final Statement SingleStatement() throws ParseException, ParseException {
        DataverseDecl stmt = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 104: {
                stmt = this.DataverseDeclaration();
                break;
            }
            case 22: {
                stmt = this.FunctionDeclaration();
                break;
            }
            case 14: {
                stmt = this.CreateStatement();
                break;
            }
            case 67: {
                stmt = this.LoadStatement();
                break;
            }
            case 28: {
                stmt = this.DropStatement();
                break;
            }
            case 110: {
                stmt = this.WriteStatement();
                break;
            }
            case 91: {
                stmt = this.SetStatement();
                break;
            }
            case 55: {
                stmt = this.InsertStatement();
                break;
            }
            case 24: {
                stmt = this.DeleteStatement();
                break;
            }
            case 102: {
                stmt = this.UpdateStatement();
                break;
            }
            case 103: {
                stmt = this.UpsertStatement();
                break;
            }
            case 17: 
            case 26: 
            case 93: 
            case 94: {
                stmt = this.ConnectionStatement();
                break;
            }
            case 16: {
                stmt = this.CompactStatement();
                break;
            }
            case 30: {
                stmt = this.ExplainStatement();
                break;
            }
            case 3: 
            case 12: 
            case 34: 
            case 36: 
            case 42: 
            case 63: 
            case 64: 
            case 70: 
            case 90: 
            case 92: 
            case 109: 
            case 115: 
            case 118: 
            case 119: 
            case 121: 
            case 138: 
            case 140: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 148: 
            case 149: 
            case 153: 
            case 154: 
            case 164: {
                stmt = this.Query(false);
                this.jj_consume_token(128);
                break;
            }
            case 83: {
                stmt = this.RefreshExternalDatasetStatement();
                break;
            }
            case 87: {
                stmt = this.RunStatement();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final DataverseDecl DataverseDeclaration() throws ParseException, ParseException {
        String dvName = null;
        this.jj_consume_token(104);
        this.defaultDataverse = dvName = this.Identifier();
        return new DataverseDecl(new Identifier(dvName));
    }

    public final Statement CreateStatement() throws ParseException, ParseException {
        String hint = null;
        boolean dgen = false;
        NodegroupDecl stmt = null;
        this.jj_consume_token(14);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 97: {
                hint = SQLPPParser.getHint(this.token);
                if (hint != null && hint.startsWith(DGEN_HINT)) {
                    dgen = true;
                }
                stmt = this.TypeSpecification(hint, dgen);
                break;
            }
            case 68: {
                stmt = this.NodegroupSpecification();
                break;
            }
            case 19: 
            case 20: 
            case 37: 
            case 56: 
            case 95: {
                stmt = this.DatasetSpecification();
                break;
            }
            case 52: {
                stmt = this.IndexSpecification();
                break;
            }
            case 21: {
                stmt = this.DataverseSpecification();
                break;
            }
            case 45: {
                stmt = this.FunctionSpecification();
                break;
            }
            case 38: {
                stmt = this.FeedSpecification();
                break;
            }
            case 53: {
                stmt = this.FeedPolicySpecification();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final TypeDecl TypeSpecification(String hint, boolean dgen) throws ParseException, ParseException {
        Pair<Identifier, Identifier> nameComponents = null;
        boolean ifNotExists = false;
        RecordTypeDefinition typeExpr = null;
        this.jj_consume_token(97);
        nameComponents = this.TypeName();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(5);
        typeExpr = this.RecordTypeDef();
        long numValues = -1L;
        String filename = null;
        if (dgen) {
            String[] splits = hint.split(" +");
            if (splits.length != 3) {
                throw new ParseException("Expecting /*+ dgen <filename> <numberOfItems> */");
            }
            filename = splits[1];
            numValues = Long.parseLong(splits[2]);
        }
        TypeDataGen tddg = new TypeDataGen(dgen, filename, numValues);
        return new TypeDecl((Identifier)nameComponents.first, (Identifier)nameComponents.second, (TypeExpression)typeExpr, tddg, ifNotExists);
    }

    public final NodegroupDecl NodegroupSpecification() throws ParseException, ParseException {
        String name = null;
        String tmp = null;
        boolean ifNotExists = false;
        ArrayList<Identifier> ncNames = null;
        this.jj_consume_token(68);
        name = this.Identifier();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(72);
        tmp = this.Identifier();
        ncNames = new ArrayList<Identifier>();
        ncNames.add(new Identifier(tmp));
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(125);
            tmp = this.Identifier();
            ncNames.add(new Identifier(tmp));
        }
        return new NodegroupDecl(new Identifier(name), ncNames, ifNotExists);
    }

    public final DatasetDecl DatasetSpecification() throws ParseException, ParseException {
        Pair<Identifier, Identifier> nameComponents = null;
        boolean ifNotExists = false;
        Pair<Identifier, Identifier> typeComponents = null;
        String adapterName = null;
        Map<String, String> properties = null;
        Map<String, String> compactionPolicyProperties = null;
        Object appliedFunction = null;
        Pair<List<Integer>, List<List<String>>> primaryKeyFields = null;
        String nodeGroupName = null;
        Map<Object, Object> hints = new HashMap();
        DatasetDecl dsetDecl = null;
        boolean autogenerated = false;
        String compactionPolicy = null;
        boolean temp = false;
        Pair<Integer, List<String>> filterField = null;
        Pair<Identifier, Identifier> metaTypeComponents = new Pair<Identifier, Identifier>(null, null);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                this.Dataset();
                nameComponents = this.QualifiedName();
                this.jj_consume_token(119);
                typeComponents = this.TypeName();
                this.jj_consume_token(120);
                ifNotExists = this.IfNotExists();
                this.jj_consume_token(105);
                adapterName = this.AdapterName();
                properties = this.Configuration();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 72: {
                        this.jj_consume_token(72);
                        nodeGroupName = this.Identifier();
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 48: {
                        this.jj_consume_token(48);
                        hints = this.Properties();
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                    }
                }
                block10 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 105: {
                        this.jj_consume_token(105);
                        this.jj_consume_token(15);
                        this.jj_consume_token(79);
                        compactionPolicy = this.CompactionPolicy();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 119: {
                                compactionPolicyProperties = this.Configuration();
                                break block10;
                            }
                        }
                        this.jj_la1[8] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                    }
                }
                ExternalDetailsDecl edd = new ExternalDetailsDecl();
                edd.setAdapter(adapterName);
                edd.setProperties(properties);
                dsetDecl = new DatasetDecl((Identifier)nameComponents.first, (Identifier)nameComponents.second, (Identifier)typeComponents.first, (Identifier)typeComponents.second, (Identifier)metaTypeComponents.first, (Identifier)metaTypeComponents.second, nodeGroupName != null ? new Identifier(nodeGroupName) : null, compactionPolicy, compactionPolicyProperties, hints, DatasetConfig.DatasetType.EXTERNAL, (IDatasetDetailsDecl)edd, ifNotExists);
                break;
            }
            case 19: 
            case 20: 
            case 56: 
            case 95: {
                block16 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 56: 
                    case 95: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 56: {
                                this.jj_consume_token(56);
                                break block16;
                            }
                            case 95: {
                                this.jj_consume_token(95);
                                temp = true;
                                break block16;
                            }
                        }
                        this.jj_la1[10] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                    }
                }
                this.Dataset();
                nameComponents = this.QualifiedName();
                this.jj_consume_token(119);
                typeComponents = this.TypeName();
                this.jj_consume_token(120);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 109: {
                        this.jj_consume_token(109);
                        String name = this.Identifier();
                        if (!name.toLowerCase().equals("meta")) {
                            throw new ParseException("We can only support one additional associated field called \"meta\".");
                        }
                        this.jj_consume_token(119);
                        metaTypeComponents = this.TypeName();
                        this.jj_consume_token(120);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                    }
                }
                ifNotExists = this.IfNotExists();
                primaryKeyFields = this.PrimaryKey();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        autogenerated = true;
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 72: {
                        this.jj_consume_token(72);
                        nodeGroupName = this.Identifier();
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 48: {
                        this.jj_consume_token(48);
                        hints = this.Properties();
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                    }
                }
                block35 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 105: {
                        this.jj_consume_token(105);
                        this.jj_consume_token(15);
                        this.jj_consume_token(79);
                        compactionPolicy = this.CompactionPolicy();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 119: {
                                compactionPolicyProperties = this.Configuration();
                                break block35;
                            }
                        }
                        this.jj_la1[16] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                    }
                }
                if (this.jj_2_1(2)) {
                    this.jj_consume_token(109);
                    this.jj_consume_token(39);
                    this.jj_consume_token(72);
                    filterField = this.NestedField();
                }
                if (filterField != null && (Integer)filterField.first != 0) {
                    throw new ParseException("A filter field can only be a field in the main record of the dataset.");
                }
                InternalDetailsDecl idd = new InternalDetailsDecl((List)primaryKeyFields.second, (List)primaryKeyFields.first, autogenerated, filterField == null ? null : (List)filterField.second, temp);
                dsetDecl = new DatasetDecl((Identifier)nameComponents.first, (Identifier)nameComponents.second, (Identifier)typeComponents.first, (Identifier)typeComponents.second, (Identifier)metaTypeComponents.first, (Identifier)metaTypeComponents.second, nodeGroupName != null ? new Identifier(nodeGroupName) : null, compactionPolicy, compactionPolicyProperties, hints, DatasetConfig.DatasetType.INTERNAL, (IDatasetDetailsDecl)idd, ifNotExists);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return dsetDecl;
    }

    public final RefreshExternalDatasetStatement RefreshExternalDatasetStatement() throws ParseException, ParseException {
        RefreshExternalDatasetStatement redss = new RefreshExternalDatasetStatement();
        Pair<Identifier, Identifier> nameComponents = null;
        Object datasetName = null;
        this.jj_consume_token(83);
        this.jj_consume_token(37);
        this.Dataset();
        nameComponents = this.QualifiedName();
        redss.setDataverseName((Identifier)nameComponents.first);
        redss.setDatasetName((Identifier)nameComponents.second);
        return redss;
    }

    public final RunStatement RunStatement() throws ParseException, ParseException {
        String system = null;
        ArrayList<String> parameters = new ArrayList<String>();
        Pair<Identifier, Identifier> nameComponentsFrom = null;
        Pair<Identifier, Identifier> nameComponentsTo = null;
        this.jj_consume_token(87);
        system = this.Identifier();
        this.jj_consume_token(119);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 153: 
                case 164: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block6;
                }
            }
            String tmp = this.Identifier();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    this.jj_consume_token(125);
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                }
            }
            parameters.add(tmp);
        }
        this.jj_consume_token(120);
        this.jj_consume_token(42);
        this.Dataset();
        nameComponentsFrom = this.QualifiedName();
        this.jj_consume_token(98);
        this.Dataset();
        nameComponentsTo = this.QualifiedName();
        return new RunStatement(system, parameters, (Identifier)nameComponentsFrom.first, (Identifier)nameComponentsFrom.second, (Identifier)nameComponentsTo.first, (Identifier)nameComponentsTo.second);
    }

    public final CreateIndexStatement IndexSpecification() throws ParseException, ParseException {
        CreateIndexStatement cis = new CreateIndexStatement();
        String indexName = null;
        boolean ifNotExists = false;
        Pair<Identifier, Identifier> nameComponents = null;
        Pair<Integer, Pair<List<String>, TypeExpression>> fieldPair = null;
        IndexParams indexType = null;
        boolean enforced = false;
        this.jj_consume_token(52);
        indexName = this.Identifier();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(72);
        nameComponents = this.QualifiedName();
        this.jj_consume_token(119);
        fieldPair = this.OpenField();
        cis.addFieldExprPair((Pair)fieldPair.second);
        cis.addFieldIndexIndicator((Integer)fieldPair.first);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(125);
            fieldPair = this.OpenField();
            cis.addFieldExprPair((Pair)fieldPair.second);
            cis.addFieldIndexIndicator((Integer)fieldPair.first);
        }
        this.jj_consume_token(120);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 97: {
                this.jj_consume_token(97);
                indexType = this.IndexType();
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                enforced = true;
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        cis.setIndexName(new Identifier(indexName));
        cis.setIfNotExists(ifNotExists);
        cis.setDataverseName((Identifier)nameComponents.first);
        cis.setDatasetName((Identifier)nameComponents.second);
        if (indexType != null) {
            cis.setIndexType(indexType.type);
            cis.setGramLength(indexType.gramLength);
        }
        cis.setEnforced(enforced);
        return cis;
    }

    public final String CompactionPolicy() throws ParseException, ParseException {
        String compactionPolicy = null;
        compactionPolicy = this.Identifier();
        return compactionPolicy;
    }

    public final String FilterField() throws ParseException, ParseException {
        String filterField = null;
        filterField = this.Identifier();
        return filterField;
    }

    public final IndexParams IndexType() throws ParseException, ParseException {
        DatasetConfig.IndexType type = null;
        int gramLength = 0;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                type = DatasetConfig.IndexType.BTREE;
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                type = DatasetConfig.IndexType.RTREE;
                break;
            }
            case 60: {
                this.jj_consume_token(60);
                type = DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX;
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                type = DatasetConfig.IndexType.SINGLE_PARTITION_WORD_INVIX;
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                this.jj_consume_token(119);
                this.jj_consume_token(142);
                type = DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
                gramLength = Integer.valueOf(this.token.image);
                this.jj_consume_token(120);
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new IndexParams(type, gramLength);
    }

    public final CreateDataverseStatement DataverseSpecification() throws ParseException, ParseException {
        String dvName = null;
        boolean ifNotExists = false;
        this.jj_consume_token(21);
        dvName = this.Identifier();
        ifNotExists = this.IfNotExists();
        return new CreateDataverseStatement(new Identifier(dvName), null, ifNotExists);
    }

    public final CreateFunctionStatement FunctionSpecification() throws ParseException, ParseException {
        boolean ifNotExists = false;
        List<Object> paramList = new ArrayList();
        Object var = null;
        FunctionName fctName = null;
        this.createNewScope();
        this.jj_consume_token(45);
        fctName = this.FunctionName();
        ifNotExists = this.IfNotExists();
        paramList = this.ParameterList();
        this.jj_consume_token(138);
        Token beginPos = this.token;
        Expression functionBodyExpr = this.Expression();
        this.jj_consume_token(139);
        Token endPos = this.token;
        String functionBody = this.extractFragment(beginPos.beginLine, beginPos.beginColumn, endPos.beginLine, endPos.beginColumn);
        FunctionSignature signature = new FunctionSignature(fctName.dataverse, fctName.function, paramList.size());
        this.getCurrentScope().addFunctionDescriptor(signature, false);
        this.removeCurrentScope();
        return new CreateFunctionStatement(signature, paramList, functionBody, ifNotExists);
    }

    public final CreateFeedStatement FeedSpecification() throws ParseException, ParseException {
        Pair<Identifier, Identifier> nameComponents = null;
        boolean ifNotExists = false;
        String adapterName = null;
        Map<String, String> properties = null;
        CreateFeedStatement cfs = null;
        Object sourceNameComponents = null;
        this.jj_consume_token(38);
        nameComponents = this.QualifiedName();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(105);
        adapterName = this.AdapterName();
        properties = this.Configuration();
        cfs = new CreateFeedStatement(nameComponents, adapterName, properties, ifNotExists);
        return cfs;
    }

    public final CreateFeedPolicyStatement FeedPolicySpecification() throws ParseException, ParseException {
        String policyName = null;
        String basePolicyName = null;
        String sourcePolicyFile = null;
        String definition = null;
        boolean ifNotExists = false;
        Map<String, String> properties = null;
        CreateFeedPolicyStatement cfps = null;
        this.jj_consume_token(53);
        this.jj_consume_token(79);
        policyName = this.Identifier();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(42);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 79: {
                this.jj_consume_token(79);
                basePolicyName = this.Identifier();
                properties = this.Configuration();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        definition = this.ConstantString();
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                    }
                }
                cfps = new CreateFeedPolicyStatement(policyName, basePolicyName, properties, definition, ifNotExists);
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                sourcePolicyFile = this.ConstantString();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        definition = this.ConstantString();
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                    }
                }
                cfps = new CreateFeedPolicyStatement(policyName, sourcePolicyFile, definition, ifNotExists);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return cfps;
    }

    public final List<VarIdentifier> ParameterList() throws ParseException, ParseException {
        ArrayList<VarIdentifier> paramList = new ArrayList<VarIdentifier>();
        VarIdentifier var = null;
        this.jj_consume_token(119);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 164: {
                this.jj_consume_token(164);
                var = SqlppVariableUtil.toInternalVariableIdentifier(this.token.image);
                paramList.add(var);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 125: {
                            break;
                        }
                        default: {
                            this.jj_la1[28] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(125);
                    this.jj_consume_token(164);
                    var = SqlppVariableUtil.toInternalVariableIdentifier(this.token.image);
                    paramList.add(var);
                }
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
            }
        }
        this.jj_consume_token(120);
        return paramList;
    }

    public final boolean IfNotExists() throws ParseException, ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: {
                this.jj_consume_token(49);
                this.jj_consume_token(70);
                this.jj_consume_token(36);
                return true;
            }
        }
        this.jj_la1[30] = this.jj_gen;
        return false;
    }

    public final List<FunctionSignature> ApplyFunction() throws ParseException, ParseException {
        FunctionName functioName = null;
        String fqFunctionName = null;
        ArrayList<FunctionSignature> funcSigs = new ArrayList<FunctionSignature>();
        this.jj_consume_token(4);
        this.jj_consume_token(45);
        functioName = this.FunctionName();
        fqFunctionName = functioName.library == null ? functioName.function : functioName.library + "#" + functioName.function;
        funcSigs.add(new FunctionSignature(functioName.dataverse, fqFunctionName, 1));
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(125);
            functioName = this.FunctionName();
            fqFunctionName = functioName.library == null ? functioName.function : functioName.library + "#" + functioName.function;
            funcSigs.add(new FunctionSignature(functioName.dataverse, fqFunctionName, 1));
        }
        return funcSigs;
    }

    public final String GetPolicy() throws ParseException, ParseException {
        String policy = null;
        this.jj_consume_token(105);
        this.jj_consume_token(79);
        policy = this.Identifier();
        return policy;
    }

    public final FunctionSignature FunctionSignature() throws ParseException, ParseException {
        FunctionName fctName = null;
        int arity = 0;
        fctName = this.FunctionName();
        this.jj_consume_token(123);
        this.jj_consume_token(142);
        arity = new Integer(this.token.image);
        if (arity < 0 && arity != -1) {
            throw new ParseException(" invalid arity:" + arity);
        }
        String fqFunctionName = fctName.library == null ? fctName.function : fctName.library + "#" + fctName.function;
        return new FunctionSignature(fctName.dataverse, fqFunctionName, arity);
    }

    public final Pair<List<Integer>, List<List<String>>> PrimaryKey() throws ParseException, ParseException {
        Pair<Integer, List<String>> tmp = null;
        ArrayList<Object> keyFieldSourceIndicators = new ArrayList<Object>();
        ArrayList<Object> primaryKeyFields = new ArrayList<Object>();
        this.jj_consume_token(81);
        this.jj_consume_token(61);
        tmp = this.NestedField();
        keyFieldSourceIndicators.add(tmp.first);
        primaryKeyFields.add(tmp.second);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(125);
            tmp = this.NestedField();
            keyFieldSourceIndicators.add(tmp.first);
            primaryKeyFields.add(tmp.second);
        }
        return new Pair(keyFieldSourceIndicators, primaryKeyFields);
    }

    public final Statement DropStatement() throws ParseException, ParseException {
        String id = null;
        Pair<Identifier, Identifier> pairId = null;
        Triple<Identifier, Identifier, Identifier> tripleId = null;
        FunctionSignature funcSig = null;
        boolean ifExists = false;
        FunctionDropStatement stmt = null;
        this.jj_consume_token(28);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 20: {
                this.Dataset();
                pairId = this.QualifiedName();
                ifExists = this.IfExists();
                stmt = new DropDatasetStatement((Identifier)pairId.first, (Identifier)pairId.second, ifExists);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                tripleId = this.DoubleQualifiedName();
                ifExists = this.IfExists();
                stmt = new IndexDropStatement((Identifier)tripleId.first, (Identifier)tripleId.second, (Identifier)tripleId.third, ifExists);
                break;
            }
            case 68: {
                this.jj_consume_token(68);
                id = this.Identifier();
                ifExists = this.IfExists();
                stmt = new NodeGroupDropStatement(new Identifier(id), ifExists);
                break;
            }
            case 97: {
                this.jj_consume_token(97);
                pairId = this.TypeName();
                ifExists = this.IfExists();
                stmt = new TypeDropStatement((Identifier)pairId.first, (Identifier)pairId.second, ifExists);
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                id = this.Identifier();
                ifExists = this.IfExists();
                stmt = new DataverseDropStatement(new Identifier(id), ifExists);
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                funcSig = this.FunctionSignature();
                ifExists = this.IfExists();
                stmt = new FunctionDropStatement(funcSig, ifExists);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                pairId = this.QualifiedName();
                ifExists = this.IfExists();
                stmt = new FeedDropStatement((Identifier)pairId.first, (Identifier)pairId.second, ifExists);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                this.jj_consume_token(79);
                pairId = this.QualifiedName();
                ifExists = this.IfExists();
                stmt = new FeedPolicyDropStatement((Identifier)pairId.first, (Identifier)pairId.second, ifExists);
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final boolean IfExists() throws ParseException, ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: {
                this.jj_consume_token(49);
                this.jj_consume_token(36);
                return true;
            }
        }
        this.jj_la1[34] = this.jj_gen;
        return false;
    }

    public final InsertStatement InsertStatement() throws ParseException, ParseException {
        Pair<Identifier, Identifier> nameComponents = null;
        VariableExpr var = null;
        Query query = null;
        Expression returnExpression = null;
        this.jj_consume_token(55);
        this.jj_consume_token(50);
        nameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                var = this.Variable();
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
            }
        }
        query = this.Query(false);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 85: {
                this.jj_consume_token(85);
                returnExpression = this.Expression();
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        if (returnExpression != null && var == null) {
            var = ExpressionToVariableUtil.getGeneratedVariable(query.getBody(), true);
        }
        query.setTopLevel(true);
        return new InsertStatement((Identifier)nameComponents.first, (Identifier)nameComponents.second, query, this.getVarCounter(), var, returnExpression);
    }

    public final UpsertStatement UpsertStatement() throws ParseException, ParseException {
        Pair<Identifier, Identifier> nameComponents = null;
        VariableExpr var = null;
        Query query = null;
        Expression returnExpression = null;
        this.jj_consume_token(103);
        this.jj_consume_token(50);
        nameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                var = this.Variable();
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
        query = this.Query(false);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 85: {
                this.jj_consume_token(85);
                returnExpression = this.Expression();
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        if (returnExpression != null && var == null) {
            var = ExpressionToVariableUtil.getGeneratedVariable(query.getBody(), true);
        }
        query.setTopLevel(true);
        return new UpsertStatement((Identifier)nameComponents.first, (Identifier)nameComponents.second, query, this.getVarCounter(), var, returnExpression);
    }

    public final DeleteStatement DeleteStatement() throws ParseException, ParseException {
        VariableExpr varExpr = null;
        Expression condition = null;
        this.jj_consume_token(24);
        this.jj_consume_token(42);
        Pair<Identifier, Identifier> nameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 153: 
            case 164: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[39] = this.jj_gen;
                    }
                }
                varExpr = this.Variable();
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 108: {
                this.jj_consume_token(108);
                condition = this.Expression();
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
        if (varExpr == null) {
            varExpr = new VariableExpr();
            VarIdentifier var = SqlppVariableUtil.toInternalVariableIdentifier(((Identifier)nameComponents.second).getValue());
            varExpr.setVar(var);
        }
        return new DeleteStatement(varExpr, (Identifier)nameComponents.first, (Identifier)nameComponents.second, condition, this.getVarCounter());
    }

    public final UpdateStatement UpdateStatement() throws ParseException, ParseException {
        ArrayList<UpdateClause> ucs = new ArrayList<UpdateClause>();
        this.jj_consume_token(102);
        VariableExpr vars = this.Variable();
        this.jj_consume_token(51);
        Expression target = this.Expression();
        this.jj_consume_token(108);
        Expression condition = this.Expression();
        this.jj_consume_token(119);
        UpdateClause uc = this.UpdateClause();
        ucs.add(uc);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(125);
            uc = this.UpdateClause();
            ucs.add(uc);
        }
        this.jj_consume_token(120);
        return new UpdateStatement(vars, target, condition, ucs);
    }

    public final UpdateClause UpdateClause() throws ParseException, ParseException {
        Expression target = null;
        Expression value = null;
        InsertStatement is = null;
        DeleteStatement ds = null;
        UpdateStatement us = null;
        Expression condition = null;
        UpdateClause ifbranch = null;
        UpdateClause elsebranch = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 91: {
                this.jj_consume_token(91);
                target = this.Expression();
                this.jj_consume_token(134);
                value = this.Expression();
                break;
            }
            case 55: {
                is = this.InsertStatement();
                break;
            }
            case 24: {
                ds = this.DeleteStatement();
                break;
            }
            case 102: {
                us = this.UpdateStatement();
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                this.jj_consume_token(119);
                condition = this.Expression();
                this.jj_consume_token(120);
                this.jj_consume_token(96);
                ifbranch = this.UpdateClause();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 31: {
                        this.jj_consume_token(31);
                        elsebranch = this.UpdateClause();
                        break;
                    }
                    default: {
                        this.jj_la1[43] = this.jj_gen;
                    }
                }
                return new UpdateClause(target, value, is, ds, us, condition, ifbranch, elsebranch);
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement SetStatement() throws ParseException, ParseException {
        String pn = null;
        String pv = null;
        this.jj_consume_token(91);
        pn = this.Identifier();
        pv = this.ConstantString();
        return new SetStatement(pn, pv);
    }

    public final Statement WriteStatement() throws ParseException, ParseException {
        String nodeName = null;
        String fileName = null;
        String writerClass = null;
        Object nameComponents = null;
        this.jj_consume_token(110);
        this.jj_consume_token(77);
        this.jj_consume_token(98);
        nodeName = this.Identifier();
        this.jj_consume_token(124);
        fileName = this.ConstantString();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 105: {
                this.jj_consume_token(105);
                writerClass = this.ConstantString();
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
            }
        }
        return new WriteStatement(new Identifier(nodeName), fileName, writerClass);
    }

    public final LoadStatement LoadStatement() throws ParseException, ParseException {
        Identifier dataverseName = null;
        Identifier datasetName = null;
        boolean alreadySorted = false;
        Pair<Identifier, Identifier> nameComponents = null;
        this.jj_consume_token(67);
        this.Dataset();
        nameComponents = this.QualifiedName();
        dataverseName = (Identifier)nameComponents.first;
        datasetName = (Identifier)nameComponents.second;
        this.jj_consume_token(105);
        String adapterName = this.AdapterName();
        Map<String, String> properties = this.Configuration();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 80: {
                this.jj_consume_token(80);
                alreadySorted = true;
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
            }
        }
        return new LoadStatement(dataverseName, datasetName, adapterName, properties, alreadySorted);
    }

    public final String AdapterName() throws ParseException, ParseException {
        String adapterName = null;
        adapterName = this.Identifier();
        return adapterName;
    }

    public final Statement CompactStatement() throws ParseException, ParseException {
        Pair<Identifier, Identifier> nameComponents = null;
        CompactStatement stmt = null;
        this.jj_consume_token(16);
        this.Dataset();
        nameComponents = this.QualifiedName();
        stmt = new CompactStatement((Identifier)nameComponents.first, (Identifier)nameComponents.second);
        return stmt;
    }

    public final Statement ConnectionStatement() throws ParseException, ParseException {
        Object feedNameComponents = null;
        Object datasetNameComponents = null;
        Object configuration = null;
        Statement stmt = null;
        Object policy = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                stmt = this.ConnectStatement();
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                stmt = this.DisconnectStatement();
                break;
            }
            case 93: {
                this.jj_consume_token(93);
                stmt = this.StartStatement();
                break;
            }
            case 94: {
                this.jj_consume_token(94);
                stmt = this.StopStatement();
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final Statement StartStatement() throws ParseException, ParseException {
        Pair<Identifier, Identifier> feedNameComponents = null;
        StartFeedStatement stmt = null;
        this.jj_consume_token(38);
        feedNameComponents = this.QualifiedName();
        stmt = new StartFeedStatement(feedNameComponents);
        return stmt;
    }

    public final Statement StopStatement() throws ParseException, ParseException {
        Pair<Identifier, Identifier> feedNameComponents = null;
        StopFeedStatement stmt = null;
        this.jj_consume_token(38);
        feedNameComponents = this.QualifiedName();
        stmt = new StopFeedStatement(feedNameComponents);
        return stmt;
    }

    public final Statement DisconnectStatement() throws ParseException, ParseException {
        Pair<Identifier, Identifier> feedNameComponents = null;
        Pair<Identifier, Identifier> datasetNameComponents = null;
        Object configuration = null;
        DisconnectFeedStatement stmt = null;
        Object policy = null;
        this.jj_consume_token(38);
        feedNameComponents = this.QualifiedName();
        this.jj_consume_token(42);
        this.Dataset();
        datasetNameComponents = this.QualifiedName();
        stmt = new DisconnectFeedStatement(feedNameComponents, datasetNameComponents);
        return stmt;
    }

    public final Statement ConnectStatement() throws ParseException, ParseException {
        Pair<Identifier, Identifier> feedNameComponents = null;
        Pair<Identifier, Identifier> datasetNameComponents = null;
        Object configuration = null;
        List<FunctionSignature> appliedFunctions = null;
        ConnectFeedStatement stmt = null;
        String policy = null;
        this.jj_consume_token(38);
        feedNameComponents = this.QualifiedName();
        this.jj_consume_token(98);
        this.Dataset();
        datasetNameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                appliedFunctions = this.ApplyFunction();
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 105: {
                policy = this.GetPolicy();
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
        stmt = new ConnectFeedStatement(feedNameComponents, datasetNameComponents, appliedFunctions, policy, this.getVarCounter());
        return stmt;
    }

    public final Map<String, String> Configuration() throws ParseException, ParseException {
        LinkedHashMap<String, String> configuration = new LinkedHashMap<String, String>();
        Pair<String, String> keyValuePair = null;
        this.jj_consume_token(119);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 119: {
                keyValuePair = this.KeyValuePair();
                configuration.put((String)keyValuePair.first, (String)keyValuePair.second);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 125: {
                            break;
                        }
                        default: {
                            this.jj_la1[50] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(125);
                    keyValuePair = this.KeyValuePair();
                    configuration.put((String)keyValuePair.first, (String)keyValuePair.second);
                }
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
            }
        }
        this.jj_consume_token(120);
        return configuration;
    }

    public final Pair<String, String> KeyValuePair() throws ParseException, ParseException {
        this.jj_consume_token(119);
        String key = this.ConstantString();
        this.jj_consume_token(134);
        String value = this.ConstantString();
        this.jj_consume_token(120);
        return new Pair((Object)key, (Object)value);
    }

    public final Map<String, String> Properties() throws ParseException, ParseException {
        HashMap<String, String> properties = new HashMap<String, String>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 119: {
                this.jj_consume_token(119);
                Pair<String, String> property = this.Property();
                properties.put((String)property.first, (String)property.second);
                block6: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 125: {
                            break;
                        }
                        default: {
                            this.jj_la1[52] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(125);
                    property = this.Property();
                    properties.put((String)property.first, (String)property.second);
                }
                this.jj_consume_token(120);
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
            }
        }
        return properties;
    }

    public final Pair<String, String> Property() throws ParseException, ParseException {
        String key = null;
        String value = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 153: 
            case 164: {
                key = this.Identifier();
                break;
            }
            case 154: {
                key = this.StringLiteral();
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(134);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 153: 
            case 154: {
                value = this.ConstantString();
                break;
            }
            case 142: {
                this.jj_consume_token(142);
                try {
                    value = "" + Long.valueOf(this.token.image);
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("inapproriate value: " + this.token.image);
                }
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new Pair((Object)key.toUpperCase(), (Object)value);
    }

    public final TypeExpression IndexedTypeExpr() throws ParseException, ParseException {
        TypeReferenceExpression typeExpr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 153: 
            case 164: {
                typeExpr = this.TypeReference();
                break;
            }
            case 121: {
                typeExpr = this.OrderedListTypeDef();
                break;
            }
            case 140: {
                typeExpr = this.UnorderedListTypeDef();
                break;
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return typeExpr;
    }

    public final TypeExpression TypeExpr() throws ParseException, ParseException {
        RecordTypeDefinition typeExpr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: 
            case 73: 
            case 138: {
                typeExpr = this.RecordTypeDef();
                break;
            }
            case 153: 
            case 164: {
                typeExpr = this.TypeReference();
                break;
            }
            case 121: {
                typeExpr = this.OrderedListTypeDef();
                break;
            }
            case 140: {
                typeExpr = this.UnorderedListTypeDef();
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return typeExpr;
    }

    public final RecordTypeDefinition RecordTypeDef() throws ParseException, ParseException {
        String[] splits;
        RecordTypeDefinition recType = new RecordTypeDefinition();
        RecordTypeDefinition.RecordKind recordKind = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: 
            case 73: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        this.jj_consume_token(13);
                        recordKind = RecordTypeDefinition.RecordKind.CLOSED;
                        break block0;
                    }
                    case 73: {
                        this.jj_consume_token(73);
                        recordKind = RecordTypeDefinition.RecordKind.OPEN;
                        break block0;
                    }
                }
                this.jj_la1[58] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
            }
        }
        this.jj_consume_token(138);
        String hint = SQLPPParser.getHint(this.token);
        if (hint != null && (splits = hint.split(" +"))[0].equals(GEN_FIELDS_HINT)) {
            if (splits.length != 5) {
                throw new ParseException("Expecting: /*+ gen-fields <type> <min> <max> <prefix>*/");
            }
            if (!splits[1].equals("int")) {
                throw new ParseException("The only supported type for gen-fields is int.");
            }
            UndeclaredFieldsDataGen ufdg = new UndeclaredFieldsDataGen(UndeclaredFieldsDataGen.Type.INT, Integer.parseInt(splits[2]), Integer.parseInt(splits[3]), splits[4]);
            recType.setUndeclaredFieldsDataGen(ufdg);
        }
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 153: 
            case 164: {
                this.RecordField(recType);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 125: {
                            break;
                        }
                        default: {
                            this.jj_la1[60] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(125);
                    this.RecordField(recType);
                }
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
            }
        }
        this.jj_consume_token(139);
        if (recordKind == null) {
            recordKind = RecordTypeDefinition.RecordKind.OPEN;
        }
        recType.setRecordKind(recordKind);
        return recType;
    }

    public final void RecordField(RecordTypeDefinition recType) throws ParseException, ParseException {
        TypeExpression type = null;
        boolean nullable = false;
        String fieldName = this.Identifier();
        String hint = SQLPPParser.getHint(this.token);
        IRecordFieldDataGen rfdg = hint != null ? SQLPPParser.parseFieldDataGen(hint) : null;
        this.jj_consume_token(124);
        type = this.TypeExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 127: {
                this.jj_consume_token(127);
                nullable = true;
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
        recType.addField(fieldName, type, Boolean.valueOf(nullable), rfdg);
    }

    public final TypeReferenceExpression TypeReference() throws ParseException, ParseException {
        Pair<Identifier, Identifier> id = null;
        id = this.QualifiedName();
        if (id.first == null && ((Identifier)id.second).getValue().equalsIgnoreCase("int")) {
            ((Identifier)id.second).setValue("int64");
        }
        return new TypeReferenceExpression(id);
    }

    public final OrderedListTypeDefinition OrderedListTypeDef() throws ParseException, ParseException {
        TypeExpression type = null;
        this.jj_consume_token(121);
        type = this.TypeExpr();
        this.jj_consume_token(122);
        return new OrderedListTypeDefinition(type);
    }

    public final UnorderedListTypeDefinition UnorderedListTypeDef() throws ParseException, ParseException {
        TypeExpression type = null;
        this.jj_consume_token(140);
        type = this.TypeExpr();
        this.jj_consume_token(141);
        return new UnorderedListTypeDefinition(type);
    }

    public final FunctionName FunctionName() throws ParseException, ParseException {
        String first = null;
        String second = null;
        String third = null;
        boolean secondAfterDot = false;
        first = this.Identifier();
        FunctionName result = new FunctionName();
        result.hint = SQLPPParser.getHint(this.token);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 126: 
            case 129: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 126: {
                        this.jj_consume_token(126);
                        second = this.Identifier();
                        secondAfterDot = true;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 129: {
                                this.jj_consume_token(129);
                                third = this.Identifier();
                                break block0;
                            }
                        }
                        this.jj_la1[63] = this.jj_gen;
                        break block0;
                    }
                    case 129: {
                        this.jj_consume_token(129);
                        second = this.Identifier();
                        break block0;
                    }
                }
                this.jj_la1[64] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
            }
        }
        if (second == null) {
            result.dataverse = this.defaultDataverse;
            result.library = null;
            result.function = first;
        } else if (third == null) {
            if (secondAfterDot) {
                result.dataverse = first;
                result.library = null;
                result.function = second;
            } else {
                result.dataverse = this.defaultDataverse;
                result.library = first;
                result.function = second;
            }
        } else {
            result.dataverse = first;
            result.library = second;
            result.function = third;
        }
        if (result.function.equalsIgnoreCase("int")) {
            result.function = "int64";
        }
        return result;
    }

    public final Pair<Identifier, Identifier> TypeName() throws ParseException, ParseException {
        Pair<Identifier, Identifier> name = null;
        name = this.QualifiedName();
        if (name.first == null) {
            name.first = new Identifier(this.defaultDataverse);
        }
        return name;
    }

    public final String Identifier() throws ParseException, ParseException {
        String lit = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 164: {
                this.jj_consume_token(164);
                return this.token.image;
            }
            case 153: {
                lit = this.QuotedString();
                return lit;
            }
        }
        this.jj_la1[66] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void Dataset() throws ParseException, ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Pair<Integer, Pair<List<String>, TypeExpression>> OpenField() throws ParseException, ParseException {
        TypeExpression fieldType = null;
        Pair<Integer, List<String>> fieldList = null;
        fieldList = this.NestedField();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 124: {
                this.jj_consume_token(124);
                fieldType = this.IndexedTypeExpr();
                this.jj_consume_token(127);
                break;
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
            }
        }
        return new Pair(fieldList.first, (Object)new Pair(fieldList.second, (Object)fieldType));
    }

    public final Pair<Integer, List<String>> NestedField() throws ParseException, ParseException {
        ArrayList<String> exprList = new ArrayList<String>();
        String lit = null;
        int source = 0;
        lit = this.Identifier();
        boolean meetParens = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 119: {
                this.jj_consume_token(119);
                this.jj_consume_token(120);
                if (!lit.toLowerCase().equals("meta")) {
                    throw new ParseException("The string before () has to be \"meta\".");
                }
                meetParens = true;
                source = 1;
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
            }
        }
        if (!meetParens) {
            exprList.add(lit);
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 126: {
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(126);
            lit = this.Identifier();
            exprList.add(lit);
        }
        return new Pair((Object)source, exprList);
    }

    public final String ConstantString() throws ParseException, ParseException {
        String value = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 153: {
                value = this.QuotedString();
                break;
            }
            case 154: {
                value = this.StringLiteral();
                break;
            }
            default: {
                this.jj_la1[71] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final String QuotedString() throws ParseException, ParseException {
        this.jj_consume_token(153);
        return SQLPPParser.removeQuotesAndEscapes((String)this.token.image);
    }

    public final String StringLiteral() throws ParseException, ParseException {
        this.jj_consume_token(154);
        return SQLPPParser.removeQuotesAndEscapes((String)this.token.image);
    }

    public final Pair<Identifier, Identifier> QualifiedName() throws ParseException, ParseException {
        String first = null;
        String second = null;
        first = this.Identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 126: {
                this.jj_consume_token(126);
                second = this.Identifier();
                break;
            }
            default: {
                this.jj_la1[72] = this.jj_gen;
            }
        }
        Identifier id1 = null;
        Identifier id2 = null;
        if (second == null) {
            id2 = new Identifier(first);
        } else {
            id1 = new Identifier(first);
            id2 = new Identifier(second);
        }
        return new Pair((Object)id1, (Object)id2);
    }

    public final Triple<Identifier, Identifier, Identifier> DoubleQualifiedName() throws ParseException, ParseException {
        String first = null;
        String second = null;
        String third = null;
        first = this.Identifier();
        this.jj_consume_token(126);
        second = this.Identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 126: {
                this.jj_consume_token(126);
                third = this.Identifier();
                break;
            }
            default: {
                this.jj_la1[73] = this.jj_gen;
            }
        }
        Identifier id1 = null;
        Identifier id2 = null;
        Identifier id3 = null;
        if (third == null) {
            id2 = new Identifier(first);
            id3 = new Identifier(second);
        } else {
            id1 = new Identifier(first);
            id2 = new Identifier(second);
            id3 = new Identifier(third);
        }
        return new Triple((Object)id1, (Object)id2, (Object)id3);
    }

    public final FunctionDecl FunctionDeclaration() throws ParseException, ParseException {
        List<Object> paramList = new ArrayList();
        this.createNewScope();
        this.jj_consume_token(22);
        this.jj_consume_token(45);
        String functionName = this.Identifier();
        paramList = this.ParameterList();
        this.jj_consume_token(138);
        Expression funcBody = this.Expression();
        this.jj_consume_token(139);
        FunctionSignature signature = new FunctionSignature(this.defaultDataverse, functionName, paramList.size());
        this.getCurrentScope().addFunctionDescriptor(signature, false);
        FunctionDecl funcDecl = new FunctionDecl(signature, paramList, funcBody);
        this.removeCurrentScope();
        return funcDecl;
    }

    public final Query ExplainStatement() throws ParseException, ParseException {
        this.jj_consume_token(30);
        Query query = this.Query(true);
        return query;
    }

    public final Query Query(boolean explain) throws ParseException, ParseException {
        Expression expr;
        Query query = new Query(explain);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 12: 
            case 34: 
            case 36: 
            case 70: 
            case 92: 
            case 115: 
            case 118: 
            case 119: 
            case 121: 
            case 138: 
            case 140: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 148: 
            case 149: 
            case 153: 
            case 154: 
            case 164: {
                expr = this.Expression();
                break;
            }
            case 42: 
            case 63: 
            case 64: 
            case 90: 
            case 109: {
                expr = this.SelectExpression(false);
                break;
            }
            default: {
                this.jj_la1[74] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        query.setBody(expr);
        return query;
    }

    public final Expression Expression() throws ParseException {
        Expression expr = null;
        Object exprP = null;
        if (this.jj_2_2(2)) {
            expr = this.OperatorExpr();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    expr = this.CaseExpr();
                    break;
                }
                case 3: 
                case 34: 
                case 92: {
                    expr = this.QuantifiedExpression();
                    break;
                }
                default: {
                    this.jj_la1[75] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return exprP == null ? expr : exprP;
    }

    public final Expression OperatorExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.AndExpr();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 74: {
                    break;
                }
                default: {
                    this.jj_la1[76] = this.jj_gen;
                    break block5;
                }
            }
            this.jj_consume_token(74);
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
            }
            try {
                op.addOperator(this.token.image.toLowerCase());
            }
            catch (Exception e) {
                throw new ParseException(e.getMessage());
            }
            operand = this.AndExpr();
            op.addOperand(operand);
        }
        return op == null ? operand : op;
    }

    public final Expression AndExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.NotExpr();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: {
                    break;
                }
                default: {
                    this.jj_la1[77] = this.jj_gen;
                    break block5;
                }
            }
            this.jj_consume_token(2);
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
            }
            try {
                op.addOperator(this.token.image.toLowerCase());
            }
            catch (CompilationException e) {
                throw new ParseException(e.getMessage());
            }
            operand = this.NotExpr();
            op.addOperand(operand);
        }
        return op == null ? operand : op;
    }

    public final Expression NotExpr() throws ParseException, ParseException {
        boolean not = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 70: {
                this.jj_consume_token(70);
                not = true;
                break;
            }
            default: {
                this.jj_la1[78] = this.jj_gen;
            }
        }
        Expression inputExpr = this.RelExpr();
        if (not) {
            FunctionSignature signature = new FunctionSignature(null, "not", 1);
            return new CallExpr(signature, new ArrayList<Expression>(Collections.singletonList(inputExpr)));
        }
        return inputExpr;
    }

    public final Expression RelExpr() throws ParseException, ParseException {
        boolean not = false;
        OperatorExpr op = null;
        Expression operand = null;
        boolean broadcast = false;
        IndexedNLJoinExpressionAnnotation annotation = null;
        operand = this.BetweenExpr();
        if (this.jj_2_3(2)) {
            String operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 130: {
                    this.jj_consume_token(130);
                    break;
                }
                case 131: {
                    this.jj_consume_token(131);
                    break;
                }
                case 132: {
                    this.jj_consume_token(132);
                    break;
                }
                case 133: {
                    this.jj_consume_token(133);
                    break;
                }
                case 134: {
                    this.jj_consume_token(134);
                    break;
                }
                case 135: {
                    this.jj_consume_token(135);
                    break;
                }
                case 136: {
                    this.jj_consume_token(136);
                    break;
                }
                case 137: {
                    this.jj_consume_token(137);
                    break;
                }
                case 51: 
                case 70: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 70: {
                            this.jj_consume_token(70);
                            not = true;
                            break;
                        }
                        default: {
                            this.jj_la1[79] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(51);
                    break;
                }
                default: {
                    this.jj_la1[80] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            String mhint = SQLPPParser.getHint(this.token);
            if (mhint != null) {
                if (mhint.equals(INDEXED_NESTED_LOOP_JOIN_HINT)) {
                    annotation = IndexedNLJoinExpressionAnnotation.INSTANCE;
                } else if (mhint.equals(SKIP_SECONDARY_INDEX_SEARCH_HINT)) {
                    annotation = SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE;
                } else if (mhint.equals(BROADCAST_JOIN_HINT)) {
                    broadcast = true;
                }
            }
            if ((operator = this.token.image.toLowerCase()).equals("<>")) {
                operator = "!=";
            }
            if (not) {
                operator = "not_" + operator;
            }
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand, false);
                op.setCurrentop(true);
            }
            try {
                op.addOperator(operator);
            }
            catch (CompilationException e) {
                throw new ParseException(e.getMessage());
            }
            operand = this.BetweenExpr();
            op.addOperand(operand, broadcast);
        }
        if (annotation != null) {
            op.addHint(annotation);
        }
        return op == null ? operand : op;
    }

    public final Expression BetweenExpr() throws ParseException, ParseException {
        boolean not = false;
        OperatorExpr op = null;
        Expression operand = null;
        IndexedNLJoinExpressionAnnotation annotation = null;
        operand = this.IsExpr();
        if (this.jj_2_4(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 70: {
                    this.jj_consume_token(70);
                    not = true;
                    break;
                }
                default: {
                    this.jj_la1[81] = this.jj_gen;
                }
            }
            this.jj_consume_token(9);
            String mhint = SQLPPParser.getHint(this.token);
            if (mhint != null) {
                if (mhint.equals(INDEXED_NESTED_LOOP_JOIN_HINT)) {
                    annotation = IndexedNLJoinExpressionAnnotation.INSTANCE;
                } else if (mhint.equals(SKIP_SECONDARY_INDEX_SEARCH_HINT)) {
                    annotation = SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE;
                }
            }
            String operator = this.token.image.toLowerCase();
            if (not) {
                operator = "not_" + operator;
            }
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
            }
            try {
                op.addOperator(operator);
            }
            catch (CompilationException e) {
                throw new ParseException(e.getMessage());
            }
            operand = this.IsExpr();
            op.addOperand(operand);
            this.jj_consume_token(2);
            operand = this.IsExpr();
            op.addOperand(operand);
        }
        if (annotation != null) {
            op.addHint(annotation);
        }
        return op == null ? operand : op;
    }

    public final Expression IsExpr() throws ParseException, ParseException {
        Expression expr = null;
        Expression operand = null;
        boolean not = false;
        operand = this.LikeExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                this.jj_consume_token(58);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 70: {
                        this.jj_consume_token(70);
                        not = true;
                        break;
                    }
                    default: {
                        this.jj_la1[82] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 144: {
                        this.jj_consume_token(144);
                        break;
                    }
                    case 143: {
                        this.jj_consume_token(143);
                        break;
                    }
                    case 100: {
                        this.jj_consume_token(100);
                        break;
                    }
                    default: {
                        this.jj_la1[83] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                String functionName = "is-" + this.token.image.toLowerCase();
                FunctionSignature signature = new FunctionSignature(null, functionName, 1);
                expr = new CallExpr(signature, new ArrayList<Expression>(Collections.singletonList(operand)));
                if (!not) break;
                FunctionSignature notSignature = new FunctionSignature(null, "not", 1);
                expr = new CallExpr(notSignature, new ArrayList<Expression>(Collections.singletonList(expr)));
                break;
            }
            default: {
                this.jj_la1[84] = this.jj_gen;
            }
        }
        expr = expr == null ? operand : expr;
        return expr;
    }

    public final Expression LikeExpr() throws ParseException, ParseException {
        boolean not = false;
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.ConcatExpr();
        if (this.jj_2_5(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 70: {
                    this.jj_consume_token(70);
                    not = true;
                    break;
                }
                default: {
                    this.jj_la1[85] = this.jj_gen;
                }
            }
            this.jj_consume_token(65);
            op = new OperatorExpr();
            op.addOperand(operand);
            op.setCurrentop(true);
            String operator = this.token.image.toLowerCase();
            if (not) {
                operator = "not_" + operator;
            }
            try {
                op.addOperator(operator);
            }
            catch (CompilationException e) {
                throw new ParseException(e.getMessage());
            }
            operand = this.ConcatExpr();
            op.addOperand(operand);
        }
        return op == null ? operand : op;
    }

    public final Expression ConcatExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.AddExpr();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 112: {
                    break;
                }
                default: {
                    this.jj_la1[86] = this.jj_gen;
                    break block5;
                }
            }
            this.jj_consume_token(112);
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
            }
            try {
                op.addOperator(this.token.image);
            }
            catch (Exception e) {
                throw new ParseException(e.getMessage());
            }
            operand = this.AddExpr();
            op.addOperand(operand);
        }
        return op == null ? operand : op;
    }

    public final Expression AddExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.MultExpr();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 115: 
                case 118: {
                    break;
                }
                default: {
                    this.jj_la1[87] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 118: {
                    this.jj_consume_token(118);
                    break;
                }
                case 115: {
                    this.jj_consume_token(115);
                    break;
                }
                default: {
                    this.jj_la1[88] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
            }
            try {
                op.addOperator(this.token.image);
            }
            catch (Exception e) {
                throw new ParseException(e.getMessage());
            }
            operand = this.MultExpr();
            op.addOperand(operand);
        }
        return op == null ? operand : op;
    }

    public final Expression MultExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.ExponentExpr();
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 113: 
                case 114: 
                case 116: 
                case 117: {
                    break;
                }
                default: {
                    this.jj_la1[89] = this.jj_gen;
                    break block11;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 117: {
                    this.jj_consume_token(117);
                    break;
                }
                case 113: {
                    this.jj_consume_token(113);
                    break;
                }
                case 116: {
                    this.jj_consume_token(116);
                    break;
                }
                case 114: {
                    this.jj_consume_token(114);
                    break;
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
            }
            try {
                op.addOperator(this.token.image);
            }
            catch (Exception e) {
                throw new ParseException(e.getMessage());
            }
            operand = this.ExponentExpr();
            op.addOperand(operand);
        }
        return op == null ? operand : op;
    }

    public final Expression ExponentExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.UnaryExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 111: {
                this.jj_consume_token(111);
                if (op == null) {
                    op = new OperatorExpr();
                    op.addOperand(operand);
                    op.setCurrentop(true);
                }
                try {
                    op.addOperator(this.token.image);
                }
                catch (Exception e) {
                    throw new ParseException(e.getMessage());
                }
                operand = this.UnaryExpr();
                op.addOperand(operand);
                break;
            }
            default: {
                this.jj_la1[91] = this.jj_gen;
            }
        }
        return op == null ? operand : op;
    }

    public final Expression UnaryExpr() throws ParseException, ParseException {
        boolean not = false;
        UnaryExpr uexpr = null;
        Expression expr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: 
            case 70: 
            case 115: 
            case 118: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 118: {
                        this.jj_consume_token(118);
                        break;
                    }
                    case 115: {
                        this.jj_consume_token(115);
                        break;
                    }
                    case 36: 
                    case 70: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 70: {
                                this.jj_consume_token(70);
                                not = true;
                                break;
                            }
                            default: {
                                this.jj_la1[92] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(36);
                        break;
                    }
                    default: {
                        this.jj_la1[93] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                String exprType = this.token.image.toLowerCase();
                if (not) {
                    exprType = "not_" + exprType;
                }
                uexpr = new UnaryExpr();
                try {
                    uexpr.setExprType(exprType);
                    break;
                }
                catch (CompilationException e) {
                    throw new ParseException(e.getMessage());
                }
            }
            default: {
                this.jj_la1[94] = this.jj_gen;
            }
        }
        expr = this.ValueExpr();
        if (uexpr == null) {
            return expr;
        }
        uexpr.setExpr(expr);
        return uexpr;
    }

    public final Expression ValueExpr() throws ParseException, ParseException {
        FieldAccessor fa;
        Expression expr;
        block8: {
            expr = null;
            Identifier ident = null;
            fa = null;
            Expression indexExpr = null;
            expr = this.PrimaryExpr();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 121: 
                    case 126: {
                        break;
                    }
                    default: {
                        this.jj_la1[95] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 126: {
                        ident = this.Field();
                        fa = fa == null ? new FieldAccessor(expr, ident) : new FieldAccessor(fa, ident);
                        continue block7;
                    }
                    case 121: {
                        indexExpr = this.Index();
                        fa = fa == null ? new IndexAccessor(expr, indexExpr) : new IndexAccessor(fa, indexExpr);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[96] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return fa == null ? expr : fa;
    }

    public final Identifier Field() throws ParseException, ParseException {
        String ident = null;
        this.jj_consume_token(126);
        ident = this.Identifier();
        return new Identifier(ident);
    }

    public final Expression Index() throws ParseException, ParseException {
        Expression expr = null;
        this.jj_consume_token(121);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 12: 
            case 34: 
            case 36: 
            case 70: 
            case 92: 
            case 115: 
            case 118: 
            case 119: 
            case 121: 
            case 138: 
            case 140: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 148: 
            case 149: 
            case 153: 
            case 154: 
            case 164: {
                Literal lit;
                expr = this.Expression();
                if (expr.getKind() != Expression.Kind.LITERAL_EXPRESSION || (lit = ((LiteralExpr)expr).getValue()).getLiteralType() == Literal.Type.INTEGER || lit.getLiteralType() == Literal.Type.LONG) break;
                throw new ParseException("Index should be an INTEGER");
            }
            case 127: {
                this.jj_consume_token(127);
                break;
            }
            default: {
                this.jj_la1[97] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(122);
        return expr;
    }

    public final Expression PrimaryExpr() throws ParseException, ParseException {
        Expression expr = null;
        if (this.jj_2_6(4)) {
            expr = this.FunctionCallExpr();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 148: 
                case 149: 
                case 154: {
                    expr = this.Literal();
                    break;
                }
                case 153: 
                case 164: {
                    expr = this.VariableRef();
                    break;
                }
                case 121: 
                case 140: {
                    expr = this.ListConstructor();
                    break;
                }
                case 138: {
                    expr = this.RecordConstructor();
                    break;
                }
                case 119: {
                    expr = this.ParenthesizedExpression();
                    break;
                }
                default: {
                    this.jj_la1[98] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return expr;
    }

    public final Expression Literal() throws ParseException, ParseException {
        LiteralExpr lit = new LiteralExpr();
        String str = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 154: {
                str = this.StringLiteral();
                lit.setValue((Literal)new StringLiteral(str));
                break;
            }
            case 142: {
                this.jj_consume_token(142);
                try {
                    lit.setValue((Literal)new LongIntegerLiteral(Long.valueOf(this.token.image)));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Could not parse numeric literal \"" + this.token.image + '\"');
                }
            }
            case 149: {
                this.jj_consume_token(149);
                try {
                    lit.setValue((Literal)new FloatLiteral(Float.valueOf(this.token.image)));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Could not parse numeric literal \"" + this.token.image + '\"');
                }
            }
            case 148: {
                this.jj_consume_token(148);
                try {
                    lit.setValue((Literal)new DoubleLiteral(Double.valueOf(this.token.image)));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Could not parse numeric literal \"" + this.token.image + '\"');
                }
            }
            case 143: {
                this.jj_consume_token(143);
                lit.setValue((Literal)MissingLiteral.INSTANCE);
                break;
            }
            case 144: {
                this.jj_consume_token(144);
                lit.setValue((Literal)NullLiteral.INSTANCE);
                break;
            }
            case 145: {
                this.jj_consume_token(145);
                lit.setValue((Literal)TrueLiteral.INSTANCE);
                break;
            }
            case 146: {
                this.jj_consume_token(146);
                lit.setValue((Literal)FalseLiteral.INSTANCE);
                break;
            }
            default: {
                this.jj_la1[99] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return lit;
    }

    public final VariableExpr VariableRef() throws ParseException, ParseException {
        VariableExpr varExp = new VariableExpr();
        VarIdentifier var = new VarIdentifier();
        String id = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 164: {
                this.jj_consume_token(164);
                id = this.token.image;
                break;
            }
            case 153: {
                id = this.QuotedString();
                break;
            }
            default: {
                this.jj_la1[100] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        id = SqlppVariableUtil.toInternalVariableName(id);
        Identifier ident = this.lookupSymbol(id);
        if (this.isInForbiddenScopes(id)) {
            throw new ParseException("Inside limit clauses, it is disallowed to reference a variable having the same name as any variable bound in the same scope as the limit clause.");
        }
        if (ident != null) {
            varExp.setVar((VarIdentifier)ident);
        } else {
            varExp.setVar(var);
            varExp.setIsNewVar(false);
            var.setValue(id);
        }
        return varExp;
    }

    public final VariableExpr Variable() throws ParseException, ParseException {
        VariableExpr varExp = new VariableExpr();
        VarIdentifier var = new VarIdentifier();
        String id = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 164: {
                this.jj_consume_token(164);
                id = this.token.image;
                break;
            }
            case 153: {
                id = this.QuotedString();
                break;
            }
            default: {
                this.jj_la1[101] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        id = SqlppVariableUtil.toInternalVariableName(id);
        Identifier ident = this.lookupSymbol(id);
        if (ident != null) {
            varExp.setIsNewVar(false);
        }
        varExp.setVar(var);
        var.setValue(id);
        return varExp;
    }

    public final Expression ListConstructor() throws ParseException, ParseException {
        ListConstructor expr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 121: {
                expr = this.OrderedListConstructor();
                break;
            }
            case 140: {
                expr = this.UnorderedListConstructor();
                break;
            }
            default: {
                this.jj_la1[102] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expr;
    }

    public final ListConstructor OrderedListConstructor() throws ParseException, ParseException {
        ListConstructor expr = new ListConstructor();
        List<Expression> exprList = null;
        expr.setType(ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR);
        this.jj_consume_token(121);
        exprList = this.ExpressionList();
        this.jj_consume_token(122);
        expr.setExprList(exprList);
        return expr;
    }

    public final ListConstructor UnorderedListConstructor() throws ParseException, ParseException {
        ListConstructor expr = new ListConstructor();
        List<Expression> exprList = null;
        expr.setType(ListConstructor.Type.UNORDERED_LIST_CONSTRUCTOR);
        this.jj_consume_token(140);
        exprList = this.ExpressionList();
        this.jj_consume_token(141);
        expr.setExprList(exprList);
        return expr;
    }

    public final List<Expression> ExpressionList() throws ParseException, ParseException {
        Expression expr = null;
        List<Expression> list = null;
        ArrayList<Expression> exprList = new ArrayList<Expression>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 12: 
            case 34: 
            case 36: 
            case 70: 
            case 92: 
            case 115: 
            case 118: 
            case 119: 
            case 121: 
            case 138: 
            case 140: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 148: 
            case 149: 
            case 153: 
            case 154: 
            case 164: {
                expr = this.Expression();
                exprList.add(expr);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 125: {
                        this.jj_consume_token(125);
                        list = this.ExpressionList();
                        exprList.addAll(list);
                        break block0;
                    }
                }
                this.jj_la1[103] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[104] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 125: {
                this.Comma();
                break;
            }
            default: {
                this.jj_la1[105] = this.jj_gen;
            }
        }
        return exprList;
    }

    public final void Comma() throws ParseException {
        this.jj_consume_token(125);
    }

    public final RecordConstructor RecordConstructor() throws ParseException, ParseException {
        RecordConstructor expr = new RecordConstructor();
        FieldBinding tmp = null;
        ArrayList<FieldBinding> fbList = new ArrayList<FieldBinding>();
        this.jj_consume_token(138);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 12: 
            case 34: 
            case 36: 
            case 70: 
            case 92: 
            case 115: 
            case 118: 
            case 119: 
            case 121: 
            case 138: 
            case 140: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 148: 
            case 149: 
            case 153: 
            case 154: 
            case 164: {
                tmp = this.FieldBinding();
                fbList.add(tmp);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 125: {
                            break;
                        }
                        default: {
                            this.jj_la1[106] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(125);
                    tmp = this.FieldBinding();
                    fbList.add(tmp);
                }
            }
            default: {
                this.jj_la1[107] = this.jj_gen;
            }
        }
        this.jj_consume_token(139);
        expr.setFbList(fbList);
        return expr;
    }

    public final FieldBinding FieldBinding() throws ParseException, ParseException {
        FieldBinding fb = new FieldBinding();
        Expression left = this.Expression();
        this.jj_consume_token(124);
        Expression right = this.Expression();
        fb.setLeftExpr(left);
        fb.setRightExpr(right);
        return fb;
    }

    public final Expression FunctionCallExpr() throws ParseException, ParseException {
        ArrayList<Object> argList = new ArrayList<Object>();
        Expression tmp = null;
        int arity = 0;
        FunctionName funcName = null;
        String hint = null;
        boolean star = false;
        funcName = this.FunctionName();
        hint = funcName.hint;
        this.jj_consume_token(119);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 12: 
            case 34: 
            case 36: 
            case 70: 
            case 92: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 121: 
            case 138: 
            case 140: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 148: 
            case 149: 
            case 153: 
            case 154: 
            case 164: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 3: 
                    case 12: 
                    case 34: 
                    case 36: 
                    case 70: 
                    case 92: 
                    case 115: 
                    case 118: 
                    case 119: 
                    case 121: 
                    case 138: 
                    case 140: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 148: 
                    case 149: 
                    case 153: 
                    case 154: 
                    case 164: {
                        tmp = this.Expression();
                        break;
                    }
                    case 117: {
                        this.jj_consume_token(117);
                        star = true;
                        break;
                    }
                    default: {
                        this.jj_la1[108] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (star) {
                    if (!funcName.function.toLowerCase().equals("count")) {
                        throw new ParseException("The parameter * can only be used in COUNT().");
                    }
                    argList.add(new LiteralExpr((Literal)new LongIntegerLiteral(Long.valueOf(1L))));
                } else {
                    argList.add(tmp);
                }
                ++arity;
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 125: {
                            break;
                        }
                        default: {
                            this.jj_la1[109] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(125);
                    tmp = this.Expression();
                    argList.add(tmp);
                    ++arity;
                }
            }
            default: {
                this.jj_la1[110] = this.jj_gen;
            }
        }
        this.jj_consume_token(120);
        String fqFunctionName = funcName.library == null ? funcName.function : funcName.library + "#" + funcName.function;
        FunctionSignature signature = this.lookupFunctionSignature(funcName.dataverse, fqFunctionName, arity);
        if (signature == null) {
            signature = new FunctionSignature(funcName.dataverse, fqFunctionName, arity);
        }
        CallExpr callExpr = FunctionMapUtil.normalizedListInputFunctions(new CallExpr(signature, argList));
        if (hint != null) {
            if (hint.startsWith(INDEXED_NESTED_LOOP_JOIN_HINT)) {
                callExpr.addHint((IExpressionAnnotation)IndexedNLJoinExpressionAnnotation.INSTANCE);
            } else if (hint.startsWith(SKIP_SECONDARY_INDEX_SEARCH_HINT)) {
                callExpr.addHint((IExpressionAnnotation)SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE);
            }
        }
        return callExpr;
    }

    public final Expression ParenthesizedExpression() throws ParseException, ParseException {
        Expression expr;
        if (this.jj_2_7(2)) {
            this.jj_consume_token(119);
            expr = this.Expression();
            this.jj_consume_token(120);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 119: {
                    expr = this.Subquery();
                    break;
                }
                default: {
                    this.jj_la1[111] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return expr;
    }

    public final Expression CaseExpr() throws ParseException, ParseException {
        LiteralExpr conditionExpr = new LiteralExpr((Literal)TrueLiteral.INSTANCE);
        ArrayList<Expression> whenExprs = new ArrayList<Expression>();
        ArrayList<Expression> thenExprs = new ArrayList<Expression>();
        Expression elseExpr = null;
        Expression whenExpr = null;
        Expression thenExpr = null;
        this.jj_consume_token(12);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 12: 
            case 34: 
            case 36: 
            case 70: 
            case 92: 
            case 115: 
            case 118: 
            case 119: 
            case 121: 
            case 138: 
            case 140: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 148: 
            case 149: 
            case 153: 
            case 154: 
            case 164: {
                conditionExpr = this.Expression();
                break;
            }
            default: {
                this.jj_la1[112] = this.jj_gen;
            }
        }
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 107: {
                    break;
                }
                default: {
                    this.jj_la1[113] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(107);
            whenExpr = this.Expression();
            whenExprs.add(whenExpr);
            this.jj_consume_token(96);
            thenExpr = this.Expression();
            thenExprs.add(thenExpr);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                elseExpr = this.Expression();
                break;
            }
            default: {
                this.jj_la1[114] = this.jj_gen;
            }
        }
        this.jj_consume_token(33);
        return new CaseExpression((Expression)conditionExpr, whenExprs, thenExprs, elseExpr);
    }

    public final SelectExpression SelectExpression(boolean subquery) throws ParseException, ParseException {
        ArrayList<LetClause> letClauses = new ArrayList();
        OrderbyClause orderbyClause = null;
        LimitClause limitClause = null;
        this.createNewScope();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: 
            case 64: 
            case 109: {
                letClauses = this.LetClause();
                break;
            }
            default: {
                this.jj_la1[115] = this.jj_gen;
            }
        }
        SelectSetOperation selectSetOperation = this.SelectSetOperation();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 75: {
                orderbyClause = this.OrderbyClause();
                break;
            }
            default: {
                this.jj_la1[116] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 66: {
                limitClause = this.LimitClause();
                break;
            }
            default: {
                this.jj_la1[117] = this.jj_gen;
            }
        }
        return new SelectExpression(letClauses, selectSetOperation, orderbyClause, limitClause, subquery);
    }

    public final SelectSetOperation SelectSetOperation() throws ParseException, ParseException {
        ArrayList<SetOperationRight> setOperationRights = new ArrayList<SetOperationRight>();
        SelectBlock selectBlockLeft = null;
        SelectExpression subqueryLeft = null;
        Object expr = null;
        selectBlockLeft = this.SelectBlock();
        SetOperationInput setOperationInputLeft = new SetOperationInput(selectBlockLeft, subqueryLeft);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: 
                case 57: 
                case 99: {
                    break;
                }
                default: {
                    this.jj_la1[118] = this.jj_gen;
                    break block15;
                }
            }
            SetOpType opType = SetOpType.UNION;
            boolean setSemantics = true;
            SelectBlock selectBlockRight = null;
            SelectExpression subqueryRight = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 99: {
                    this.jj_consume_token(99);
                    opType = SetOpType.UNION;
                    break;
                }
                case 57: {
                    this.jj_consume_token(57);
                    opType = SetOpType.INTERSECT;
                    break;
                }
                case 35: {
                    this.jj_consume_token(35);
                    opType = SetOpType.EXCEPT;
                    break;
                }
                default: {
                    this.jj_la1[119] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    this.jj_consume_token(1);
                    setSemantics = false;
                    break;
                }
                default: {
                    this.jj_la1[120] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: 
                case 90: {
                    selectBlockRight = this.SelectBlock();
                    break;
                }
                case 119: {
                    subqueryRight = this.Subquery();
                    break;
                }
                default: {
                    this.jj_la1[121] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            setOperationRights.add(new SetOperationRight(opType, setSemantics, new SetOperationInput(selectBlockRight, subqueryRight)));
        }
        return new SelectSetOperation(setOperationInputLeft, setOperationRights);
    }

    public final SelectExpression Subquery() throws ParseException, ParseException {
        SelectExpression selectExpr = null;
        this.jj_consume_token(119);
        selectExpr = this.SelectExpression(true);
        this.jj_consume_token(120);
        return selectExpr;
    }

    public final SelectBlock SelectBlock() throws ParseException, ParseException {
        SelectClause selectClause = null;
        FromClause fromClause = null;
        List<LetClause> fromLetClauses = null;
        WhereClause whereClause = null;
        GroupbyClause groupbyClause = null;
        List<LetClause> gbyLetClauses = null;
        HavingClause havingClause = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 90: {
                selectClause = this.SelectClause();
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 42: {
                        fromClause = this.FromClause();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 63: 
                            case 64: 
                            case 109: {
                                fromLetClauses = this.LetClause();
                                break block4;
                            }
                        }
                        this.jj_la1[122] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[123] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 108: {
                        whereClause = this.WhereClause();
                        break;
                    }
                    default: {
                        this.jj_la1[124] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 46: {
                        groupbyClause = this.GroupbyClause();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 63: 
                            case 64: 
                            case 109: {
                                gbyLetClauses = this.LetClause();
                                break;
                            }
                            default: {
                                this.jj_la1[125] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 47: {
                                havingClause = this.HavingClause();
                                break block0;
                            }
                        }
                        this.jj_la1[126] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[127] = this.jj_gen;
                break;
            }
            case 42: {
                fromClause = this.FromClause();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 63: 
                    case 64: 
                    case 109: {
                        fromLetClauses = this.LetClause();
                        break;
                    }
                    default: {
                        this.jj_la1[128] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 108: {
                        whereClause = this.WhereClause();
                        break;
                    }
                    default: {
                        this.jj_la1[129] = this.jj_gen;
                    }
                }
                block28 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 46: {
                        groupbyClause = this.GroupbyClause();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 63: 
                            case 64: 
                            case 109: {
                                gbyLetClauses = this.LetClause();
                                break;
                            }
                            default: {
                                this.jj_la1[130] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 47: {
                                havingClause = this.HavingClause();
                                break block28;
                            }
                        }
                        this.jj_la1[131] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[132] = this.jj_gen;
                    }
                }
                selectClause = this.SelectClause();
                break;
            }
            default: {
                this.jj_la1[133] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SelectBlock(selectClause, fromClause, fromLetClauses, whereClause, groupbyClause, gbyLetClauses, havingClause);
    }

    public final SelectClause SelectClause() throws ParseException, ParseException {
        SelectRegular selectRegular = null;
        SelectElement selectElement = null;
        boolean distinct = false;
        this.jj_consume_token(90);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 27: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        break block0;
                    }
                    case 27: {
                        this.jj_consume_token(27);
                        distinct = true;
                        break block0;
                    }
                }
                this.jj_la1[134] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[135] = this.jj_gen;
            }
        }
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 12: 
            case 29: 
            case 34: 
            case 36: 
            case 70: 
            case 82: 
            case 92: 
            case 106: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 121: 
            case 138: 
            case 140: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 148: 
            case 149: 
            case 153: 
            case 154: 
            case 164: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 3: 
                    case 12: 
                    case 34: 
                    case 36: 
                    case 70: 
                    case 92: 
                    case 115: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 121: 
                    case 138: 
                    case 140: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 148: 
                    case 149: 
                    case 153: 
                    case 154: 
                    case 164: {
                        selectRegular = this.SelectRegular();
                        break block7;
                    }
                    case 29: 
                    case 82: 
                    case 106: {
                        selectElement = this.SelectElement();
                        break block7;
                    }
                }
                this.jj_la1[136] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[137] = this.jj_gen;
            }
        }
        if (selectRegular == null && selectElement == null) {
            Projection projection = new Projection(null, null, true, false);
            ArrayList<Projection> projections = new ArrayList<Projection>();
            projections.add(projection);
            selectRegular = new SelectRegular(projections);
        }
        return new SelectClause(selectElement, selectRegular, distinct);
    }

    public final SelectRegular SelectRegular() throws ParseException, ParseException {
        ArrayList<Projection> projections = new ArrayList<Projection>();
        Projection projection = null;
        projection = this.Projection();
        projections.add(projection);
        while (this.jj_2_8(2)) {
            this.jj_consume_token(125);
            projection = this.Projection();
            projections.add(projection);
        }
        return new SelectRegular(projections);
    }

    public final SelectElement SelectElement() throws ParseException, ParseException {
        Expression expr = null;
        Object name = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 82: {
                this.jj_consume_token(82);
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                break;
            }
            default: {
                this.jj_la1[138] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        expr = this.Expression();
        return new SelectElement(expr);
    }

    public final Projection Projection() throws ParseException, ParseException {
        String generatedColumnIdentifier;
        Expression expr = null;
        Object identifier = null;
        String name = null;
        boolean star = false;
        boolean exprStar = false;
        if (this.jj_2_9(2)) {
            expr = this.Expression();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 153: 
                case 164: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            this.jj_consume_token(5);
                            break;
                        }
                        default: {
                            this.jj_la1[139] = this.jj_gen;
                        }
                    }
                    name = this.Identifier();
                    break;
                }
                default: {
                    this.jj_la1[140] = this.jj_gen;
                    break;
                }
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: 
                case 12: 
                case 34: 
                case 36: 
                case 70: 
                case 92: 
                case 115: 
                case 118: 
                case 119: 
                case 121: 
                case 138: 
                case 140: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 148: 
                case 149: 
                case 153: 
                case 154: 
                case 164: {
                    expr = this.Expression();
                    this.jj_consume_token(126);
                    this.jj_consume_token(117);
                    exprStar = true;
                    break;
                }
                case 117: {
                    this.jj_consume_token(117);
                    star = true;
                    break;
                }
                default: {
                    this.jj_la1[141] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (!star && name == null && (generatedColumnIdentifier = ExpressionToVariableUtil.getGeneratedIdentifier(expr, false)) != null) {
            name = SqlppVariableUtil.toUserDefinedName(generatedColumnIdentifier);
        }
        return new Projection(expr, name, star, exprStar);
    }

    public final FromClause FromClause() throws ParseException, ParseException {
        ArrayList<FromTerm> fromTerms = new ArrayList<FromTerm>();
        this.extendCurrentScope();
        FromTerm fromTerm = null;
        this.jj_consume_token(42);
        fromTerm = this.FromTerm();
        fromTerms.add(fromTerm);
        while (this.jj_2_10(2)) {
            this.jj_consume_token(125);
            fromTerm = this.FromTerm();
            fromTerms.add(fromTerm);
        }
        return new FromClause(fromTerms);
    }

    public final FromTerm FromTerm() throws ParseException, ParseException {
        Expression leftExpr = null;
        VariableExpr leftVar = null;
        VariableExpr posVar = null;
        ArrayList<AbstractBinaryCorrelateClause> correlateClauses = new ArrayList<AbstractBinaryCorrelateClause>();
        leftExpr = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 153: 
            case 164: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[142] = this.jj_gen;
                    }
                }
                leftVar = this.Variable();
                break;
            }
            default: {
                this.jj_la1[143] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                posVar = this.Variable();
                break;
            }
            default: {
                this.jj_la1[144] = this.jj_gen;
            }
        }
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: 
                case 40: 
                case 54: 
                case 59: 
                case 62: 
                case 101: {
                    break;
                }
                default: {
                    this.jj_la1[145] = this.jj_gen;
                    break block19;
                }
            }
            JoinType joinType = JoinType.INNER;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 54: 
                case 62: {
                    joinType = this.JoinType();
                    break;
                }
                default: {
                    this.jj_la1[146] = this.jj_gen;
                }
            }
            AbstractBinaryCorrelateClause correlateClause = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 59: {
                    correlateClause = this.JoinClause(joinType);
                    break;
                }
                case 18: 
                case 40: 
                case 101: {
                    correlateClause = this.UnnestClause(joinType);
                    break;
                }
                default: {
                    this.jj_la1[147] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            correlateClauses.add(correlateClause);
        }
        if (leftVar == null) {
            leftVar = ExpressionToVariableUtil.getGeneratedVariable(leftExpr, true);
        }
        return new FromTerm(leftExpr, leftVar, posVar, correlateClauses);
    }

    public final JoinClause JoinClause(JoinType joinType) throws ParseException, ParseException {
        Expression rightExpr = null;
        VariableExpr rightVar = null;
        VariableExpr posVar = null;
        Expression conditionExpr = null;
        this.jj_consume_token(59);
        rightExpr = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 153: 
            case 164: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[148] = this.jj_gen;
                    }
                }
                rightVar = this.Variable();
                break;
            }
            default: {
                this.jj_la1[149] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                posVar = this.Variable();
                break;
            }
            default: {
                this.jj_la1[150] = this.jj_gen;
            }
        }
        this.jj_consume_token(72);
        conditionExpr = this.Expression();
        if (rightVar == null) {
            rightVar = ExpressionToVariableUtil.getGeneratedVariable(rightExpr, true);
        }
        return new JoinClause(joinType, rightExpr, rightVar, posVar, conditionExpr);
    }

    public final UnnestClause UnnestClause(JoinType joinType) throws ParseException, ParseException {
        VariableExpr posVar = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 101: {
                this.jj_consume_token(101);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            default: {
                this.jj_la1[151] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Expression rightExpr = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                break;
            }
            default: {
                this.jj_la1[152] = this.jj_gen;
            }
        }
        VariableExpr rightVar = this.Variable();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                posVar = this.Variable();
                break;
            }
            default: {
                this.jj_la1[153] = this.jj_gen;
            }
        }
        if (rightVar == null) {
            rightVar = ExpressionToVariableUtil.getGeneratedVariable(rightExpr, true);
        }
        return new UnnestClause(joinType, rightExpr, rightVar, posVar);
    }

    public final JoinType JoinType() throws ParseException, ParseException {
        JoinType joinType = JoinType.INNER;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                this.jj_consume_token(54);
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 76: {
                        this.jj_consume_token(76);
                        break;
                    }
                    default: {
                        this.jj_la1[154] = this.jj_gen;
                    }
                }
                joinType = JoinType.LEFTOUTER;
                break;
            }
            default: {
                this.jj_la1[155] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return joinType;
    }

    public final List<LetClause> LetClause() throws ParseException, ParseException {
        ArrayList<LetClause> letList = new ArrayList<LetClause>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: 
            case 64: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 64: {
                        this.jj_consume_token(64);
                        break;
                    }
                    case 63: {
                        this.jj_consume_token(63);
                        break;
                    }
                    default: {
                        this.jj_la1[156] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                LetClause letClause = this.LetElement();
                letList.add(letClause);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 125: {
                            break;
                        }
                        default: {
                            this.jj_la1[157] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(125);
                    letClause = this.LetElement();
                    letList.add(letClause);
                }
            }
            case 109: {
                this.jj_consume_token(109);
                LetClause letClause = this.WithElement();
                letList.add(letClause);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 125: {
                            break;
                        }
                        default: {
                            this.jj_la1[158] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(125);
                    letClause = this.WithElement();
                    letList.add(letClause);
                }
            }
            default: {
                this.jj_la1[159] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return letList;
    }

    public final WhereClause WhereClause() throws ParseException, ParseException {
        WhereClause wc = new WhereClause();
        this.jj_consume_token(108);
        Expression whereExpr = this.Expression();
        wc.setWhereExpr(whereExpr);
        return wc;
    }

    public final OrderbyClause OrderbyClause() throws ParseException, ParseException {
        OrderbyClause oc = new OrderbyClause();
        ArrayList<Expression> orderbyList = new ArrayList<Expression>();
        ArrayList<OrderbyClause.OrderModifier> modifierList = new ArrayList<OrderbyClause.OrderModifier>();
        boolean numOfOrderby = false;
        this.jj_consume_token(75);
        String hint = SQLPPParser.getHint(this.token);
        if (hint != null && hint.startsWith(INMEMORY_HINT)) {
            String[] splits = hint.split(" +");
            int numFrames = Integer.parseInt(splits[1]);
            int numTuples = Integer.parseInt(splits[2]);
            oc.setNumFrames(numFrames);
            oc.setNumTuples(numTuples);
        }
        this.jj_consume_token(11);
        Expression orderbyExpr = this.Expression();
        orderbyList.add(orderbyExpr);
        OrderbyClause.OrderModifier modif = OrderbyClause.OrderModifier.ASC;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 25: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        this.jj_consume_token(6);
                        modif = OrderbyClause.OrderModifier.ASC;
                        break block0;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        modif = OrderbyClause.OrderModifier.DESC;
                        break block0;
                    }
                }
                this.jj_la1[160] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[161] = this.jj_gen;
            }
        }
        modifierList.add(modif);
        while (this.jj_2_11(2)) {
            this.jj_consume_token(125);
            orderbyExpr = this.Expression();
            orderbyList.add(orderbyExpr);
            modif = OrderbyClause.OrderModifier.ASC;
            block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 25: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 6: {
                            this.jj_consume_token(6);
                            modif = OrderbyClause.OrderModifier.ASC;
                            break block7;
                        }
                        case 25: {
                            this.jj_consume_token(25);
                            modif = OrderbyClause.OrderModifier.DESC;
                            break block7;
                        }
                    }
                    this.jj_la1[162] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[163] = this.jj_gen;
                }
            }
            modifierList.add(modif);
        }
        oc.setModifierList(modifierList);
        oc.setOrderbyList(orderbyList);
        return oc;
    }

    public final GroupbyClause GroupbyClause() throws ParseException, ParseException {
        GroupbyClause gbc = new GroupbyClause();
        ArrayList<GbyVariableExpressionPair> vePairList = new ArrayList<GbyVariableExpressionPair>();
        VariableExpr var = null;
        Expression expr = null;
        Object decorVar = null;
        Object decorExpr = null;
        VariableExpr groupVar = null;
        ArrayList<Pair> groupFieldList = new ArrayList<Pair>();
        Scope newScope = this.extendCurrentScopeNoPush(true);
        this.jj_consume_token(46);
        String hint = SQLPPParser.getHint(this.token);
        if (hint != null && hint.equals(HASH_GROUP_BY_HINT)) {
            gbc.setHashGroupByHint(true);
        }
        this.jj_consume_token(11);
        expr = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 153: 
            case 164: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[164] = this.jj_gen;
                    }
                }
                var = this.Variable();
                break;
            }
            default: {
                this.jj_la1[165] = this.jj_gen;
            }
        }
        if (var == null) {
            var = ExpressionToVariableUtil.getGeneratedVariable(expr, false);
        }
        GbyVariableExpressionPair pair1 = new GbyVariableExpressionPair(var, expr);
        vePairList.add(pair1);
        block24: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[166] = this.jj_gen;
                    break block24;
                }
            }
            this.jj_consume_token(125);
            var = null;
            expr = this.Expression();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 153: 
                case 164: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            this.jj_consume_token(5);
                            break;
                        }
                        default: {
                            this.jj_la1[167] = this.jj_gen;
                        }
                    }
                    var = this.Variable();
                    break;
                }
                default: {
                    this.jj_la1[168] = this.jj_gen;
                }
            }
            if (var == null) {
                var = ExpressionToVariableUtil.getGeneratedVariable(expr, false);
            }
            GbyVariableExpressionPair pair2 = new GbyVariableExpressionPair(var, expr);
            vePairList.add(pair2);
        }
        block15 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                this.jj_consume_token(46);
                this.jj_consume_token(5);
                groupVar = this.Variable();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 119: {
                        VariableExpr fieldVarExpr = null;
                        String fieldIdentifierStr = null;
                        this.jj_consume_token(119);
                        fieldVarExpr = this.VariableRef();
                        this.jj_consume_token(5);
                        fieldIdentifierStr = this.Identifier();
                        groupFieldList.add(new Pair((Object)fieldVarExpr, (Object)new Identifier(fieldIdentifierStr)));
                        block25: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 125: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[169] = this.jj_gen;
                                    break block25;
                                }
                            }
                            this.jj_consume_token(125);
                            fieldVarExpr = this.VariableRef();
                            this.jj_consume_token(5);
                            fieldIdentifierStr = this.Identifier();
                            groupFieldList.add(new Pair((Object)fieldVarExpr, (Object)new Identifier(fieldIdentifierStr)));
                        }
                        this.jj_consume_token(120);
                        break block15;
                    }
                }
                this.jj_la1[170] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[171] = this.jj_gen;
            }
        }
        gbc.setGbyPairList(vePairList);
        gbc.setDecorPairList(new ArrayList());
        gbc.setWithVarMap(new HashMap());
        gbc.setGroupVar(groupVar);
        gbc.setGroupFieldList(groupFieldList);
        this.replaceCurrentScope(newScope);
        return gbc;
    }

    public final HavingClause HavingClause() throws ParseException, ParseException {
        Expression filterExpr = null;
        this.jj_consume_token(47);
        filterExpr = this.Expression();
        return new HavingClause(filterExpr);
    }

    public final LimitClause LimitClause() throws ParseException, ParseException {
        LimitClause lc = new LimitClause();
        this.pushForbiddenScope(this.getCurrentScope());
        this.jj_consume_token(66);
        Expression expr = this.Expression();
        lc.setLimitExpr(expr);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 71: {
                this.jj_consume_token(71);
                expr = this.Expression();
                lc.setOffset(expr);
                break;
            }
            default: {
                this.jj_la1[172] = this.jj_gen;
            }
        }
        this.popForbiddenScope();
        return lc;
    }

    public final QuantifiedExpression QuantifiedExpression() throws ParseException, ParseException {
        QuantifiedExpression qc = new QuantifiedExpression();
        ArrayList<QuantifiedPair> quantifiedList = new ArrayList<QuantifiedPair>();
        this.createNewScope();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 92: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 3: {
                        this.jj_consume_token(3);
                        break;
                    }
                    case 92: {
                        this.jj_consume_token(92);
                        break;
                    }
                    default: {
                        this.jj_la1[173] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                qc.setQuantifier(QuantifiedExpression.Quantifier.SOME);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                qc.setQuantifier(QuantifiedExpression.Quantifier.EVERY);
                break;
            }
            default: {
                this.jj_la1[174] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        VariableExpr var = this.Variable();
        this.jj_consume_token(51);
        Expression inExpr = this.Expression();
        QuantifiedPair pair = new QuantifiedPair(var, inExpr);
        quantifiedList.add(pair);
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[175] = this.jj_gen;
                    break block14;
                }
            }
            this.jj_consume_token(125);
            var = this.Variable();
            this.jj_consume_token(51);
            inExpr = this.Expression();
            pair = new QuantifiedPair(var, inExpr);
            quantifiedList.add(pair);
        }
        this.jj_consume_token(88);
        Expression satisfiesExpr = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                this.jj_consume_token(33);
                break;
            }
            default: {
                this.jj_la1[176] = this.jj_gen;
            }
        }
        qc.setSatisfiesExpr(satisfiesExpr);
        qc.setQuantifiedList(quantifiedList);
        this.removeCurrentScope();
        return qc;
    }

    public final LetClause LetElement() throws ParseException, ParseException {
        LetClause lc = new LetClause();
        this.extendCurrentScope();
        VariableExpr varExp = this.Variable();
        this.jj_consume_token(134);
        Expression beExp = this.Expression();
        lc.setVarExpr(varExp);
        lc.setBindingExpr(beExp);
        return lc;
    }

    public final LetClause WithElement() throws ParseException, ParseException {
        LetClause lc = new LetClause();
        this.extendCurrentScope();
        VariableExpr varExp = this.Variable();
        this.jj_consume_token(5);
        Expression beExp = this.Expression();
        lc.setVarExpr(varExp);
        lc.setBindingExpr(beExp);
        return lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    private boolean jj_3R_104() {
        return this.jj_scan_token(142);
    }

    private boolean jj_3R_103() {
        return this.jj_3R_117();
    }

    private boolean jj_3R_97() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_103()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_104()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_105()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_106()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_107()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_108()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_109()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_110()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_128() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_127() {
        return this.jj_3R_128();
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(109)) {
            return true;
        }
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_138() {
        return this.jj_3R_140();
    }

    private boolean jj_3R_95() {
        return this.jj_3R_101();
    }

    private boolean jj_3R_94() {
        return this.jj_3R_100();
    }

    private boolean jj_3R_102() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(118)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(115)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_93() {
        return this.jj_3R_99();
    }

    private boolean jj_3R_135() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_138()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_139()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_92() {
        return this.jj_3R_98();
    }

    private boolean jj_3R_91() {
        return this.jj_3R_97();
    }

    private boolean jj_3R_82() {
        return this.jj_scan_token(129);
    }

    private boolean jj_3R_50() {
        Token xsp;
        if (this.jj_3R_60()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_102());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_6() {
        return this.jj_3R_41();
    }

    private boolean jj_3R_100() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_127()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(139);
    }

    private boolean jj_3R_89() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_6()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_91()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_92()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_93()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_94()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_95()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_61() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_72()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_73()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_72() {
        if (this.jj_scan_token(126)) {
            return true;
        }
        if (this.jj_3R_57()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_82()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_51() {
        if (this.jj_3R_57()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_61()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(130)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(131)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(132)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(133)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(134)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(135)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(136)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(137)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_35()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_36();
    }

    private boolean jj_3R_120() {
        if (this.jj_scan_token(119)) {
            return true;
        }
        return this.jj_3R_130();
    }

    private boolean jj_3R_70() {
        if (this.jj_3R_36()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_131() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_129() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_131()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(125)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_96() {
        return this.jj_scan_token(112);
    }

    private boolean jj_3R_126() {
        return this.jj_scan_token(121);
    }

    private boolean jj_3R_114() {
        return this.jj_3R_119();
    }

    private boolean jj_3R_40() {
        Token xsp;
        if (this.jj_3R_50()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_96());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_119() {
        if (this.jj_scan_token(140)) {
            return true;
        }
        if (this.jj_3R_129()) {
            return true;
        }
        return this.jj_scan_token(141);
    }

    private boolean jj_3R_69() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_125() {
        return this.jj_scan_token(126);
    }

    private boolean jj_3R_58() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_69()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_70();
    }

    private boolean jj_3R_45() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_133() {
        return this.jj_3R_135();
    }

    private boolean jj_3R_117() {
        return this.jj_scan_token(154);
    }

    private boolean jj_3R_84() {
        return this.jj_3R_80();
    }

    private boolean jj_3R_124() {
        return this.jj_3R_126();
    }

    private boolean jj_3R_118() {
        if (this.jj_scan_token(121)) {
            return true;
        }
        if (this.jj_3R_129()) {
            return true;
        }
        return this.jj_scan_token(122);
    }

    private boolean jj_3_10() {
        if (this.jj_scan_token(125)) {
            return true;
        }
        return this.jj_3R_45();
    }

    private boolean jj_3R_132() {
        return this.jj_3R_134();
    }

    private boolean jj_3R_80() {
        return this.jj_scan_token(153);
    }

    private boolean jj_3R_130() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_132()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_133();
    }

    private boolean jj_3R_123() {
        return this.jj_3R_125();
    }

    private boolean jj_3R_122() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_123()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_124()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_44() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(5)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_57();
    }

    private boolean jj_3R_39() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_141() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_86() {
        Token xsp;
        if (this.jj_3R_89()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_122());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_39()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(65)) {
            return true;
        }
        return this.jj_3R_40();
    }

    private boolean jj_3R_113() {
        return this.jj_3R_118();
    }

    private boolean jj_3R_59() {
        return this.jj_scan_token(2);
    }

    private boolean jj_3R_99() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_113()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_114()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_49() {
        if (this.jj_3R_40()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_90() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_88() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_90()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_46() {
        Token xsp;
        if (this.jj_3R_58()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_59());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_78() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_112() {
        return this.jj_3R_80();
    }

    private boolean jj_3R_76() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_56() {
        return this.jj_scan_token(117);
    }

    private boolean jj_3R_55() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_77() {
        return this.jj_scan_token(107);
    }

    private boolean jj_3_9() {
        if (this.jj_3R_42()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_44()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_43() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_9()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_55()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_56()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_83() {
        return this.jj_scan_token(164);
    }

    private boolean jj_3R_65() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_76()) {
            this.jj_scanpos = xsp;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_77());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_78()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_79() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_83()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_84()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_87() {
        return this.jj_scan_token(58);
    }

    private boolean jj_3R_85() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(118)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(115)) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_88()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_81() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_85()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_86();
    }

    private boolean jj_3R_38() {
        if (this.jj_3R_49()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_87()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_47() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3_11() {
        if (this.jj_scan_token(125)) {
            return true;
        }
        return this.jj_3R_42();
    }

    private boolean jj_3R_115() {
        return this.jj_3R_120();
    }

    private boolean jj_3R_34() {
        Token xsp;
        if (this.jj_3R_46()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_47());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(119)) {
            return true;
        }
        return this.jj_3R_42();
    }

    private boolean jj_3R_101() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_115()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_8() {
        if (this.jj_scan_token(125)) {
            return true;
        }
        return this.jj_3R_43();
    }

    private boolean jj_3R_111() {
        return this.jj_scan_token(164);
    }

    private boolean jj_3R_98() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_111()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_112()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_63() {
        return this.jj_scan_token(117);
    }

    private boolean jj_3R_54() {
        return this.jj_3R_66();
    }

    private boolean jj_3R_53() {
        return this.jj_3R_65();
    }

    private boolean jj_3R_121() {
        return this.jj_scan_token(111);
    }

    private boolean jj_3R_71() {
        if (this.jj_3R_81()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_121()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_2() {
        return this.jj_3R_34();
    }

    private boolean jj_3R_48() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_48()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(51);
    }

    private boolean jj_3R_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_53()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_54()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_110() {
        return this.jj_scan_token(146);
    }

    private boolean jj_3R_109() {
        return this.jj_scan_token(145);
    }

    private boolean jj_3R_68() {
        return this.jj_3R_80();
    }

    private boolean jj_3R_62() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_108() {
        return this.jj_scan_token(144);
    }

    private boolean jj_3R_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_62()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_63()) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_64());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_140() {
        return this.jj_scan_token(90);
    }

    private boolean jj_3R_64() {
        return this.jj_scan_token(125);
    }

    private boolean jj_3R_67() {
        return this.jj_scan_token(164);
    }

    private boolean jj_3R_107() {
        return this.jj_scan_token(143);
    }

    private boolean jj_3R_57() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_67()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_68()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_37() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_75() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_74() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(3)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(92)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_37()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_3R_38();
    }

    private boolean jj_3R_36() {
        if (this.jj_3R_38()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_106() {
        return this.jj_scan_token(148);
    }

    private boolean jj_3R_116() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(117)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(113)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(116)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(114)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_137() {
        return this.jj_scan_token(109);
    }

    private boolean jj_3R_60() {
        Token xsp;
        if (this.jj_3R_71()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_116());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_73() {
        if (this.jj_scan_token(129)) {
            return true;
        }
        return this.jj_3R_57();
    }

    private boolean jj_3R_41() {
        if (this.jj_3R_51()) {
            return true;
        }
        if (this.jj_scan_token(119)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_52()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_66() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_74()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_75()) {
                return true;
            }
        }
        return this.jj_3R_79();
    }

    private boolean jj_3R_136() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(64)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(63)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_105() {
        return this.jj_scan_token(149);
    }

    private boolean jj_3R_134() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_136()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_137()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_139() {
        return this.jj_3R_141();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{1430474760, 0, 0, 1430474760, 0x380000, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0, 0, 0x180000, 0, 0, 0, 0, 0, 1024, 0x800000, 0x800000, 0, 0, 0, 0, 0, 0, 0x380000, 0, 32, 0, 32, 0, 32, 32, 0, 0, Integer.MIN_VALUE, 0x1000000, 0, 0, 0x4020000, 16, 0, 0, 0, 0, 0, 0, 0, 0, 8192, 8192, 8192, 0, 0, 0, 0, 0, 0, 0, 0x180000, 0, 0, 0, 0, 0, 0, 4104, 4104, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4104, 0, 0, 0, 0, 0, 0, 4104, 0, 0, 4104, 4104, 0, 4104, 0, 4104, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000002, 0x8000002, 536875016, 536875016, 0x20000000, 32, 32, 4104, 32, 32, 128, 262144, 0, 262144, 32, 32, 128, 262144, 32, 128, 0, 0, 0, 0, 0, 0, 0x2000040, 0x2000040, 0x2000040, 0x2000040, 32, 32, 0, 32, 32, 0, 0, 0, 0, 8, 8, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{-2139093996, 0, 0, -2139093996, 19931232, 0, 0, 65536, 0, 0, 0x1000000, 0x1000000, 0, 0, 0, 65536, 0, 0, 0x1000020, 0, 0, 0, 0, 1, 0x10001000, 0, 0, 0, 0, 0, 131072, 0, 0, 3153984, 131072, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x820000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2147482604, 4, 0, 0, 0, 0, 524288, 0, 0, 0, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 20, 0, 0, 0, 0, 0, 0, 20, 0, 0, 20, 20, 0, 20, 0, 20, 0, 0, Integer.MIN_VALUE, 0, 0, 0x2000008, 0x2000008, 0, 1024, Integer.MIN_VALUE, 1024, 0, Integer.MIN_VALUE, 32768, 16384, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 32768, 16384, 1024, 0, 0, 20, 20, 0, 0, 0, 20, 0, 0, 0, 1212154112, 0x40400000, 0x8000100, 0, 0, 0, 256, 0, 0, 0, 0x40400000, Integer.MIN_VALUE, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 0, 0, 4, 0, 2};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{2089287753, 0, 0, 2089287753, -2147483632, 0, 256, 0, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 256, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0x400020, 0, 0, 49152, 0, 0, 0, 0, 0, 16, 0, 0, 0x200000, 0, 0x200000, 0, 0, 0, 0, 0, 0x8000000, 0, 65536, 0x60000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 512, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x14000041, 0x10000000, 1024, 0, 64, 64, 64, 64, 64, 0, 0, 64, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 0, 0x10000040, 0, 0, 0, 0, 0, 0, 0x10000040, 0, 0, 0x10000040, 0x10000040, 0, 0x10000040, 0, 0x10000040, 0, 0, 1, 2048, 4, 0, 0, 0, 0x4000000, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0x4000000, 0, 0, 0x10040040, 0x10040040, 262144, 0, 0, 0x10000040, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4096, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0x10000000, 0x10000000, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{46686656, 0, 0, 46686656, 2, 0x20000000, 0, 0, 0x800000, 512, 0, 0, 8192, 0, 0, 0, 0x800000, 512, 0, 0, 0x20000000, 0x20000000, 2, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0x20000000, 0x20000000, 2, 0, 0, 0, 0, 0, 0, 0, 4096, 0x20000000, 0, 64, 512, 0, 0, 0, 512, 0x20000000, 0x800000, 0x20000000, 0x800000, 0, 0, 0x2000000, 0x2000000, 0, 0, 0x20000000, 0, Integer.MIN_VALUE, 0, 0x40000000, 0x40000000, 0, 0, 0x10000000, 0x800000, 0x40000000, 0, 0x40000000, 0x40000000, 46669824, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 65536, 0x480000, 0x480000, 0x360000, 0x360000, 32768, 0, 0x480000, 0x480000, 0x42000000, 0x42000000, -2100822016, 0x2800000, 0, 0, 0, 0x2000000, 0x20000000, 46661632, 0x20000000, 0x20000000, 46661632, 48758784, 0x20000000, 48758784, 0x800000, 46661632, 2048, 0, 8192, 0, 0, 8, 8, 0, 0x800000, 8192, 0, 4096, 8192, 0, 0, 8192, 4096, 8192, 0, 0, 0, 0, 0, 48759808, 48759808, 1024, 0, 0, 48758784, 0, 0, 0, 32, 0, 32, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0x20000000, 0x20000000, 8192, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0x20000000, 0x800000, 0, 0, 0, 0, 0x20000000, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{104322048, 1, 1, 104322048, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x6000000, 0x6004000, 0x2001000, 33559552, 0, 0, 0, 0x2000000, 0, 2, 2, 2, 0x2000000, 0, 0, 0, 0, 0x6000000, 0, 0, 104322048, 0, 0, 0, 0, 0, 1020, 0, 0, 98304, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 104322048, 104322048, 70762496, 0x2000000, 0x2000000, 4096, 0, 104322048, 0, 0, 104322048, 104322048, 0, 104322048, 0, 104322048, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 104322048, 104322048, 0, 0, 0x2000000, 104322048, 0, 0x2000000, 0, 0, 0, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_5() {
        jj_la1_5 = new int[]{16, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 16, 16, 0, 0, 0, 16, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 0, 16, 16, 0, 0, 16, 0, 0, 16, 16, 0, 16, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 16, 16, 0, 16, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public SQLPPParser(InputStream stream) {
        this(stream, null);
    }

    public SQLPPParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SQLPPParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 177; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 177; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SQLPPParser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new SQLPPParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 177; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 177; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SQLPPParser(SQLPPParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 177; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SQLPPParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 177; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[180];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 177; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) == 0) continue;
                la1tokens[160 + j] = true;
            }
        }
        for (i = 0; i < 180; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 11; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SQLPPParser.jj_la1_init_0();
        SQLPPParser.jj_la1_init_1();
        SQLPPParser.jj_la1_init_2();
        SQLPPParser.jj_la1_init_3();
        SQLPPParser.jj_la1_init_4();
        SQLPPParser.jj_la1_init_5();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    private static class FunctionName {
        public String dataverse = null;
        public String library = null;
        public String function = null;
        public String hint = null;

        private FunctionName() {
        }
    }

    private static class IndexParams {
        public DatasetConfig.IndexType type;
        public int gramLength;

        public IndexParams(DatasetConfig.IndexType type, int gramLength) {
            this.type = type;
            this.gramLength = gramLength;
        }
    }
}

