/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.clause;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;
import org.apache.commons.lang3.ObjectUtils;

public class FromTerm
implements Clause {
    private Expression leftExpr;
    private VariableExpr leftVar;
    private VariableExpr posVar;
    private List<AbstractBinaryCorrelateClause> correlateClauses = new ArrayList<AbstractBinaryCorrelateClause>();

    public FromTerm(Expression leftExpr, VariableExpr leftVar, VariableExpr posVar, List<AbstractBinaryCorrelateClause> correlateClauses) {
        this.leftExpr = leftExpr;
        this.leftVar = leftVar;
        this.posVar = posVar;
        if (correlateClauses != null) {
            this.correlateClauses.addAll(correlateClauses);
        }
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return ((ISqlppVisitor)visitor).visit(this, arg);
    }

    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.FROM_TERM;
    }

    public Expression getLeftExpression() {
        return this.leftExpr;
    }

    public void setLeftExpression(Expression expr) {
        this.leftExpr = expr;
    }

    public VariableExpr getLeftVariable() {
        return this.leftVar;
    }

    public VariableExpr getPositionalVariable() {
        return this.posVar;
    }

    public boolean hasCorrelateClauses() {
        return this.correlateClauses != null && !this.correlateClauses.isEmpty();
    }

    public List<AbstractBinaryCorrelateClause> getCorrelateClauses() {
        return this.correlateClauses;
    }

    public boolean hasPositionalVariable() {
        return this.posVar != null;
    }

    public String toString() {
        return String.valueOf(this.leftExpr) + " AS " + this.leftVar;
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.correlateClauses, this.leftExpr, this.leftVar, this.posVar});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FromTerm)) {
            return false;
        }
        FromTerm target = (FromTerm)object;
        return ObjectUtils.equals(this.correlateClauses, target.correlateClauses) && ObjectUtils.equals((Object)this.leftExpr, (Object)target.leftExpr) && ObjectUtils.equals((Object)this.leftVar, (Object)target.leftVar) && ObjectUtils.equals((Object)this.posVar, (Object)target.posVar);
    }
}

