/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.dataflow;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.dataflow.AbstractTreeIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IndexSearchOperatorNodePushable;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.common.tuples.PermutingFrameTupleReference;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.am.rtree.util.RTreeUtils;

public class RTreeSearchOperatorNodePushable
extends IndexSearchOperatorNodePushable {
    protected PermutingFrameTupleReference searchKey;
    protected MultiComparator cmp;

    public RTreeSearchOperatorNodePushable(AbstractTreeIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition, IRecordDescriptorProvider recordDescProvider, int[] keyFields, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes) throws HyracksDataException {
        super((IIndexOperatorDescriptor)opDesc, ctx, partition, recordDescProvider, minFilterFieldIndexes, maxFilterFieldIndexes);
        if (keyFields != null && keyFields.length > 0) {
            this.searchKey = new PermutingFrameTupleReference();
            this.searchKey.setFieldPermutation(keyFields);
        }
    }

    protected ISearchPredicate createSearchPredicate() {
        ITreeIndex treeIndex = (ITreeIndex)this.index;
        this.cmp = RTreeUtils.getSearchMultiComparator(treeIndex.getComparatorFactories(), (ITupleReference)this.searchKey);
        return new SearchPredicate((ITupleReference)this.searchKey, this.cmp, (ITupleReference)this.minFilterKey, (ITupleReference)this.maxFilterKey);
    }

    protected void resetSearchPredicate(int tupleIndex) {
        if (this.searchKey != null) {
            this.searchKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
        if (this.minFilterKey != null) {
            this.minFilterKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
        if (this.maxFilterKey != null) {
            this.maxFilterKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
    }

    protected int getFieldCount() {
        return ((ITreeIndex)this.index).getFieldCount();
    }
}

