/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.dataflow;

import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.dataflow.AbstractTreeIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.TreeIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.util.IndexFileNameUtil;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;
import org.apache.hyracks.storage.am.rtree.util.RTreeUtils;

public class RTreeDataflowHelper
extends TreeIndexDataflowHelper {
    private final IPrimitiveValueProviderFactory[] valueProviderFactories;
    private final RTreePolicyType rtreePolicyType;

    public RTreeDataflowHelper(IIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition, IPrimitiveValueProviderFactory[] valueProviderFactories, RTreePolicyType rtreePolicyType, boolean durable) throws HyracksDataException {
        super(opDesc, ctx, partition, durable);
        this.valueProviderFactories = valueProviderFactories;
        this.rtreePolicyType = rtreePolicyType;
    }

    public ITreeIndex createIndexInstance() throws HyracksDataException {
        AbstractTreeIndexOperatorDescriptor treeOpDesc = (AbstractTreeIndexOperatorDescriptor)this.opDesc;
        FileReference fileRef = IndexFileNameUtil.getIndexAbsoluteFileRef((IIndexOperatorDescriptor)treeOpDesc, (int)this.ctx.getTaskAttemptId().getTaskId().getPartition(), (IIOManager)this.ctx.getIOManager());
        return RTreeUtils.createRTree(treeOpDesc.getStorageManager().getBufferCache(this.ctx), treeOpDesc.getStorageManager().getFileMapProvider(this.ctx), treeOpDesc.getTreeIndexTypeTraits(), this.valueProviderFactories, treeOpDesc.getTreeIndexComparatorFactories(), this.rtreePolicyType, fileRef, false, this.opDesc.getPageManagerFactory());
    }
}

