/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.aql.visitor.base;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.aql.clause.DistinctClause;
import org.apache.asterix.lang.aql.clause.ForClause;
import org.apache.asterix.lang.aql.expression.FLWOGRExpression;
import org.apache.asterix.lang.aql.expression.UnionExpr;
import org.apache.asterix.lang.aql.visitor.base.AbstractAqlQueryExpressionVisitor;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class AbstractAqlSimpleExpressionVisitor
extends AbstractAqlQueryExpressionVisitor<Expression, ILangExpression> {
    @Override
    public Expression visit(FLWOGRExpression flwogreExpr, ILangExpression arg) throws CompilationException {
        for (Clause clause : flwogreExpr.getClauseList()) {
            clause.accept((ILangVisitor)this, (Object)arg);
        }
        flwogreExpr.setReturnExpr((Expression)flwogreExpr.getReturnExpr().accept((ILangVisitor)this, (Object)arg));
        return flwogreExpr;
    }

    @Override
    public Expression visit(UnionExpr u, ILangExpression arg) throws CompilationException {
        u.setExprs(this.visit(u.getExprs(), arg));
        return u;
    }

    @Override
    public Expression visit(ForClause forClause, ILangExpression arg) throws CompilationException {
        forClause.setInExpr((Expression)forClause.getInExpr().accept((ILangVisitor)this, (Object)arg));
        return null;
    }

    @Override
    public Expression visit(DistinctClause distinctClause, ILangExpression arg) throws CompilationException {
        distinctClause.setDistinctByExpr(this.visit(distinctClause.getDistinctByExpr(), arg));
        return null;
    }

    public Expression visit(Query q, ILangExpression arg) throws CompilationException {
        q.setBody(this.visit(q.getBody(), (ILangExpression)q));
        return null;
    }

    public Expression visit(FunctionDecl fd, ILangExpression arg) throws CompilationException {
        fd.setFuncBody(this.visit(fd.getFuncBody(), (ILangExpression)fd));
        return null;
    }

    public Expression visit(WhereClause whereClause, ILangExpression arg) throws CompilationException {
        whereClause.setWhereExpr(this.visit(whereClause.getWhereExpr(), (ILangExpression)whereClause));
        return null;
    }

    public Expression visit(OrderbyClause oc, ILangExpression arg) throws CompilationException {
        oc.setOrderbyList(this.visit(oc.getOrderbyList(), arg));
        return null;
    }

    public Expression visit(GroupbyClause gc, ILangExpression arg) throws CompilationException {
        for (GbyVariableExpressionPair gbyVarExpr : gc.getGbyPairList()) {
            gbyVarExpr.setExpr(this.visit(gbyVarExpr.getExpr(), (ILangExpression)gc));
        }
        return null;
    }

    public Expression visit(LimitClause limitClause, ILangExpression arg) throws CompilationException {
        limitClause.setLimitExpr(this.visit(limitClause.getLimitExpr(), (ILangExpression)limitClause));
        if (limitClause.hasOffset()) {
            limitClause.setOffset(this.visit(limitClause.getOffset(), (ILangExpression)limitClause));
        }
        return null;
    }

    public Expression visit(LetClause letClause, ILangExpression arg) throws CompilationException {
        letClause.setBindingExpr(this.visit(letClause.getBindingExpr(), (ILangExpression)letClause));
        return null;
    }

    public Expression visit(LiteralExpr l, ILangExpression arg) throws CompilationException {
        return l;
    }

    public Expression visit(ListConstructor lc, ILangExpression arg) throws CompilationException {
        lc.setExprList(this.visit(lc.getExprList(), arg));
        return lc;
    }

    public Expression visit(RecordConstructor rc, ILangExpression arg) throws CompilationException {
        for (FieldBinding binding : rc.getFbList()) {
            binding.setLeftExpr(this.visit(binding.getLeftExpr(), (ILangExpression)rc));
            binding.setRightExpr(this.visit(binding.getRightExpr(), (ILangExpression)rc));
        }
        return rc;
    }

    public Expression visit(OperatorExpr operatorExpr, ILangExpression arg) throws CompilationException {
        operatorExpr.setExprList(this.visit(operatorExpr.getExprList(), arg));
        return operatorExpr;
    }

    public Expression visit(IfExpr ifExpr, ILangExpression arg) throws CompilationException {
        ifExpr.setCondExpr(this.visit(ifExpr.getCondExpr(), (ILangExpression)ifExpr));
        ifExpr.setThenExpr(this.visit(ifExpr.getThenExpr(), (ILangExpression)ifExpr));
        ifExpr.setElseExpr(this.visit(ifExpr.getElseExpr(), (ILangExpression)ifExpr));
        return ifExpr;
    }

    public Expression visit(QuantifiedExpression qe, ILangExpression arg) throws CompilationException {
        for (QuantifiedPair pair : qe.getQuantifiedList()) {
            pair.setExpr(this.visit(pair.getExpr(), (ILangExpression)qe));
        }
        qe.setSatisfiesExpr(this.visit(qe.getSatisfiesExpr(), (ILangExpression)qe));
        return qe;
    }

    public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
        callExpr.setExprList(this.visit(callExpr.getExprList(), arg));
        return callExpr;
    }

    public Expression visit(VariableExpr varExpr, ILangExpression arg) throws CompilationException {
        return varExpr;
    }

    public Expression visit(UnaryExpr u, ILangExpression arg) throws CompilationException {
        u.setExpr(this.visit(u.getExpr(), (ILangExpression)u));
        return u;
    }

    public Expression visit(FieldAccessor fa, ILangExpression arg) throws CompilationException {
        fa.setExpr(this.visit(fa.getExpr(), (ILangExpression)fa));
        return fa;
    }

    public Expression visit(IndexAccessor ia, ILangExpression arg) throws CompilationException {
        ia.setExpr(this.visit(ia.getExpr(), (ILangExpression)ia));
        if (ia.getIndexExpr() != null) {
            ia.setIndexExpr(this.visit(ia.getIndexExpr(), arg));
        }
        return ia;
    }

    protected Expression visit(Expression expr, ILangExpression arg) throws CompilationException {
        return this.postVisit((Expression)this.preVisit(expr).accept((ILangVisitor)this, (Object)arg));
    }

    protected Expression preVisit(Expression expr) throws CompilationException {
        return expr;
    }

    protected Expression postVisit(Expression expr) throws CompilationException {
        return expr;
    }

    private List<Expression> visit(List<Expression> exprs, ILangExpression arg) throws CompilationException {
        ArrayList<Expression> newExprList = new ArrayList<Expression>();
        for (Expression expr : exprs) {
            newExprList.add(this.visit(expr, arg));
        }
        return newExprList;
    }
}

