/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.marshalling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.string.UTF8StringReader;
import org.apache.hyracks.util.string.UTF8StringUtil;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class UTF8StringSerializerDeserializer
implements ISerializerDeserializer<String> {
    private static final long serialVersionUID = 1L;
    private final UTF8StringWriter utf8StringWriter;
    private final UTF8StringReader utf8StringReader;

    public UTF8StringSerializerDeserializer() {
        this.utf8StringWriter = null;
        this.utf8StringReader = null;
    }

    public UTF8StringSerializerDeserializer(UTF8StringWriter utf8StringWriter, UTF8StringReader utf8StringReader) {
        this.utf8StringWriter = utf8StringWriter;
        this.utf8StringReader = utf8StringReader;
    }

    public String deserialize(DataInput in) throws HyracksDataException {
        try {
            return UTF8StringUtil.readUTF8((DataInput)in, (UTF8StringReader)this.utf8StringReader);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void serialize(String instance, DataOutput out) throws HyracksDataException {
        try {
            UTF8StringUtil.writeUTF8((CharSequence)instance, (DataOutput)out, (UTF8StringWriter)this.utf8StringWriter);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }
}

