/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.marshalling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ShortSerializerDeserializer
implements ISerializerDeserializer<Short> {
    private static final long serialVersionUID = 1L;
    public static final ShortSerializerDeserializer INSTANCE = new ShortSerializerDeserializer();

    private ShortSerializerDeserializer() {
    }

    public Short deserialize(DataInput in) throws HyracksDataException {
        try {
            return in.readShort();
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void serialize(Short instance, DataOutput out) throws HyracksDataException {
        try {
            out.writeShort(instance.intValue());
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }
}

