/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.marshalling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class IntArraySerializerDeserializer
implements ISerializerDeserializer<int[]> {
    private static final long serialVersionUID = 1L;
    public static final IntArraySerializerDeserializer INSTANCE = new IntArraySerializerDeserializer();

    private IntArraySerializerDeserializer() {
    }

    public int[] deserialize(DataInput in) throws HyracksDataException {
        try {
            int len = in.readInt();
            int[] array = new int[len];
            for (int i = 0; i < array.length; ++i) {
                array[i] = in.readInt();
            }
            return array;
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void serialize(int[] instance, DataOutput out) throws HyracksDataException {
        try {
            out.writeInt(instance.length);
            for (int i = 0; i < instance.length; ++i) {
                out.writeInt(instance[i]);
            }
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }
}

