/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.marshalling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.ByteArrayPointable;
import org.apache.hyracks.util.encoding.VarLenIntEncoderDecoder;

public class ByteArraySerializerDeserializer
implements ISerializerDeserializer<byte[]> {
    private static final long serialVersionUID = 1L;
    public static ByteArraySerializerDeserializer INSTANCE = new ByteArraySerializerDeserializer();

    private ByteArraySerializerDeserializer() {
    }

    public byte[] deserialize(DataInput in) throws HyracksDataException {
        try {
            int contentLength = VarLenIntEncoderDecoder.decode((DataInput)in);
            byte[] bytes = new byte[contentLength];
            in.readFully(bytes, 0, contentLength);
            return bytes;
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void serialize(byte[] instance, DataOutput out) throws HyracksDataException {
        try {
            byte[] metaBuffer = new byte[5];
            int metaLength = VarLenIntEncoderDecoder.encode((int)instance.length, (byte[])metaBuffer, (int)0);
            out.write(metaBuffer, 0, metaLength);
            out.write(instance);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void serialize(ByteArrayPointable byteArrayPtr, DataOutput out) throws HyracksDataException {
        try {
            out.write(byteArrayPtr.getByteArray(), byteArrayPtr.getStartOffset(), byteArrayPtr.getLength());
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void serialize(byte[] instance, int start, int length, DataOutput out) throws HyracksDataException {
        byte[] metaBuffer = new byte[5];
        int metaLength = VarLenIntEncoderDecoder.encode((int)length, (byte[])metaBuffer, (int)0);
        try {
            out.write(metaBuffer, 0, metaLength);
            out.write(instance, start, length);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }
}

