/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.comm.io;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOpenableDataWriter;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;

public class SerializingDataWriter
implements IOpenableDataWriter<Object[]> {
    private static final Logger LOGGER = Logger.getLogger(SerializingDataWriter.class.getName());
    private final ArrayTupleBuilder tb;
    private final RecordDescriptor recordDescriptor;
    private final IFrameWriter frameWriter;
    private final FrameTupleAppender tupleAppender;
    private boolean open;

    public SerializingDataWriter(IHyracksTaskContext ctx, RecordDescriptor recordDescriptor, IFrameWriter frameWriter) throws HyracksDataException {
        this.tb = new ArrayTupleBuilder(recordDescriptor.getFieldCount());
        this.recordDescriptor = recordDescriptor;
        this.frameWriter = frameWriter;
        this.tupleAppender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx));
        this.open = false;
    }

    public void open() throws HyracksDataException {
        this.frameWriter.open();
        this.open = true;
    }

    public void close() throws HyracksDataException {
        if (!this.open) {
            throw new HyracksDataException("Closing SerializingDataWriter that has not been opened");
        }
        try {
            this.tupleAppender.write(this.frameWriter, true);
        }
        catch (Exception e) {
            this.frameWriter.fail();
            throw e;
        }
        finally {
            this.frameWriter.close();
        }
        this.open = false;
    }

    public void writeData(Object[] data) throws HyracksDataException {
        if (!this.open) {
            throw new HyracksDataException("Writing to SerializingDataWriter that has not been opened");
        }
        this.tb.reset();
        for (int i = 0; i < data.length; ++i) {
            Object instance = data[i];
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest(i + " " + instance);
            }
            this.tb.addField(this.recordDescriptor.getFields()[i], instance);
        }
        FrameUtils.appendToWriter(this.frameWriter, this.tupleAppender, this.tb.getFieldEndOffsets(), this.tb.getByteArray(), 0, this.tb.getSize());
    }

    public void fail() throws HyracksDataException {
        this.frameWriter.fail();
    }

    public void flush() throws HyracksDataException {
        this.tupleAppender.flush(this.frameWriter);
    }
}

