/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.lifecycle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponentManager;

public class LifeCycleComponentManager
implements ILifeCycleComponentManager {
    private static final Logger LOGGER = Logger.getLogger(LifeCycleComponentManager.class.getName());
    private final List<ILifeCycleComponent> components = new ArrayList<ILifeCycleComponent>();
    private boolean stopInitiated = false;
    private boolean stopped = false;
    private String dumpPath;
    private boolean configured = false;

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        block3: {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("Uncaught Exception from thread " + t.getName() + " message: " + e.getMessage());
                e.printStackTrace();
            }
            try {
                this.stopAll(true);
            }
            catch (IOException e1) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                LOGGER.severe("Exception in stopping Asterix. " + e1.getMessage());
            }
        }
    }

    @Override
    public synchronized void register(ILifeCycleComponent component) {
        this.components.add(component);
    }

    @Override
    public void startAll() {
        for (ILifeCycleComponent component : this.components) {
            component.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopAll(boolean dumpState) throws IOException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.severe("Attempting to stop " + this);
        }
        if (this.stopped) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.severe("Lifecycle management was already stopped");
            }
            return;
        }
        if (this.stopInitiated) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.severe("Stop already in progress");
            }
            return;
        }
        if (!this.configured) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("Lifecycle management not configured" + this);
            }
            return;
        }
        this.stopInitiated = true;
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.severe("Stopping Asterix instance");
        }
        FileOutputStream componentDumpStream = null;
        String componentDumpPath = null;
        for (int index = this.components.size() - 1; index >= 0; --index) {
            ILifeCycleComponent component = this.components.get(index);
            try {
                if (dumpState) {
                    componentDumpPath = this.dumpPath + File.separator + component.getClass().getName() + "-coredump";
                    File f = new File(componentDumpPath);
                    File parentDir = new File(f.getParent());
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    componentDumpStream = new FileOutputStream(f);
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Stopping component instance " + component.getClass().getName() + " dump state " + dumpState + " dump path " + componentDumpPath);
                }
                component.stop(dumpState, componentDumpStream);
                continue;
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.severe("Exception in stopping component " + component.getClass().getName() + e.getMessage());
                continue;
            }
            finally {
                if (componentDumpStream != null) {
                    componentDumpStream.close();
                }
            }
        }
        this.stopInitiated = false;
        this.stopped = true;
    }

    @Override
    public void configure(Map<String, String> configuration) {
        this.dumpPath = configuration.get("DUMP_PATH");
        if (this.dumpPath == null) {
            this.dumpPath = System.getProperty("user.dir");
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("dump path not configured. Using current directory " + this.dumpPath);
            }
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("LifecycleComponentManager configured " + this);
        }
        this.configured = true;
    }

    @Override
    public String getDumpPath() {
        return this.dumpPath;
    }

    @Override
    public void dumpState(OutputStream os) throws IOException {
        for (int index = this.components.size() - 1; index >= 0; --index) {
            ILifeCycleComponent component = this.components.get(index);
            component.dumpState(os);
        }
    }

    public boolean stoppedAll() {
        return this.stopped;
    }

    public static final class Config {
        public static final String DUMP_PATH_KEY = "DUMP_PATH";
    }
}

