/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.job.resource;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.resource.IClusterCapacity;
import org.apache.hyracks.api.job.resource.NodeCapacity;

public class ClusterCapacity
implements IClusterCapacity {
    private long aggregatedMemoryByteSize = 0L;
    private int aggregatedCores = 0;
    private final Map<String, Long> nodeMemoryMap = new HashMap<String, Long>();
    private final Map<String, Integer> nodeCoreMap = new HashMap<String, Integer>();

    @Override
    public long getAggregatedMemoryByteSize() {
        return this.aggregatedMemoryByteSize;
    }

    @Override
    public int getAggregatedCores() {
        return this.aggregatedCores;
    }

    @Override
    public long getMemoryByteSize(String nodeId) throws HyracksException {
        if (!this.nodeMemoryMap.containsKey(nodeId)) {
            throw HyracksException.create(10, new Serializable[]{nodeId});
        }
        return this.nodeMemoryMap.get(nodeId);
    }

    @Override
    public int getCores(String nodeId) throws HyracksException {
        if (!this.nodeMemoryMap.containsKey(nodeId)) {
            throw HyracksException.create(10, new Serializable[]{nodeId});
        }
        return this.nodeCoreMap.get(nodeId);
    }

    @Override
    public void setAggregatedMemoryByteSize(long aggregatedMemoryByteSize) {
        this.aggregatedMemoryByteSize = aggregatedMemoryByteSize;
    }

    @Override
    public void setAggregatedCores(int aggregatedCores) {
        this.aggregatedCores = aggregatedCores;
    }

    @Override
    public void setMemoryByteSize(String nodeId, long memoryByteSize) {
        this.nodeMemoryMap.put(nodeId, memoryByteSize);
    }

    @Override
    public void setCores(String nodeId, int cores) {
        this.nodeCoreMap.put(nodeId, cores);
    }

    @Override
    public void update(String nodeId, NodeCapacity nodeCapacity) throws HyracksException {
        if (this.nodeMemoryMap.containsKey(nodeId)) {
            this.aggregatedMemoryByteSize -= this.nodeMemoryMap.remove(nodeId).longValue();
        }
        if (this.nodeCoreMap.containsKey(nodeId)) {
            this.aggregatedCores -= this.nodeCoreMap.remove(nodeId).intValue();
        }
        long memorySize = nodeCapacity.getMemoryByteSize();
        int cores = nodeCapacity.getCores();
        if (memorySize > 0L && cores > 0) {
            this.aggregatedMemoryByteSize += memorySize;
            this.aggregatedCores += cores;
            this.nodeMemoryMap.put(nodeId, memorySize);
            this.nodeCoreMap.put(nodeId, cores);
        }
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.aggregatedMemoryByteSize, this.aggregatedCores, this.nodeMemoryMap, this.nodeCoreMap});
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterCapacity)) {
            return false;
        }
        ClusterCapacity capacity = (ClusterCapacity)o;
        return this.aggregatedMemoryByteSize == capacity.aggregatedMemoryByteSize && this.aggregatedCores == capacity.aggregatedCores && ObjectUtils.equals(this.nodeMemoryMap, capacity.nodeMemoryMap) && ObjectUtils.equals(this.nodeCoreMap, capacity.nodeCoreMap);
    }

    public String toString() {
        return "(memory: " + this.aggregatedMemoryByteSize + " bytes, CPU cores: " + this.aggregatedCores + ")";
    }
}

