/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.io;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOFuture;
import org.apache.hyracks.api.io.IODeviceHandle;

public interface IIOManager {
    public List<IODeviceHandle> getIODevices();

    public IFileHandle open(FileReference var1, FileReadWriteMode var2, FileSyncMode var3) throws HyracksDataException;

    public int syncWrite(IFileHandle var1, long var2, ByteBuffer var4) throws HyracksDataException;

    public long syncWrite(IFileHandle var1, long var2, ByteBuffer[] var4) throws HyracksDataException;

    public int syncRead(IFileHandle var1, long var2, ByteBuffer var4) throws HyracksDataException;

    public IIOFuture asyncWrite(IFileHandle var1, long var2, ByteBuffer var4);

    public IIOFuture asyncRead(IFileHandle var1, long var2, ByteBuffer var4);

    public void close(IFileHandle var1) throws HyracksDataException;

    public void sync(IFileHandle var1, boolean var2) throws HyracksDataException;

    public void setExecutor(Executor var1);

    public long getSize(IFileHandle var1);

    public void deleteWorkspaceFiles();

    public FileReference getFileReference(int var1, String var2);

    public FileReference resolve(String var1) throws HyracksDataException;

    @Deprecated
    public FileReference resolveAbsolutePath(String var1) throws HyracksDataException;

    public FileReference createWorkspaceFile(String var1) throws HyracksDataException;

    public static enum FileSyncMode {
        METADATA_SYNC_DATA_SYNC,
        METADATA_ASYNC_DATA_SYNC,
        METADATA_ASYNC_DATA_ASYNC;

    }

    public static enum FileReadWriteMode {
        READ_ONLY,
        READ_WRITE;

    }
}

