/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.constraints;

import org.apache.hyracks.api.constraints.Constraint;
import org.apache.hyracks.api.constraints.expressions.ConstantExpression;
import org.apache.hyracks.api.constraints.expressions.PartitionCountExpression;
import org.apache.hyracks.api.constraints.expressions.PartitionLocationExpression;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.job.JobSpecification;

public class PartitionConstraintHelper {
    public static void addPartitionCountConstraint(JobSpecification spec, IOperatorDescriptor op, int count) {
        spec.addUserConstraint(new Constraint(new PartitionCountExpression(op.getOperatorId()), new ConstantExpression(count)));
    }

    public static void addLocationChoiceConstraint(JobSpecification spec, IOperatorDescriptor op, String[][] choices) {
        PartitionConstraintHelper.addPartitionCountConstraint(spec, op, choices.length);
        for (int i = 0; i < choices.length; ++i) {
            spec.addUserConstraint(new Constraint(new PartitionLocationExpression(op.getOperatorId(), i), new ConstantExpression(choices[i])));
        }
    }

    public static void addAbsoluteLocationConstraint(JobSpecification spec, IOperatorDescriptor op, String ... locations) {
        PartitionConstraintHelper.addPartitionCountConstraint(spec, op, locations.length);
        for (int i = 0; i < locations.length; ++i) {
            spec.addUserConstraint(new Constraint(new PartitionLocationExpression(op.getOperatorId(), i), new ConstantExpression(locations[i])));
        }
    }
}

