/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.client;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.hyracks.api.client.ClusterControllerInfo;
import org.apache.hyracks.api.client.HyracksClientInterfaceRemoteProxy;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.client.IHyracksClientInterface;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.client.impl.JobSpecificationActivityClusterGraphGeneratorFactory;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IActivityClusterGraphGeneratorFactory;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobInfo;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.topology.ClusterTopology;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.api.IIPCI;
import org.apache.hyracks.ipc.api.IPayloadSerializerDeserializer;
import org.apache.hyracks.ipc.api.RPCInterface;
import org.apache.hyracks.ipc.impl.IPCSystem;
import org.apache.hyracks.ipc.impl.JavaSerializationBasedPayloadSerializerDeserializer;

public final class HyracksConnection
implements IHyracksClientConnection {
    private final String ccHost;
    private final IPCSystem ipc;
    private final IHyracksClientInterface hci;
    private final ClusterControllerInfo ccInfo;

    public HyracksConnection(String ccHost, int ccPort) throws Exception {
        this.ccHost = ccHost;
        RPCInterface rpci = new RPCInterface();
        this.ipc = new IPCSystem(new InetSocketAddress(0), (IIPCI)rpci, (IPayloadSerializerDeserializer)new JavaSerializationBasedPayloadSerializerDeserializer());
        this.ipc.start();
        IIPCHandle ccIpchandle = this.ipc.getHandle(new InetSocketAddress(ccHost, ccPort));
        this.hci = new HyracksClientInterfaceRemoteProxy(ccIpchandle, rpci);
        this.ccInfo = this.hci.getClusterControllerInfo();
    }

    @Override
    public JobStatus getJobStatus(JobId jobId) throws Exception {
        return this.hci.getJobStatus(jobId);
    }

    @Override
    public void cancelJob(JobId jobId) throws Exception {
        this.hci.cancelJob(jobId);
    }

    @Override
    public JobId startJob(JobSpecification jobSpec) throws Exception {
        return this.startJob(jobSpec, EnumSet.noneOf(JobFlag.class));
    }

    @Override
    public JobId startJob(JobSpecification jobSpec, EnumSet<JobFlag> jobFlags) throws Exception {
        JobSpecificationActivityClusterGraphGeneratorFactory jsacggf = new JobSpecificationActivityClusterGraphGeneratorFactory(jobSpec);
        return this.startJob(jsacggf, jobFlags);
    }

    @Override
    public JobId distributeJob(JobSpecification jobSpec) throws Exception {
        JobSpecificationActivityClusterGraphGeneratorFactory jsacggf = new JobSpecificationActivityClusterGraphGeneratorFactory(jobSpec);
        return this.distributeJob(jsacggf);
    }

    @Override
    public JobId destroyJob(JobId jobId) throws Exception {
        return this.hci.destroyJob(jobId);
    }

    @Override
    public JobId startJob(JobId jobId) throws Exception {
        return this.hci.startJob(jobId);
    }

    @Override
    public JobId startJob(IActivityClusterGraphGeneratorFactory acggf, EnumSet<JobFlag> jobFlags) throws Exception {
        return this.hci.startJob(JavaSerializationUtils.serialize(acggf), jobFlags);
    }

    public JobId distributeJob(IActivityClusterGraphGeneratorFactory acggf) throws Exception {
        return this.hci.distributeJob(JavaSerializationUtils.serialize(acggf));
    }

    @Override
    public NetworkAddress getDatasetDirectoryServiceInfo() throws Exception {
        return this.hci.getDatasetDirectoryServiceInfo();
    }

    @Override
    public void waitForCompletion(JobId jobId) throws Exception {
        this.hci.waitForCompletion(jobId);
    }

    @Override
    public Map<String, NodeControllerInfo> getNodeControllerInfos() throws HyracksException {
        try {
            return this.hci.getNodeControllersInfo();
        }
        catch (Exception e) {
            throw new HyracksException(e);
        }
    }

    @Override
    public ClusterTopology getClusterTopology() throws HyracksException {
        try {
            return this.hci.getClusterTopology();
        }
        catch (Exception e) {
            throw new HyracksException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentId deployBinary(List<String> jars) throws Exception {
        DeploymentId deploymentId = new DeploymentId(UUID.randomUUID().toString());
        ArrayList<URL> binaryURLs = new ArrayList<URL>();
        if (jars != null && !jars.isEmpty()) {
            try (DefaultHttpClient hc = new DefaultHttpClient();){
                for (String jar : jars) {
                    int slashIndex = jar.lastIndexOf(47);
                    String fileName = jar.substring(slashIndex + 1);
                    String url = "http://" + this.ccHost + ":" + this.ccInfo.getWebPort() + "/applications/" + deploymentId.toString() + "&" + fileName;
                    HttpPut put = new HttpPut(url);
                    put.setEntity((HttpEntity)new FileEntity(new File(jar), "application/octet-stream"));
                    CloseableHttpResponse response = hc.execute((HttpUriRequest)put);
                    response.getEntity().consumeContent();
                    if (response.getStatusLine().getStatusCode() != 200) {
                        this.hci.unDeployBinary(deploymentId);
                        throw new HyracksException(response.getStatusLine().toString());
                    }
                    binaryURLs.add(new URL(url));
                }
            }
        }
        this.hci.deployBinary(binaryURLs, deploymentId);
        return deploymentId;
    }

    @Override
    public void unDeployBinary(DeploymentId deploymentId) throws Exception {
        this.hci.unDeployBinary(deploymentId);
    }

    @Override
    public JobId startJob(DeploymentId deploymentId, JobSpecification jobSpec) throws Exception {
        return this.startJob(deploymentId, jobSpec, EnumSet.noneOf(JobFlag.class));
    }

    @Override
    public JobId startJob(DeploymentId deploymentId, JobSpecification jobSpec, EnumSet<JobFlag> jobFlags) throws Exception {
        JobSpecificationActivityClusterGraphGeneratorFactory jsacggf = new JobSpecificationActivityClusterGraphGeneratorFactory(jobSpec);
        return this.startJob(deploymentId, jsacggf, jobFlags);
    }

    @Override
    public JobId startJob(DeploymentId deploymentId, IActivityClusterGraphGeneratorFactory acggf, EnumSet<JobFlag> jobFlags) throws Exception {
        return this.hci.startJob(deploymentId, JavaSerializationUtils.serialize(acggf), jobFlags);
    }

    @Override
    public JobInfo getJobInfo(JobId jobId) throws Exception {
        return this.hci.getJobInfo(jobId);
    }

    @Override
    public void stopCluster(boolean terminateNCService) throws Exception {
        this.hci.stopCluster(terminateNCService);
    }

    @Override
    public String getNodeDetailsJSON(String nodeId, boolean includeStats, boolean includeConfig) throws Exception {
        return this.hci.getNodeDetailsJSON(nodeId, includeStats, includeConfig);
    }

    @Override
    public String getThreadDump(String node) throws Exception {
        return this.hci.getThreadDump(node);
    }
}

