/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.messaging;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.api.IAppRuntimeContext;
import org.apache.asterix.common.config.MessagingProperties;
import org.apache.asterix.common.memory.ConcurrentFramePool;
import org.apache.asterix.common.messaging.api.IApplicationMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.hyracks.api.comm.IChannelControlBlock;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.messages.IMessage;
import org.apache.hyracks.api.service.IControllerService;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.control.nc.NodeControllerService;

public class NCMessageBroker
implements INCMessageBroker {
    private static final Logger LOGGER = Logger.getLogger(NCMessageBroker.class.getName());
    private final NodeControllerService ncs;
    private final IAppRuntimeContext appContext;
    private final LinkedBlockingQueue<IApplicationMessage> receivedMsgsQ;
    private final ConcurrentFramePool messagingFramePool;
    private final int maxMsgSize;

    public NCMessageBroker(NodeControllerService ncs, MessagingProperties messagingProperties) {
        this.ncs = ncs;
        this.appContext = (IAppRuntimeContext)ncs.getApplicationContext();
        this.maxMsgSize = messagingProperties.getFrameSize();
        int messagingMemoryBudget = messagingProperties.getFrameSize() * messagingProperties.getFrameCount();
        this.messagingFramePool = new ConcurrentFramePool(ncs.getId(), (long)messagingMemoryBudget, messagingProperties.getFrameSize());
        this.receivedMsgsQ = new LinkedBlockingQueue();
        MessageDeliveryService msgDeliverySvc = new MessageDeliveryService();
        this.appContext.getThreadExecutor().execute(msgDeliverySvc);
    }

    public void sendMessageToCC(IApplicationMessage message) throws Exception {
        this.ncs.sendApplicationMessageToCC(JavaSerializationUtils.serialize((Serializable)message), null);
    }

    public void sendMessageToNC(String nodeId, IApplicationMessage message) throws Exception {
        IChannelControlBlock messagingChannel = this.ncs.getMessagingNetworkManager().getMessagingChannel(nodeId);
        this.sendMessageToChannel(messagingChannel, message);
    }

    public void queueReceivedMessage(IApplicationMessage msg) {
        this.receivedMsgsQ.offer(msg);
    }

    public void receivedMessage(IMessage message, String nodeId) throws Exception {
        IApplicationMessage absMessage = (IApplicationMessage)message;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Received message: " + absMessage);
        }
        absMessage.handle((IControllerService)this.ncs);
    }

    public ConcurrentFramePool getMessagingFramePool() {
        return this.messagingFramePool;
    }

    private void sendMessageToChannel(IChannelControlBlock ccb, IApplicationMessage msg) throws IOException {
        byte[] serializedMsg = JavaSerializationUtils.serialize((Serializable)msg);
        if (serializedMsg.length > this.maxMsgSize) {
            throw new HyracksDataException("Message exceded maximum size");
        }
        ByteBuffer msgBuffer = this.messagingFramePool.get();
        if (msgBuffer == null) {
            throw new HyracksDataException("Could not get an empty buffer");
        }
        msgBuffer.clear();
        msgBuffer.put(serializedMsg);
        msgBuffer.flip();
        ccb.getWriteInterface().getFullBufferAcceptor().accept(msgBuffer);
    }

    private class MessageDeliveryService
    implements Runnable {
        private MessageDeliveryService() {
        }

        @Override
        public void run() {
            while (true) {
                IApplicationMessage msg = null;
                try {
                    msg = (IApplicationMessage)NCMessageBroker.this.receivedMsgsQ.take();
                    NCMessageBroker.this.receivedMessage((IMessage)msg, null);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.WARNING) && msg != null) {
                        LOGGER.log(Level.WARNING, "Could not process message : " + msg, e);
                        continue;
                    }
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "Could not process message", e);
                    continue;
                }
                break;
            }
        }
    }
}

