/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hyracks.bootstrap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.api.IClusterEventsSubscriber;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.api.IClusterManagementWorkResponse;
import org.apache.asterix.common.config.ClusterProperties;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.asterix.hyracks.bootstrap.ClusterWorkExecutor;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.cluster.AddNodeWork;
import org.apache.asterix.metadata.cluster.AddNodeWorkResponse;
import org.apache.asterix.metadata.cluster.ClusterManagerProvider;
import org.apache.asterix.metadata.cluster.RemoveNodeWork;
import org.apache.asterix.metadata.cluster.RemoveNodeWorkResponse;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.hyracks.api.application.IClusterLifecycleListener;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.exceptions.HyracksException;

public class ClusterLifecycleListener
implements IClusterLifecycleListener {
    private static final Logger LOGGER = Logger.getLogger(ClusterLifecycleListener.class.getName());
    private static final LinkedBlockingQueue<Set<IClusterManagementWork>> workRequestQueue = new LinkedBlockingQueue();
    private static ClusterWorkExecutor eventHandler = new ClusterWorkExecutor(workRequestQueue);
    private static List<IClusterManagementWorkResponse> pendingWorkResponses = new ArrayList<IClusterManagementWorkResponse>();
    public static ClusterLifecycleListener INSTANCE = new ClusterLifecycleListener();

    private ClusterLifecycleListener() {
        Thread t = new Thread(eventHandler);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Starting cluster event handler");
        }
        t.start();
    }

    public void notifyNodeJoin(String nodeId, Map<IOption, Object> ncConfiguration) throws HyracksException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("NC: " + nodeId + " joined");
        }
        ClusterStateManager.INSTANCE.addNCConfiguration(nodeId, ncConfiguration);
        if (!ClusterStateManager.INSTANCE.isMetadataNodeActive()) {
            MetadataManager.INSTANCE.rebindMetadataNode();
        }
        HashSet<String> nodeAddition = new HashSet<String>();
        nodeAddition.add(nodeId);
        this.updateProgress(IClusterLifecycleListener.ClusterEventType.NODE_JOIN, nodeAddition);
        Set subscribers = ClusterManagerProvider.getClusterManager().getRegisteredClusterEventSubscribers();
        HashSet<IClusterManagementWork> work = new HashSet<IClusterManagementWork>();
        for (IClusterEventsSubscriber sub : subscribers) {
            Set workRequest = sub.notifyNodeJoin(nodeId);
            work.addAll(workRequest);
        }
        if (!work.isEmpty()) {
            this.executeWorkSet(work);
        }
    }

    public void notifyNodeFailure(Collection<String> deadNodeIds) throws HyracksException {
        for (String deadNode : deadNodeIds) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("NC: " + deadNode + " left");
            }
            ClusterStateManager.INSTANCE.removeNCConfiguration(deadNode);
            if (ClusterStateManager.INSTANCE.isMetadataNodeActive()) continue;
            MetadataManager.INSTANCE.rebindMetadataNode();
        }
        this.updateProgress(IClusterLifecycleListener.ClusterEventType.NODE_FAILURE, deadNodeIds);
        Set subscribers = ClusterManagerProvider.getClusterManager().getRegisteredClusterEventSubscribers();
        HashSet<IClusterManagementWork> work = new HashSet<IClusterManagementWork>();
        for (IClusterEventsSubscriber sub : subscribers) {
            Set workRequest = sub.notifyNodeFailure(deadNodeIds);
            work.addAll(workRequest);
        }
        if (!work.isEmpty()) {
            this.executeWorkSet(work);
        }
    }

    private void updateProgress(IClusterLifecycleListener.ClusterEventType eventType, Collection<String> nodeIds) {
        ArrayList<IClusterManagementWorkResponse> completedResponses = new ArrayList<IClusterManagementWorkResponse>();
        boolean isComplete = false;
        for (IClusterManagementWorkResponse resp : pendingWorkResponses) {
            switch (eventType) {
                case NODE_FAILURE: {
                    isComplete = ((RemoveNodeWorkResponse)resp).updateProgress(nodeIds);
                    if (!isComplete) break;
                    resp.setStatus(IClusterManagementWorkResponse.Status.SUCCESS);
                    resp.getWork().getSourceSubscriber().notifyRequestCompletion(resp);
                    completedResponses.add(resp);
                    break;
                }
                case NODE_JOIN: {
                    isComplete = ((AddNodeWorkResponse)resp).updateProgress(nodeIds.iterator().next());
                    if (!isComplete) break;
                    resp.setStatus(IClusterManagementWorkResponse.Status.SUCCESS);
                    resp.getWork().getSourceSubscriber().notifyRequestCompletion(resp);
                    completedResponses.add(resp);
                }
            }
        }
        pendingWorkResponses.removeAll(completedResponses);
    }

    private void executeWorkSet(Set<IClusterManagementWork> workSet) {
        int nodesToAdd = 0;
        HashSet nodesToRemove = new HashSet();
        HashSet<AddNodeWork> nodeAdditionRequests = new HashSet<AddNodeWork>();
        HashSet<IClusterManagementWork> nodeRemovalRequests = new HashSet<IClusterManagementWork>();
        for (IClusterManagementWork w : workSet) {
            switch (w.getClusterManagementWorkType()) {
                case ADD_NODE: {
                    if (nodesToAdd < ((AddNodeWork)w).getNumberOfNodesRequested()) {
                        nodesToAdd = ((AddNodeWork)w).getNumberOfNodesRequested();
                    }
                    nodeAdditionRequests.add((AddNodeWork)w);
                    break;
                }
                case REMOVE_NODE: {
                    nodesToRemove.addAll(((RemoveNodeWork)w).getNodesToBeRemoved());
                    nodeRemovalRequests.add(w);
                    RemoveNodeWorkResponse response = new RemoveNodeWorkResponse((RemoveNodeWork)w, IClusterManagementWorkResponse.Status.IN_PROGRESS);
                    pendingWorkResponses.add((IClusterManagementWorkResponse)response);
                }
            }
        }
        ArrayList<String> addedNodes = new ArrayList<String>();
        String asterixInstanceName = ClusterProperties.INSTANCE.getCluster().getInstanceName();
        for (int i = 0; i < nodesToAdd; ++i) {
            Node node = ClusterStateManager.INSTANCE.getAvailableSubstitutionNode();
            if (node != null) {
                try {
                    ClusterManagerProvider.getClusterManager().addNode(node);
                    addedNodes.add(asterixInstanceName + "_" + node.getId());
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Added NC at:" + node.getId());
                }
                catch (AsterixException e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Unable to add NC at:" + node.getId());
                    }
                    e.printStackTrace();
                }
                continue;
            }
            if (!LOGGER.isLoggable(Level.WARNING)) continue;
            LOGGER.warning("Unable to add NC: no more available nodes");
        }
        for (AddNodeWork w : nodeAdditionRequests) {
            AddNodeWorkResponse response;
            int n = w.getNumberOfNodesRequested();
            ArrayList nodesToBeAddedForWork = new ArrayList();
            for (int i = 0; i < n && i < addedNodes.size(); ++i) {
                nodesToBeAddedForWork.add(addedNodes.get(i));
            }
            if (nodesToBeAddedForWork.isEmpty()) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Unable to satisfy request by " + w);
                }
                response = new AddNodeWorkResponse(w, nodesToBeAddedForWork);
                response.setStatus(IClusterManagementWorkResponse.Status.FAILURE);
                w.getSourceSubscriber().notifyRequestCompletion((IClusterManagementWorkResponse)response);
                continue;
            }
            response = new AddNodeWorkResponse(w, nodesToBeAddedForWork);
            pendingWorkResponses.add((IClusterManagementWorkResponse)response);
        }
    }
}

