/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.drivers;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import org.apache.asterix.api.common.AsterixHyracksIntegrationUtil;
import org.apache.asterix.api.java.AsterixJavaClient;
import org.apache.asterix.app.translator.DefaultStatementExecutorFactory;
import org.apache.asterix.compiler.provider.AqlCompilationProvider;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.file.StorageComponentProvider;
import org.apache.commons.io.FileUtils;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class AsterixCLI {
    private static AsterixHyracksIntegrationUtil integrationUtil = new AsterixHyracksIntegrationUtil();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        parser.parseArgument(args);
        AqlCompilationProvider compilationProvider = new AqlCompilationProvider();
        AsterixCLI.setUp(options);
        try {
            for (String queryFile : options.args) {
                FileReader in = new FileReader(queryFile);
                AsterixJavaClient ajc = new AsterixJavaClient(integrationUtil.getHyracksClientConnection(), in, (ILangCompilationProvider)compilationProvider, new DefaultStatementExecutorFactory(), new StorageComponentProvider());
                try {
                    ajc.compile(true, false, false, false, false, true, false);
                }
                finally {
                    ((Reader)in).close();
                }
                ajc.execute();
            }
        }
        finally {
            AsterixCLI.tearDown();
        }
        System.exit(0);
    }

    public static void setUp(Options options) throws Exception {
        System.setProperty("AsterixConfigFileName", options.properties);
        File outdir = new File(options.outputFolder);
        outdir.mkdirs();
        File log = new File("asterix_logs");
        if (log.exists()) {
            FileUtils.deleteDirectory((File)log);
        }
        File lsn = new File("last_checkpoint_lsn");
        lsn.deleteOnExit();
        integrationUtil.init(false);
    }

    public static void tearDown() throws Exception {
        integrationUtil.deinit(false);
    }

    private static class Options {
        @Option(name="-properties", usage="Name of properties file", required=true)
        public String properties;
        @Option(name="-output", usage="Output folder to place results", required=true)
        public String outputFolder;
        @Argument(usage="AQL Files to run", multiValued=true, required=true)
        public List<String> args;

        private Options() {
        }
    }
}

