/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.replication;

import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.app.replication.AutoFaultToleranceStrategy;
import org.apache.asterix.app.replication.MetadataNodeFaultToleranceStrategy;
import org.apache.asterix.app.replication.NoFaultToleranceStrategy;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.asterix.common.replication.IFaultToleranceStrategy;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.event.schema.cluster.Cluster;

public class FaultToleranceStrategyFactory {
    private static final Map<String, Class<? extends IFaultToleranceStrategy>> BUILT_IN_FAULT_TOLERANCE_STRATEGY = new HashMap<String, Class<? extends IFaultToleranceStrategy>>();

    private FaultToleranceStrategyFactory() {
        throw new AssertionError();
    }

    public static IFaultToleranceStrategy create(Cluster cluster, IReplicationStrategy repStrategy, ICCMessageBroker messageBroker) {
        boolean highAvailabilityEnabled;
        boolean bl = highAvailabilityEnabled = cluster.getHighAvailability() != null && cluster.getHighAvailability().getEnabled() != null && Boolean.valueOf(cluster.getHighAvailability().getEnabled()) != false;
        if (!highAvailabilityEnabled || cluster.getHighAvailability().getFaultTolerance() == null || cluster.getHighAvailability().getFaultTolerance().getStrategy() == null) {
            return new NoFaultToleranceStrategy().from(repStrategy, messageBroker);
        }
        String strategyName = cluster.getHighAvailability().getFaultTolerance().getStrategy().toLowerCase();
        if (!BUILT_IN_FAULT_TOLERANCE_STRATEGY.containsKey(strategyName)) {
            throw new IllegalArgumentException(String.format("Unsupported Replication Strategy. Available types: %s", BUILT_IN_FAULT_TOLERANCE_STRATEGY.keySet().toString()));
        }
        Class<? extends IFaultToleranceStrategy> clazz = BUILT_IN_FAULT_TOLERANCE_STRATEGY.get(strategyName);
        try {
            return clazz.newInstance().from(repStrategy, messageBroker);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        BUILT_IN_FAULT_TOLERANCE_STRATEGY.put("no_fault_tolerance", NoFaultToleranceStrategy.class);
        BUILT_IN_FAULT_TOLERANCE_STRATEGY.put("metadata_node", MetadataNodeFaultToleranceStrategy.class);
        BUILT_IN_FAULT_TOLERANCE_STRATEGY.put("auto", AutoFaultToleranceStrategy.class);
    }
}

