/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc;

import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.apache.asterix.app.nc.RecoveryManager;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.config.TransactionProperties;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.transactions.Checkpoint;
import org.apache.asterix.common.transactions.CheckpointProperties;
import org.apache.asterix.common.transactions.IAppRuntimeContextProvider;
import org.apache.asterix.common.transactions.ICheckpointManager;
import org.apache.asterix.common.transactions.ILockManager;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.common.transactions.ITransactionManager;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.transaction.management.service.locking.ConcurrentLockManager;
import org.apache.asterix.transaction.management.service.logging.LogManager;
import org.apache.asterix.transaction.management.service.logging.LogManagerWithReplication;
import org.apache.asterix.transaction.management.service.recovery.CheckpointManagerFactory;
import org.apache.asterix.transaction.management.service.transaction.TransactionManager;
import org.apache.hyracks.api.application.INCServiceContext;

public class TransactionSubsystem
implements ITransactionSubsystem {
    private final String id;
    private final ILogManager logManager;
    private final ILockManager lockManager;
    private final ITransactionManager transactionManager;
    private final IRecoveryManager recoveryManager;
    private final IAppRuntimeContextProvider asterixAppRuntimeContextProvider;
    private final TransactionProperties txnProperties;
    private final ICheckpointManager checkpointManager;
    private long profilerEntityCommitLogCount = 0L;
    private EntityCommitProfiler ecp;

    public TransactionSubsystem(INCServiceContext serviceCtx, String id, IAppRuntimeContextProvider asterixAppRuntimeContextProvider, TransactionProperties txnProperties) throws ACIDException {
        this.asterixAppRuntimeContextProvider = asterixAppRuntimeContextProvider;
        this.id = id;
        this.txnProperties = txnProperties;
        this.transactionManager = new TransactionManager((ITransactionSubsystem)this);
        this.lockManager = new ConcurrentLockManager(txnProperties.getLockManagerShrinkTimer());
        ReplicationProperties repProperties = asterixAppRuntimeContextProvider.getAppContext().getReplicationProperties();
        IReplicationStrategy replicationStrategy = repProperties.getReplicationStrategy();
        boolean replicationEnabled = repProperties.isParticipant(id);
        CheckpointProperties checkpointProperties = new CheckpointProperties(txnProperties, id);
        this.checkpointManager = CheckpointManagerFactory.create((ITransactionSubsystem)this, (CheckpointProperties)checkpointProperties, (boolean)replicationEnabled);
        Checkpoint latestCheckpoint = this.checkpointManager.getLatest();
        if (latestCheckpoint != null && latestCheckpoint.getStorageVersion() != 6) {
            throw new IllegalStateException(String.format("Storage version mismatch. Current version (%s). On disk version: (%s)", latestCheckpoint.getStorageVersion(), 6));
        }
        this.logManager = replicationEnabled ? new LogManagerWithReplication((ITransactionSubsystem)this, replicationStrategy) : new LogManager((ITransactionSubsystem)this);
        this.recoveryManager = new RecoveryManager(this, serviceCtx);
        if (this.txnProperties.isCommitProfilerEnabled()) {
            this.ecp = new EntityCommitProfiler(this, this.txnProperties.getCommitProfilerReportInterval());
            this.getAsterixAppRuntimeContextProvider().getThreadExecutor().submit((Callable)this.ecp);
        }
    }

    public ILogManager getLogManager() {
        return this.logManager;
    }

    public ILockManager getLockManager() {
        return this.lockManager;
    }

    public ITransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public IRecoveryManager getRecoveryManager() {
        return this.recoveryManager;
    }

    public IAppRuntimeContextProvider getAsterixAppRuntimeContextProvider() {
        return this.asterixAppRuntimeContextProvider;
    }

    public TransactionProperties getTransactionProperties() {
        return this.txnProperties;
    }

    public String getId() {
        return this.id;
    }

    public void incrementEntityCommitCount() {
        ++this.profilerEntityCommitLogCount;
    }

    public ICheckpointManager getCheckpointManager() {
        return this.checkpointManager;
    }

    static class EntityCommitProfiler
    implements Callable<Boolean> {
        private static final Logger LOGGER = Logger.getLogger(EntityCommitProfiler.class.getName());
        private final long reportIntervalInMillisec;
        private long lastEntityCommitCount;
        private int reportIntervalInSeconds;
        private TransactionSubsystem txnSubsystem;
        private boolean firstReport = true;
        private long startTimeStamp = 0L;
        private long reportRound = 1L;

        public EntityCommitProfiler(TransactionSubsystem txnSubsystem, int reportIntervalInSeconds) {
            Thread.currentThread().setName("EntityCommitProfiler-Thread");
            this.txnSubsystem = txnSubsystem;
            this.reportIntervalInSeconds = reportIntervalInSeconds;
            this.reportIntervalInMillisec = (long)reportIntervalInSeconds * 1000L;
            this.lastEntityCommitCount = txnSubsystem.profilerEntityCommitLogCount;
        }

        @Override
        public Boolean call() throws Exception {
            while (true) {
                Thread.sleep(this.reportIntervalInMillisec);
                if (this.txnSubsystem.profilerEntityCommitLogCount <= 0L) continue;
                if (this.firstReport) {
                    this.startTimeStamp = System.currentTimeMillis();
                    this.firstReport = false;
                }
                this.outputCount();
            }
        }

        private void outputCount() {
            long currentTimeStamp = System.currentTimeMillis();
            long currentEntityCommitCount = this.txnSubsystem.profilerEntityCommitLogCount;
            LOGGER.severe("EntityCommitProfiler ReportRound[" + this.reportRound + "], AbsoluteTimeStamp[" + currentTimeStamp + "], ActualRelativeTimeStamp[" + (currentTimeStamp - this.startTimeStamp) + "], ExpectedRelativeTimeStamp[" + (long)this.reportIntervalInSeconds * this.reportRound + "], IIPS[" + (currentEntityCommitCount - this.lastEntityCommitCount) / (long)this.reportIntervalInSeconds + "], IPS[" + currentEntityCommitCount / (this.reportRound * (long)this.reportIntervalInSeconds) + "]");
            this.lastEntityCommitCount = currentEntityCommitCount;
            ++this.reportRound;
        }
    }
}

