/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.cc;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.asterix.common.transactions.IResourceIdManager;
import org.apache.asterix.runtime.utils.ClusterStateManager;

public class ResourceIdManager
implements IResourceIdManager {
    private final AtomicLong globalResourceId = new AtomicLong();
    private volatile Set<String> reportedNodes = new HashSet<String>();
    private volatile boolean allReported = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createResourceId() {
        if (!this.allReported) {
            ResourceIdManager resourceIdManager = this;
            synchronized (resourceIdManager) {
                if (!this.allReported) {
                    if (this.reportedNodes.size() < ClusterStateManager.getNumberOfNodes()) {
                        return -1L;
                    }
                    this.reportedNodes = null;
                    this.allReported = true;
                }
            }
        }
        return this.globalResourceId.incrementAndGet();
    }

    public synchronized boolean reported(String nodeId) {
        return this.allReported || this.reportedNodes.contains(nodeId);
    }

    public synchronized void report(String nodeId, long maxResourceId) {
        if (!this.allReported) {
            this.globalResourceId.set(Math.max(maxResourceId, this.globalResourceId.get()));
            this.reportedNodes.add(nodeId);
            if (this.reportedNodes.size() == ClusterStateManager.getNumberOfNodes()) {
                this.reportedNodes = null;
                this.allReported = true;
            }
        }
    }
}

