/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.cc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.asterix.algebra.base.ILangExtension;
import org.apache.asterix.algebra.extension.IAlgebraExtensionManager;
import org.apache.asterix.app.cc.IStatementExecutorExtension;
import org.apache.asterix.app.translator.DefaultStatementExecutorFactory;
import org.apache.asterix.common.api.ExtensionId;
import org.apache.asterix.common.api.IExtension;
import org.apache.asterix.common.config.AsterixExtension;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.compiler.provider.AqlCompilationProvider;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.compiler.provider.SqlppCompilationProvider;
import org.apache.asterix.translator.IStatementExecutorFactory;
import org.apache.asterix.utils.ExtensionUtil;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class CCExtensionManager
implements IAlgebraExtensionManager {
    private final Map<ExtensionId, IExtension> extensions = new HashMap<ExtensionId, IExtension>();
    private final IStatementExecutorExtension statementExecutorExtension;
    private final ILangCompilationProvider aqlCompilationProvider;
    private final ILangCompilationProvider sqlppCompilationProvider;
    private transient IStatementExecutorFactory statementExecutorFactory;

    public CCExtensionManager(List<AsterixExtension> list) throws InstantiationException, IllegalAccessException, ClassNotFoundException, HyracksDataException {
        Pair<ExtensionId, ILangCompilationProvider> aqlcp = null;
        Pair<ExtensionId, ILangCompilationProvider> sqlppcp = null;
        IStatementExecutorExtension see = null;
        if (list != null) {
            for (AsterixExtension extensionConf : list) {
                IExtension extension = (IExtension)Class.forName(extensionConf.getClassName()).newInstance();
                extension.configure(extensionConf.getArgs());
                if (this.extensions.containsKey(extension.getId())) {
                    throw new RuntimeDataException(4001, new Serializable[]{extension.getId()});
                }
                this.extensions.put(extension.getId(), extension);
                switch (extension.getExtensionKind()) {
                    case STATEMENT_EXECUTOR: {
                        see = ExtensionUtil.extendStatementExecutor(see, (IStatementExecutorExtension)extension);
                        break;
                    }
                    case LANG: {
                        ILangExtension le = (ILangExtension)extension;
                        aqlcp = ExtensionUtil.extendLangCompilationProvider(ILangExtension.Language.AQL, aqlcp, le);
                        sqlppcp = ExtensionUtil.extendLangCompilationProvider(ILangExtension.Language.SQLPP, sqlppcp, le);
                        break;
                    }
                }
            }
        }
        this.statementExecutorExtension = see;
        this.aqlCompilationProvider = aqlcp == null ? new AqlCompilationProvider() : (ILangCompilationProvider)aqlcp.second;
        this.sqlppCompilationProvider = sqlppcp == null ? new SqlppCompilationProvider() : (ILangCompilationProvider)sqlppcp.second;
    }

    @Deprecated
    public IStatementExecutorFactory getQueryTranslatorFactory() {
        return this.getStatementExecutorFactory(null);
    }

    public IStatementExecutorFactory getStatementExecutorFactory(ExecutorService executorService) {
        if (this.statementExecutorFactory == null) {
            this.statementExecutorFactory = this.statementExecutorExtension == null ? new DefaultStatementExecutorFactory(executorService) : this.statementExecutorExtension.getStatementExecutorFactory(executorService);
        }
        return this.statementExecutorFactory;
    }

    public ILangCompilationProvider getAqlCompilationProvider() {
        return this.aqlCompilationProvider;
    }

    public ILangCompilationProvider getSqlppCompilationProvider() {
        return this.sqlppCompilationProvider;
    }
}

