/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.java;

import java.io.PrintWriter;
import java.io.Reader;
import java.util.List;
import org.apache.asterix.api.common.APIFramework;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.utils.Job;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.IStatementExecutorFactory;
import org.apache.asterix.translator.SessionConfig;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.job.JobSpecification;

public class AsterixJavaClient {
    private IHyracksClientConnection hcc;
    private Reader queryText;
    private PrintWriter writer;
    private Job[] dmlJobs;
    private JobSpecification queryJobSpec;
    private final ILangCompilationProvider compilationProvider;
    private final IParserFactory parserFactory;
    private final APIFramework apiFramework;
    private final IStatementExecutorFactory statementExecutorFactory;
    private final IStorageComponentProvider storageComponentProvider;

    public AsterixJavaClient(IHyracksClientConnection hcc, Reader queryText, PrintWriter writer, ILangCompilationProvider compilationProvider, IStatementExecutorFactory statementExecutorFactory, IStorageComponentProvider storageComponentProvider) {
        this.hcc = hcc;
        this.queryText = queryText;
        this.writer = writer;
        this.compilationProvider = compilationProvider;
        this.statementExecutorFactory = statementExecutorFactory;
        this.storageComponentProvider = storageComponentProvider;
        this.apiFramework = new APIFramework(compilationProvider);
        this.parserFactory = compilationProvider.getParserFactory();
    }

    public AsterixJavaClient(IHyracksClientConnection hcc, Reader queryText, ILangCompilationProvider compilationProvider, IStatementExecutorFactory statementExecutorFactory, IStorageComponentProvider storageComponentProvider) {
        this(hcc, queryText, new PrintWriter(System.out, true), compilationProvider, statementExecutorFactory, storageComponentProvider);
    }

    public void compile() throws Exception {
        this.compile(true, false, false, false, false, false, false);
    }

    public void compile(boolean optimize, boolean printRewrittenExpressions, boolean printLogicalPlan, boolean printOptimizedPlan, boolean printPhysicalOpsOnly, boolean generateBinaryRuntime, boolean printJob) throws Exception {
        int ch;
        this.queryJobSpec = null;
        this.dmlJobs = null;
        if (this.queryText == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        while ((ch = this.queryText.read()) != -1) {
            builder.append((char)ch);
        }
        IParser parser = this.parserFactory.createParser(builder.toString());
        List statements = parser.parse();
        MetadataManager.INSTANCE.init();
        SessionConfig conf = new SessionConfig(this.writer, SessionConfig.OutputFormat.ADM, optimize, true, generateBinaryRuntime);
        conf.setOOBData(false, printRewrittenExpressions, printLogicalPlan, printOptimizedPlan, printJob);
        if (printPhysicalOpsOnly) {
            conf.set("format-only-physical-ops", true);
        }
        IStatementExecutor translator = this.statementExecutorFactory.create(statements, conf, this.compilationProvider, this.storageComponentProvider);
        translator.compileAndExecute(this.hcc, null, IStatementExecutor.ResultDelivery.IMMEDIATE, new IStatementExecutor.Stats());
        this.writer.flush();
    }

    public void execute() throws Exception {
        if (this.dmlJobs != null) {
            this.apiFramework.executeJobArray(this.hcc, this.dmlJobs, this.writer);
        }
        if (this.queryJobSpec != null) {
            this.apiFramework.executeJobArray(this.hcc, new JobSpecification[]{this.queryJobSpec}, this.writer);
        }
    }
}

