/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.common;

import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.hyracks.bootstrap.CCApplication;
import org.apache.asterix.hyracks.bootstrap.NCApplication;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.application.ICCApplication;
import org.apache.hyracks.api.application.INCApplication;
import org.apache.hyracks.api.client.HyracksConnection;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IConfigManager;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.nc.NodeControllerService;

public class AsterixHyracksIntegrationUtil {
    private static final String IO_DIR_KEY = "java.io.tmpdir";
    public static final int DEFAULT_HYRACKS_CC_CLIENT_PORT = 1098;
    public static final int DEFAULT_HYRACKS_CC_CLUSTER_PORT = 1099;
    public ClusterControllerService cc;
    public NodeControllerService[] ncs;
    public IHyracksClientConnection hcc;
    private ConfigManager configManager;
    private List<String> nodeNames;

    public void init(boolean deleteOldInstanceData) throws Exception {
        this.ncs = new NodeControllerService[0];
        ICCApplication ccApplication = this.createCCApplication();
        this.configManager = new ConfigManager();
        ccApplication.registerConfig((IConfigManager)this.configManager);
        CCConfig ccConfig = this.createCCConfig(this.configManager);
        this.cc = new ClusterControllerService(ccConfig, ccApplication);
        this.nodeNames = ccConfig.getConfigManager().getNodeNames();
        if (deleteOldInstanceData) {
            this.deleteTransactionLogs();
            this.removeTestStorageFiles();
        }
        ArrayList ncConfigs = new ArrayList();
        this.nodeNames.forEach(nodeId -> ncConfigs.add(this.createNCConfig((String)nodeId, this.configManager)));
        PropertiesAccessor accessor = PropertiesAccessor.getInstance((IApplicationConfig)this.configManager.getAppConfig());
        ncConfigs.forEach(ncConfig1 -> this.fixupIODevices((NCConfig)ncConfig1, accessor));
        this.cc.start();
        this.nodeNames = ccConfig.getConfigManager().getNodeNames();
        ArrayList<NodeControllerService> nodeControllers = new ArrayList<NodeControllerService>();
        ArrayList<1> startupThreads = new ArrayList<1>();
        for (NCConfig nCConfig : ncConfigs) {
            INCApplication ncApplication = this.createNCApplication();
            final NodeControllerService nodeControllerService = new NodeControllerService(nCConfig, ncApplication);
            nodeControllers.add(nodeControllerService);
            Thread ncStartThread = new Thread("IntegrationUtil-" + nCConfig.getNodeId()){

                @Override
                public void run() {
                    try {
                        nodeControllerService.start();
                    }
                    catch (Exception e) {
                        LoggerHolder.LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            };
            ncStartThread.start();
            startupThreads.add(ncStartThread);
        }
        for (Thread thread : startupThreads) {
            thread.join();
        }
        for (NCConfig nCConfig : ncConfigs) {
            for (String ioDevice : nCConfig.getIODevices()) {
                if (new File(ioDevice).isAbsolute()) continue;
                throw new IllegalStateException("iodevice not absolute: " + ioDevice);
            }
        }
        ClusterStateManager.INSTANCE.waitForState(IClusterManagementWork.ClusterState.ACTIVE);
        this.hcc = new HyracksConnection(this.cc.getConfig().getClientListenAddress(), this.cc.getConfig().getClientListenPort());
        this.ncs = nodeControllers.toArray(new NodeControllerService[nodeControllers.size()]);
    }

    protected CCConfig createCCConfig(ConfigManager configManager) throws IOException {
        CCConfig ccConfig = new CCConfig(configManager);
        ccConfig.setClusterListenAddress(Inet4Address.getLoopbackAddress().getHostAddress());
        ccConfig.setClientListenAddress(Inet4Address.getLoopbackAddress().getHostAddress());
        ccConfig.setClientListenPort(1098);
        ccConfig.setClusterListenPort(1099);
        ccConfig.setResultTTL(120000L);
        ccConfig.setResultSweepThreshold(1000L);
        return ccConfig;
    }

    protected ICCApplication createCCApplication() {
        return new CCApplication();
    }

    protected NCConfig createNCConfig(String ncName, ConfigManager configManager) {
        NCConfig ncConfig = new NCConfig(ncName, configManager);
        ncConfig.setClusterAddress("localhost");
        ncConfig.setClusterPort(1099);
        ncConfig.setClusterListenAddress(Inet4Address.getLoopbackAddress().getHostAddress());
        ncConfig.setDataListenAddress(Inet4Address.getLoopbackAddress().getHostAddress());
        ncConfig.setResultListenAddress(Inet4Address.getLoopbackAddress().getHostAddress());
        ncConfig.setMessagingListenAddress(Inet4Address.getLoopbackAddress().getHostAddress());
        ncConfig.setResultTTL(120000L);
        ncConfig.setResultSweepThreshold(1000L);
        ncConfig.setVirtualNC(true);
        return ncConfig;
    }

    protected INCApplication createNCApplication() {
        return new NCApplication();
    }

    private NCConfig fixupIODevices(NCConfig ncConfig, PropertiesAccessor accessor) {
        String tempPath = System.getProperty(IO_DIR_KEY);
        if (tempPath.endsWith(File.separator)) {
            tempPath = tempPath.substring(0, tempPath.length() - 1);
        }
        LoggerHolder.LOGGER.info("Using the temp path: " + tempPath);
        String[] nodeStores = (String[])accessor.getStores().get(ncConfig.getNodeId());
        if (nodeStores == null) {
            throw new IllegalStateException("Couldn't find stores for NC: " + ncConfig.getNodeId());
        }
        String tempDirPath = System.getProperty(IO_DIR_KEY);
        if (!tempDirPath.endsWith(File.separator)) {
            tempDirPath = tempDirPath + File.separator;
        }
        ArrayList<String> ioDevices = new ArrayList<String>();
        for (String nodeStore : nodeStores) {
            String iodevicePath = tempDirPath + ncConfig.getNodeId() + File.separator + nodeStore;
            File ioDeviceDir = new File(iodevicePath);
            ioDeviceDir.mkdirs();
            ioDevices.add(iodevicePath);
        }
        this.configManager.set(ncConfig.getNodeId(), (IOption)NCConfig.Option.IODEVICES, (Object)ioDevices.toArray(new String[0]));
        return ncConfig;
    }

    public IHyracksClientConnection getHyracksClientConnection() {
        return this.hcc;
    }

    public void deinit(boolean deleteOldInstanceData) throws Exception {
        ArrayList<2> stopNCThreads = new ArrayList<2>();
        for (final NodeControllerService nodeControllerService : this.ncs) {
            if (nodeControllerService == null) continue;
            Thread ncStopThread = new Thread(){

                @Override
                public void run() {
                    try {
                        nodeControllerService.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            stopNCThreads.add(ncStopThread);
            ncStopThread.start();
        }
        for (Thread thread : stopNCThreads) {
            thread.join();
        }
        if (this.cc != null) {
            this.cc.stop();
        }
        if (deleteOldInstanceData) {
            this.deleteTransactionLogs();
            this.removeTestStorageFiles();
        }
    }

    public void runJob(JobSpecification spec) throws Exception {
        GlobalConfig.ASTERIX_LOGGER.info(spec.toJSON().toString());
        JobId jobId = this.hcc.startJob(spec, EnumSet.of(JobFlag.PROFILE_RUNTIME));
        GlobalConfig.ASTERIX_LOGGER.info(jobId.toString());
        this.hcc.waitForCompletion(jobId);
    }

    public void removeTestStorageFiles() {
        File dir = new File(System.getProperty(IO_DIR_KEY));
        for (String ncName : this.nodeNames) {
            File ncDir = new File(dir, ncName);
            FileUtils.deleteQuietly((File)ncDir);
        }
    }

    private void deleteTransactionLogs() throws IOException, AsterixException {
        for (String ncId : this.nodeNames) {
            File log = new File((String)PropertiesAccessor.getInstance((IApplicationConfig)this.configManager.getAppConfig()).getTransactionLogDirs().get(ncId));
            if (!log.exists()) continue;
            FileUtils.deleteDirectory((File)log);
        }
    }

    public static void main(String[] args) throws Exception {
        AsterixHyracksIntegrationUtil integrationUtil = new AsterixHyracksIntegrationUtil();
        try {
            integrationUtil.run(Boolean.getBoolean("cleanup.start"), Boolean.getBoolean("cleanup.shutdown"));
        }
        catch (Exception e) {
            LoggerHolder.LOGGER.log(Level.WARNING, "Unexpected exception", e);
            System.exit(1);
        }
    }

    protected void run(boolean cleanupOnStart, final boolean cleanupOnShutdown) throws Exception {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    AsterixHyracksIntegrationUtil.this.deinit(cleanupOnShutdown);
                }
                catch (Exception e) {
                    LoggerHolder.LOGGER.log(Level.WARNING, "Unexpected exception on shutdown", e);
                }
            }
        });
        System.setProperty("AsterixConfigFileName", "asterix-build-configuration.xml");
        this.init(cleanupOnStart);
        while (true) {
            Thread.sleep(10000L);
        }
    }

    static class LoggerHolder {
        static final Logger LOGGER = Logger.getLogger(AsterixHyracksIntegrationUtil.class.getName());

        private LoggerHolder() {
        }
    }
}

