/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.buffercache;

import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IQueueInfo;

public class VirtualPage
implements ICachedPage {
    private final ReadWriteLock latch;
    private final int pageSize;
    private ByteBuffer buffer;
    private volatile long dpid;
    private int multiplier;
    private VirtualPage next;

    public VirtualPage(ByteBuffer buffer, int pageSize) {
        this.buffer = buffer;
        this.pageSize = pageSize;
        this.latch = new ReentrantReadWriteLock(true);
        this.dpid = -1L;
        this.next = null;
    }

    public void reset() {
        this.dpid = -1L;
        this.next = null;
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void acquireReadLatch() {
        this.latch.readLock().lock();
    }

    @Override
    public void releaseReadLatch() {
        this.latch.readLock().unlock();
    }

    @Override
    public void acquireWriteLatch() {
        this.latch.writeLock().lock();
    }

    @Override
    public void releaseWriteLatch(boolean markDirty) {
        this.latch.writeLock().unlock();
    }

    @Override
    public boolean confiscated() {
        return false;
    }

    @Override
    public IQueueInfo getQueueInfo() {
        return null;
    }

    @Override
    public void setQueueInfo(IQueueInfo queueInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getFrameSizeMultiplier() {
        return this.multiplier;
    }

    public void multiplier(int multiplier) {
        this.multiplier = multiplier;
    }

    public long dpid() {
        return this.dpid;
    }

    public void dpid(long dpid) {
        this.dpid = dpid;
    }

    public VirtualPage next() {
        return this.next;
    }

    public void next(VirtualPage next) {
        this.next = next;
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public void buffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }
}

