/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.buffercache;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.buffercache.BufferCache;
import org.apache.hyracks.storage.common.buffercache.CachedPage;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageWriter;

public class FIFOLocalWriter
implements IFIFOPageWriter {
    private static FIFOLocalWriter instance;
    private static boolean DEBUG;

    public static FIFOLocalWriter instance() {
        if (instance == null) {
            instance = new FIFOLocalWriter();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ICachedPage page, BufferCache bufferCache) throws HyracksDataException {
        CachedPage cPage = (CachedPage)page;
        try {
            bufferCache.write(cPage);
        }
        finally {
            bufferCache.returnPage(cPage);
            if (DEBUG) {
                System.out.println("[FIFO] Return page: " + cPage.cpid + "," + cPage.dpid);
            }
        }
    }

    @Override
    public void sync(int fileId, BufferCache bufferCache) throws HyracksDataException {
        bufferCache.force(fileId, true);
    }

    static {
        DEBUG = false;
    }
}

