/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.buffercache;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.hyracks.api.replication.IIOReplicationManager;
import org.apache.hyracks.storage.common.buffercache.AsyncFIFOPageQueueManager;
import org.apache.hyracks.storage.common.buffercache.CachedPage;
import org.apache.hyracks.storage.common.buffercache.FIFOLocalWriter;
import org.apache.hyracks.storage.common.buffercache.IBufferCacheInternal;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.ICachedPageInternal;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageQueue;
import org.apache.hyracks.storage.common.buffercache.IPageCleanerPolicy;
import org.apache.hyracks.storage.common.buffercache.IPageReplacementStrategy;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;
import org.apache.hyracks.storage.common.file.IFileMapManager;

public class BufferCache
implements IBufferCacheInternal,
ILifeCycleComponent {
    private static final Logger LOGGER = Logger.getLogger(BufferCache.class.getName());
    private static final int MAP_FACTOR = 3;
    private static final int MIN_CLEANED_COUNT_DIFF = 3;
    private static final int PIN_MAX_WAIT_TIME = 50;
    private static final int PIN_ATTEMPT_CYCLES_WARNING_THRESHOLD = 3;
    private static final int MAX_PIN_ATTEMPT_CYCLES = 1000;
    public static final boolean DEBUG = false;
    private final int pageSize;
    private final int maxOpenFiles;
    final IIOManager ioManager;
    private final CacheBucket[] pageMap;
    private final IPageReplacementStrategy pageReplacementStrategy;
    private final IPageCleanerPolicy pageCleanerPolicy;
    private final IFileMapManager fileMapManager;
    private final CleanerThread cleanerThread;
    private final Map<Integer, BufferedFileHandle> fileInfoMap;
    private final AsyncFIFOPageQueueManager fifoWriter;
    private final Queue<BufferCacheHeaderHelper> headerPageCache = new ConcurrentLinkedQueue<BufferCacheHeaderHelper>();
    private Level fileOpsLevel = Level.FINE;
    private ArrayList<CachedPage> confiscatedPages;
    private Lock confiscateLock;
    private HashMap<CachedPage, StackTraceElement[]> confiscatedPagesOwner;
    private ConcurrentHashMap<CachedPage, StackTraceElement[]> pinnedPageOwner;
    private IIOReplicationManager ioReplicationManager;
    private final List<ICachedPageInternal> cachedPages = new ArrayList<ICachedPageInternal>();
    private final AtomicLong masterPinCount = new AtomicLong();
    private boolean closed;

    public BufferCache(IIOManager ioManager, IPageReplacementStrategy pageReplacementStrategy, IPageCleanerPolicy pageCleanerPolicy, IFileMapManager fileMapManager, int maxOpenFiles, ThreadFactory threadFactory) {
        this.ioManager = ioManager;
        this.pageSize = pageReplacementStrategy.getPageSize();
        this.maxOpenFiles = maxOpenFiles;
        pageReplacementStrategy.setBufferCache(this);
        this.pageMap = new CacheBucket[pageReplacementStrategy.getMaxAllowedNumPages() * 3 + 1];
        for (int i = 0; i < this.pageMap.length; ++i) {
            this.pageMap[i] = new CacheBucket();
        }
        this.pageReplacementStrategy = pageReplacementStrategy;
        this.pageCleanerPolicy = pageCleanerPolicy;
        this.fileMapManager = fileMapManager;
        ExecutorService executor = Executors.newCachedThreadPool(threadFactory);
        this.fileInfoMap = new HashMap<Integer, BufferedFileHandle>();
        this.cleanerThread = new CleanerThread();
        executor.execute(this.cleanerThread);
        this.closed = false;
        this.fifoWriter = new AsyncFIFOPageQueueManager(this);
    }

    public BufferCache(IIOManager ioManager, IPageReplacementStrategy pageReplacementStrategy, IPageCleanerPolicy pageCleanerPolicy, IFileMapManager fileMapManager, int maxOpenFiles, ThreadFactory threadFactory, IIOReplicationManager ioReplicationManager) {
        this(ioManager, pageReplacementStrategy, pageCleanerPolicy, fileMapManager, maxOpenFiles, threadFactory);
        this.ioReplicationManager = ioReplicationManager;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getPageSizeWithHeader() {
        return this.pageSize + 8;
    }

    @Override
    public int getNumPages() {
        return this.pageReplacementStrategy.getMaxAllowedNumPages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pinSanityCheck(long dpid) throws HyracksDataException {
        BufferedFileHandle fInfo;
        if (this.closed) {
            throw new HyracksDataException("pin called on a closed cache");
        }
        int fileId = BufferedFileHandle.getFileId(dpid);
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            fInfo = this.fileInfoMap.get(fileId);
        }
        if (fInfo == null) {
            throw new HyracksDataException("pin called on a fileId " + fileId + " that has not been created.");
        }
        if (fInfo.getReferenceCount() <= 0) {
            throw new HyracksDataException("pin called on a fileId " + fileId + " that has not been opened.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedPage tryPin(long dpid) throws HyracksDataException {
        CachedPage cPage = null;
        int hash = this.hash(dpid);
        CacheBucket bucket = this.pageMap[hash];
        bucket.bucketLock.lock();
        try {
            cPage = bucket.cachedPage;
            while (cPage != null) {
                if (cPage.dpid == dpid) {
                    cPage.pinCount.incrementAndGet();
                    this.pageReplacementStrategy.notifyCachePageAccess(cPage);
                    CachedPage cachedPage = cPage;
                    return cachedPage;
                }
                cPage = cPage.next;
            }
        }
        finally {
            bucket.bucketLock.unlock();
        }
        return cPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedPage pin(long dpid, boolean newPage) throws HyracksDataException {
        CachedPage cPage = this.findPage(dpid);
        if (!newPage) {
            CachedPage cachedPage = cPage;
            synchronized (cachedPage) {
                if (!cPage.valid) {
                    this.read(cPage);
                    cPage.valid = true;
                }
            }
        } else {
            cPage.valid = true;
        }
        this.pageReplacementStrategy.notifyCachePageAccess(cPage);
        return cPage;
    }

    private CachedPage findPage(long dpid) throws HyracksDataException {
        return (CachedPage)this.getPageLoop(dpid, -1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICachedPage findPageInner(long dpid) {
        CachedPage cPage;
        int hash = this.hash(dpid);
        CacheBucket bucket = this.pageMap[hash];
        bucket.bucketLock.lock();
        try {
            cPage = bucket.cachedPage;
            while (cPage != null) {
                if (cPage.dpid == dpid) {
                    cPage.pinCount.incrementAndGet();
                    CachedPage cachedPage = cPage;
                    return cachedPage;
                }
                cPage = cPage.next;
            }
        }
        finally {
            bucket.bucketLock.unlock();
        }
        CachedPage victim = (CachedPage)this.pageReplacementStrategy.findVictim();
        if (victim == null) {
            return null;
        }
        if (victim.dpid < 0L) {
            bucket.bucketLock.lock();
            try {
                if (!victim.pinCount.compareAndSet(0, 1)) {
                    ICachedPage iCachedPage = null;
                    return iCachedPage;
                }
                if (victim.dpid >= 0L) {
                    victim.pinCount.decrementAndGet();
                    ICachedPage iCachedPage = null;
                    return iCachedPage;
                }
                cPage = this.findTargetInBucket(dpid, bucket.cachedPage, victim);
                if (cPage != null) {
                    CachedPage cachedPage = cPage;
                    return cachedPage;
                }
                victim.reset(dpid);
                victim.next = bucket.cachedPage;
                bucket.cachedPage = victim;
            }
            finally {
                bucket.bucketLock.unlock();
            }
            return victim;
        }
        int victimHash = this.hash(victim.dpid);
        if (victimHash == hash) {
            bucket.bucketLock.lock();
            try {
                if (!victim.pinCount.compareAndSet(0, 1)) {
                    ICachedPage iCachedPage = null;
                    return iCachedPage;
                }
                if (victimHash != this.hash(victim.dpid)) {
                    victim.pinCount.decrementAndGet();
                    ICachedPage iCachedPage = null;
                    return iCachedPage;
                }
                cPage = this.findTargetInBucket(dpid, bucket.cachedPage, victim);
                if (cPage != null) {
                    CachedPage cachedPage = cPage;
                    return cachedPage;
                }
                victim.reset(dpid);
            }
            finally {
                bucket.bucketLock.unlock();
            }
            return victim;
        }
        CacheBucket victimBucket = this.pageMap[victimHash];
        if (victimHash < hash) {
            victimBucket.bucketLock.lock();
            bucket.bucketLock.lock();
        } else {
            bucket.bucketLock.lock();
            victimBucket.bucketLock.lock();
        }
        try {
            if (!victim.pinCount.compareAndSet(0, 1)) {
                ICachedPage iCachedPage = null;
                return iCachedPage;
            }
            if (victimHash != this.hash(victim.dpid)) {
                victim.pinCount.decrementAndGet();
                ICachedPage iCachedPage = null;
                return iCachedPage;
            }
            cPage = this.findTargetInBucket(dpid, bucket.cachedPage, victim);
            if (cPage != null) {
                CachedPage cachedPage = cPage;
                return cachedPage;
            }
            if (victimBucket.cachedPage == victim) {
                victimBucket.cachedPage = victim.next;
            } else {
                CachedPage victimPrev = victimBucket.cachedPage;
                while (victimPrev.next != victim) {
                    victimPrev = victimPrev.next;
                    if (victimPrev != null) continue;
                    throw new IllegalStateException();
                }
                victimPrev.next = victim.next;
            }
            victim.reset(dpid);
            victim.next = bucket.cachedPage;
            bucket.cachedPage = victim;
        }
        finally {
            victimBucket.bucketLock.unlock();
            bucket.bucketLock.unlock();
        }
        return victim;
    }

    private CachedPage findTargetInBucket(long dpid, CachedPage cPage, CachedPage victim) {
        while (cPage != null) {
            if (cPage.dpid == dpid) {
                cPage.pinCount.incrementAndGet();
                victim.pinCount.decrementAndGet();
                break;
            }
            cPage = cPage.next;
        }
        return cPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dumpState() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Buffer cache state\n");
        buffer.append("Page Size: ").append(this.pageSize).append('\n');
        buffer.append("Number of physical pages: ").append(this.pageReplacementStrategy.getMaxAllowedNumPages()).append('\n');
        buffer.append("Hash table size: ").append(this.pageMap.length).append('\n');
        buffer.append("Page Map:\n");
        buffer.append("cpid -> [fileId:pageId, pinCount, valid/invalid, confiscated/physical, dirty/clean]");
        int nCachedPages = 0;
        for (int i = 0; i < this.pageMap.length; ++i) {
            CacheBucket cb = this.pageMap[i];
            cb.bucketLock.lock();
            try {
                CachedPage cp = cb.cachedPage;
                if (cp == null) continue;
                buffer.append("   ").append(i).append('\n');
                while (cp != null) {
                    buffer.append("      ").append(cp.cpid).append(" -> [").append(BufferedFileHandle.getFileId(cp.dpid)).append(':').append(BufferedFileHandle.getPageId(cp.dpid)).append(", ").append(cp.pinCount.get()).append(", ").append(cp.valid ? "valid" : "invalid").append(", ").append(cp.confiscated.get() ? "confiscated" : "physical").append(", ").append(cp.dirty.get() ? "dirty" : "clean").append("]\n");
                    cp = cp.next;
                    ++nCachedPages;
                }
                continue;
            }
            finally {
                cb.bucketLock.unlock();
            }
        }
        buffer.append("Number of cached pages: ").append(nCachedPages).append('\n');
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClean() {
        LinkedList<Long> reachableDpids = new LinkedList<Long>();
        List<ICachedPageInternal> list = this.cachedPages;
        synchronized (list) {
            for (ICachedPageInternal internalPage : this.cachedPages) {
                CachedPage c = (CachedPage)internalPage;
                if (c.confiscated() || c.latch.getReadLockCount() != 0 || c.latch.getWriteHoldCount() != 0) {
                    return false;
                }
                if (!c.valid) continue;
                reachableDpids.add(c.dpid);
            }
        }
        for (Long l : reachableDpids) {
            if (this.canFindValidCachedPage(l)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canFindValidCachedPage(long dpid) {
        int hash = this.hash(dpid);
        CachedPage cPage = null;
        CacheBucket bucket = this.pageMap[hash];
        bucket.bucketLock.lock();
        try {
            cPage = bucket.cachedPage;
            while (cPage != null) {
                assert (bucket.cachedPage != ((CacheBucket)bucket).cachedPage.next);
                if (cPage.dpid == dpid) {
                    boolean bl = true;
                    return bl;
                }
                cPage = cPage.next;
            }
        }
        finally {
            bucket.bucketLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(CachedPage cPage) throws HyracksDataException {
        BufferedFileHandle fInfo = this.getFileInfo(cPage);
        cPage.buffer.clear();
        BufferCacheHeaderHelper header = this.checkoutHeaderHelper();
        try {
            long bytesRead = this.ioManager.syncRead(fInfo.getFileHandle(), this.getOffsetForPage(BufferedFileHandle.getPageId(cPage.dpid)), header.prepareRead());
            if (bytesRead != (long)this.getPageSizeWithHeader()) {
                if (bytesRead == -1L) {
                    return;
                }
                throw new HyracksDataException("Failed to read a complete page: " + bytesRead);
            }
            int totalPages = header.processRead(cPage);
            if (totalPages > 1) {
                this.pageReplacementStrategy.fixupCapacityOnLargeRead(cPage);
                cPage.buffer.position(this.pageSize);
                cPage.buffer.limit(totalPages * this.pageSize);
                this.ioManager.syncRead(fInfo.getFileHandle(), this.getOffsetForPage(cPage.getExtraBlockPageId()), cPage.buffer);
            }
        }
        finally {
            this.returnHeaderHelper(header);
        }
    }

    private long getOffsetForPage(long pageId) {
        return pageId * (long)this.getPageSizeWithHeader();
    }

    @Override
    public void resizePage(ICachedPage cPage, int totalPages, IExtraPageBlockHelper extraPageBlockHelper) throws HyracksDataException {
        this.pageReplacementStrategy.resizePage((ICachedPageInternal)cPage, totalPages, extraPageBlockHelper);
    }

    BufferedFileHandle getFileInfo(CachedPage cPage) throws HyracksDataException {
        return this.getFileInfo(BufferedFileHandle.getFileId(cPage.dpid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferedFileHandle getFileInfo(int fileId) throws HyracksDataException {
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            BufferedFileHandle fInfo = this.fileInfoMap.get(fileId);
            if (fInfo == null) {
                throw new HyracksDataException("No such file mapped");
            }
            return fInfo;
        }
    }

    private BufferCacheHeaderHelper checkoutHeaderHelper() {
        BufferCacheHeaderHelper helper = this.headerPageCache.poll();
        if (helper == null) {
            helper = new BufferCacheHeaderHelper(this.pageSize);
        }
        return helper;
    }

    private void returnHeaderHelper(BufferCacheHeaderHelper buffer) {
        this.headerPageCache.offer(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(CachedPage cPage) throws HyracksDataException {
        BufferedFileHandle fInfo;
        BufferedFileHandle bufferedFileHandle = fInfo = this.getFileInfo(cPage);
        synchronized (bufferedFileHandle) {
            if (!fInfo.fileHasBeenDeleted()) {
                ByteBuffer buf = cPage.buffer.duplicate();
                int totalPages = cPage.getFrameSizeMultiplier();
                int extraBlockPageId = cPage.getExtraBlockPageId();
                boolean contiguousLargePages = BufferedFileHandle.getPageId(cPage.dpid) + 1 == extraBlockPageId;
                BufferCacheHeaderHelper header = this.checkoutHeaderHelper();
                try {
                    buf.limit(contiguousLargePages ? this.pageSize * totalPages : this.pageSize);
                    buf.position(0);
                    long bytesWritten = this.ioManager.syncWrite(fInfo.getFileHandle(), this.getOffsetForPage(BufferedFileHandle.getPageId(cPage.dpid)), header.prepareWrite(cPage, buf));
                    if (bytesWritten != (long)((contiguousLargePages ? this.pageSize * (totalPages - 1) : 0) + this.getPageSizeWithHeader())) {
                        throw new HyracksDataException("Failed to write completely: " + bytesWritten);
                    }
                }
                finally {
                    this.returnHeaderHelper(header);
                }
                if (totalPages > 1 && !contiguousLargePages) {
                    buf.limit(totalPages * this.pageSize);
                    this.ioManager.syncWrite(fInfo.getFileHandle(), this.getOffsetForPage(extraBlockPageId), buf);
                }
                assert (buf.capacity() == this.pageSize * totalPages);
            }
        }
    }

    @Override
    public void unpin(ICachedPage page) throws HyracksDataException {
        if (this.closed) {
            throw new HyracksDataException("unpin called on a closed cache");
        }
        int pinCount = ((CachedPage)page).pinCount.decrementAndGet();
    }

    private int hash(long dpid) {
        int hashValue = (int)dpid ^ Integer.reverse((int)(dpid >>> 32)) >>> 1;
        return hashValue % this.pageMap.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedPageInternal getPage(int cpid) {
        List<ICachedPageInternal> list = this.cachedPages;
        synchronized (list) {
            return this.cachedPages.get(cpid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<Integer, BufferedFileHandle> map;
        this.closed = true;
        this.fifoWriter.destroyQueue();
        try {
            map = this.cleanerThread.threadLock;
            synchronized (map) {
                this.cleanerThread.shutdownStart = true;
                this.cleanerThread.threadLock.notifyAll();
                while (!this.cleanerThread.shutdownComplete) {
                    this.cleanerThread.threadLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        map = this.fileInfoMap;
        synchronized (map) {
            for (Map.Entry<Integer, BufferedFileHandle> entry : this.fileInfoMap.entrySet()) {
                try {
                    boolean fileHasBeenDeleted = entry.getValue().fileHasBeenDeleted();
                    this.sweepAndFlush(entry.getKey(), !fileHasBeenDeleted);
                    if (fileHasBeenDeleted) continue;
                    this.ioManager.close(entry.getValue().getFileHandle());
                }
                catch (HyracksDataException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "Error flushing file id: " + entry.getKey(), e);
                }
            }
            this.fileInfoMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFile(FileReference fileRef) throws HyracksDataException {
        if (LOGGER.isLoggable(this.fileOpsLevel)) {
            LOGGER.log(this.fileOpsLevel, "Creating file: " + fileRef + " in cache: " + this);
        }
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            this.fileMapManager.registerFile(fileRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(int fileId) throws HyracksDataException {
        if (LOGGER.isLoggable(this.fileOpsLevel)) {
            LOGGER.log(this.fileOpsLevel, "Opening file: " + fileId + " in cache: " + this);
        }
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            BufferedFileHandle fInfo = this.fileInfoMap.get(fileId);
            if (fInfo == null) {
                boolean unreferencedFileFound = true;
                block3: while (this.fileInfoMap.size() >= this.maxOpenFiles && unreferencedFileFound) {
                    unreferencedFileFound = false;
                    for (Map.Entry<Integer, BufferedFileHandle> entry : this.fileInfoMap.entrySet()) {
                        if (entry.getValue().getReferenceCount() > 0) continue;
                        int entryFileId = entry.getKey();
                        boolean fileHasBeenDeleted = entry.getValue().fileHasBeenDeleted();
                        this.sweepAndFlush(entryFileId, !fileHasBeenDeleted);
                        if (!fileHasBeenDeleted) {
                            this.ioManager.close(entry.getValue().getFileHandle());
                        }
                        this.fileInfoMap.remove(entryFileId);
                        unreferencedFileFound = true;
                        continue block3;
                    }
                }
                if (this.fileInfoMap.size() >= this.maxOpenFiles) {
                    throw new HyracksDataException("Could not open fileId " + fileId + ". Max number of files " + this.maxOpenFiles + " already opened and referenced.");
                }
                FileReference fileRef = this.fileMapManager.lookupFileName(fileId);
                IFileHandle fh = this.ioManager.open(fileRef, IIOManager.FileReadWriteMode.READ_WRITE, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
                fInfo = new BufferedFileHandle(fileId, fh);
                this.fileInfoMap.put(fileId, fInfo);
            }
            fInfo.incReferenceCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sweepAndFlush(int fileId, boolean flushDirtyPages) throws HyracksDataException {
        for (CacheBucket bucket : this.pageMap) {
            bucket.bucketLock.lock();
            try {
                CachedPage cPage;
                CachedPage prev = bucket.cachedPage;
                while (prev != null && (cPage = prev.next) != null) {
                    if (this.invalidateIfFileIdMatch(fileId, cPage, flushDirtyPages)) {
                        prev.next = cPage.next;
                        cPage.next = null;
                        continue;
                    }
                    prev = cPage;
                }
                if (bucket.cachedPage == null || !this.invalidateIfFileIdMatch(fileId, bucket.cachedPage, flushDirtyPages)) continue;
                cPage = bucket.cachedPage;
                bucket.cachedPage = ((CacheBucket)bucket).cachedPage.next;
                cPage.next = null;
            }
            finally {
                bucket.bucketLock.unlock();
            }
        }
    }

    private boolean invalidateIfFileIdMatch(int fileId, CachedPage cPage, boolean flushDirtyPages) throws HyracksDataException {
        if (BufferedFileHandle.getFileId(cPage.dpid) == fileId) {
            int pinCount;
            if (cPage.dirty.get()) {
                if (flushDirtyPages) {
                    this.write(cPage);
                }
                cPage.dirty.set(false);
                pinCount = cPage.pinCount.decrementAndGet();
            } else {
                pinCount = cPage.pinCount.get();
            }
            if (pinCount > 0) {
                throw new IllegalStateException("Page " + BufferedFileHandle.getFileId(cPage.dpid) + ":" + BufferedFileHandle.getPageId(cPage.dpid) + " is pinned and file is being closed. Pincount is: " + pinCount + " Page is confiscated: " + cPage.confiscated);
            }
            cPage.invalidate();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile(int fileId) throws HyracksDataException {
        if (LOGGER.isLoggable(this.fileOpsLevel)) {
            LOGGER.log(this.fileOpsLevel, "Closing file: " + fileId + " in cache: " + this);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this.dumpState());
        }
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            BufferedFileHandle fInfo = this.fileInfoMap.get(fileId);
            if (fInfo == null) {
                throw new HyracksDataException("Closing unopened file");
            }
            if (fInfo.decReferenceCount() < 0) {
                throw new HyracksDataException("Closed fileId: " + fileId + " more times than it was opened.");
            }
        }
        if (LOGGER.isLoggable(this.fileOpsLevel)) {
            LOGGER.log(this.fileOpsLevel, "Closed file: " + fileId + " in cache: " + this);
        }
    }

    @Override
    public void flushDirtyPage(ICachedPage page) throws HyracksDataException {
        this.cleanerThread.cleanPage((CachedPage)page, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force(int fileId, boolean metadata) throws HyracksDataException {
        BufferedFileHandle fInfo;
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            fInfo = this.fileInfoMap.get(fileId);
        }
        this.ioManager.sync(fInfo.getFileHandle(), metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deleteFile(int fileId, boolean flushDirtyPages) throws HyracksDataException {
        if (LOGGER.isLoggable(this.fileOpsLevel)) {
            LOGGER.log(this.fileOpsLevel, "Deleting file: " + fileId + " in cache: " + this);
        }
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            this.sweepAndFlush(fileId, flushDirtyPages);
            BufferedFileHandle fInfo = null;
            try {
                fInfo = this.fileInfoMap.get(fileId);
                if (fInfo != null && fInfo.getReferenceCount() > 0) {
                    throw new HyracksDataException("Deleting open file");
                }
            }
            finally {
                this.fileMapManager.unregisterFile(fileId);
                if (fInfo != null) {
                    BufferedFileHandle bufferedFileHandle = fInfo;
                    synchronized (bufferedFileHandle) {
                        if (!fInfo.fileHasBeenDeleted()) {
                            this.ioManager.close(fInfo.getFileHandle());
                            fInfo.markAsDeleted();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getFileReferenceCount(int fileId) {
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            BufferedFileHandle fInfo = this.fileInfoMap.get(fileId);
            if (fInfo != null) {
                return fInfo.getReferenceCount();
            }
            return 0;
        }
    }

    public void start() {
    }

    public void stop(boolean dumpState, OutputStream os) throws IOException {
        if (dumpState) {
            this.dumpState(os);
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPage(ICachedPageInternal page) {
        List<ICachedPageInternal> list = this.cachedPages;
        synchronized (list) {
            int cpid = page.getCachedPageId();
            if (cpid < this.cachedPages.size()) {
                this.cachedPages.set(cpid, page);
            } else {
                if (cpid > this.cachedPages.size()) {
                    this.cachedPages.addAll(Collections.nCopies(cpid - this.cachedPages.size(), null));
                }
                this.cachedPages.add(page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePage(ICachedPageInternal victimPage) {
        CachedPage victim = (CachedPage)victimPage;
        if (victim.dpid < 0L) {
            if (!victim.pinCount.compareAndSet(0, 1)) {
                return false;
            }
            if (victim.dpid >= 0L) {
                victim.pinCount.decrementAndGet();
                return false;
            }
        } else {
            int pageHash = this.hash(victim.dpid);
            CacheBucket bucket = this.pageMap[pageHash];
            bucket.bucketLock.lock();
            try {
                if (!victim.pinCount.compareAndSet(0, 1)) {
                    boolean bl = false;
                    return bl;
                }
                if (pageHash != this.hash(victim.dpid)) {
                    victim.pinCount.decrementAndGet();
                    boolean bl = false;
                    return bl;
                }
                CachedPage curr = bucket.cachedPage;
                CachedPage prev = null;
                boolean found = false;
                while (curr != null) {
                    if (curr == victim) {
                        if (prev == null) {
                            bucket.cachedPage = curr.next;
                        } else {
                            prev.next = curr.next;
                        }
                        curr.next = null;
                        found = true;
                        break;
                    }
                    prev = curr;
                    curr = curr.next;
                }
                assert (found);
            }
            finally {
                bucket.bucketLock.unlock();
            }
        }
        List<ICachedPageInternal> list = this.cachedPages;
        synchronized (list) {
            ICachedPageInternal iCachedPageInternal = this.cachedPages.set(victim.cpid, null);
        }
        return true;
    }

    public void dumpState(OutputStream os) throws IOException {
        os.write(this.dumpState().getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumPagesOfFile(int fileId) throws HyracksDataException {
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            BufferedFileHandle fInfo = this.fileInfoMap.get(fileId);
            if (fInfo == null) {
                throw new HyracksDataException("No such file mapped for fileId:" + fileId);
            }
            return (int)(this.ioManager.getSize(fInfo.getFileHandle()) / (long)this.getPageSizeWithHeader());
        }
    }

    @Override
    public void adviseWontNeed(ICachedPage page) {
        this.pageReplacementStrategy.adviseWontNeed((ICachedPageInternal)page);
    }

    @Override
    public ICachedPage confiscatePage(long dpid) throws HyracksDataException {
        return this.confiscatePage(dpid, 1);
    }

    @Override
    public ICachedPage confiscateLargePage(long dpid, int multiplier, int extraBlockPageId) throws HyracksDataException {
        ICachedPage cachedPage = this.confiscatePage(dpid, multiplier);
        ((ICachedPageInternal)cachedPage).setExtraBlockPageId(extraBlockPageId);
        return cachedPage;
    }

    private ICachedPage confiscatePage(long dpid, int multiplier) throws HyracksDataException {
        return this.getPageLoop(dpid, multiplier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICachedPage confiscateInner(long dpid, int multiplier) {
        CachedPage returnPage = null;
        CachedPage victim = (CachedPage)this.pageReplacementStrategy.findVictim(multiplier);
        if (victim == null) {
            return victim;
        }
        if (victim.dpid < 0L) {
            if (!victim.pinCount.compareAndSet(0, 1)) {
                return null;
            }
            if (victim.dpid >= 0L) {
                victim.pinCount.decrementAndGet();
                return null;
            }
            returnPage = victim;
            returnPage.dpid = dpid;
        } else {
            int pageHash = this.hash(victim.getDiskPageId());
            CacheBucket bucket = this.pageMap[pageHash];
            bucket.bucketLock.lock();
            try {
                CachedPage curr = bucket.cachedPage;
                CachedPage prev = null;
                boolean found = false;
                while (curr != null) {
                    if (curr == victim) {
                        if (!victim.pinCount.compareAndSet(0, 1)) break;
                        if (prev == null) {
                            bucket.cachedPage = curr.next;
                        } else {
                            prev.next = curr.next;
                        }
                        curr.next = null;
                        found = true;
                        break;
                    }
                    prev = curr;
                    curr = curr.next;
                }
                if (found) {
                    returnPage = victim;
                    returnPage.dpid = dpid;
                }
            }
            finally {
                bucket.bucketLock.unlock();
            }
        }
        if (returnPage != null) {
            returnPage.confiscated.set(true);
            return returnPage;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICachedPage getPageLoop(long dpid, int multiplier, boolean confiscate) throws HyracksDataException {
        long startingPinCount = -1L;
        int cycleCount = 0;
        try {
            while (true) {
                Object object;
                ICachedPage page;
                ++cycleCount;
                int startCleanedCount = this.cleanerThread.cleanedCount;
                ICachedPage iCachedPage = page = confiscate ? this.confiscateInner(dpid, multiplier) : this.findPageInner(dpid);
                if (page != null) {
                    this.masterPinCount.incrementAndGet();
                    object = page;
                    return object;
                }
                object = this.cleanerThread.threadLock;
                synchronized (object) {
                    try {
                        this.pageCleanerPolicy.notifyVictimNotFound(this.cleanerThread.threadLock);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.cleanerThread.cleanedCount - startCleanedCount > 3) continue;
                object = this.cleanerThread.cleanNotification;
                synchronized (object) {
                    try {
                        this.cleanerThread.cleanNotification.wait(50L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.finishQueue();
                if (cycleCount > 1000) break;
            }
            cycleCount = 0;
            throw new HyracksDataException("Unable to find free page in buffer cache after 1000 cycles (buffer cache undersized?)" + "");
        }
        finally {
            if (cycleCount > 3 && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Took " + cycleCount + " cycles to find free page in buffer cache.  (buffer cache undersized?)" + "");
            }
        }
    }

    @Override
    public void returnPage(ICachedPage page) {
        this.returnPage(page, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnPage(ICachedPage page, boolean reinsert) {
        CachedPage cPage = (CachedPage)page;
        if (!page.confiscated()) {
            return;
        }
        if (reinsert) {
            int hash = this.hash(cPage.dpid);
            CacheBucket bucket = this.pageMap[hash];
            bucket.bucketLock.lock();
            try {
                cPage.reset(cPage.dpid);
                cPage.valid = true;
                cPage.next = bucket.cachedPage;
                bucket.cachedPage = cPage;
                cPage.pinCount.decrementAndGet();
            }
            finally {
                bucket.bucketLock.unlock();
            }
        } else {
            cPage.invalidate();
            cPage.pinCount.decrementAndGet();
        }
        this.pageReplacementStrategy.adviseWontNeed(cPage);
    }

    @Override
    public void setPageDiskId(ICachedPage page, long dpid) {
        ((CachedPage)page).dpid = dpid;
    }

    @Override
    public IFIFOPageQueue createFIFOQueue() {
        return this.fifoWriter.createQueue(FIFOLocalWriter.instance());
    }

    @Override
    public void finishQueue() {
        this.fifoWriter.finishQueue();
    }

    @Override
    public boolean isReplicationEnabled() {
        if (this.ioReplicationManager != null) {
            return this.ioReplicationManager.isReplicationEnabled();
        }
        return false;
    }

    @Override
    public IIOReplicationManager getIOReplicationManager() {
        return this.ioReplicationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeHandle(int fileId) throws HyracksDataException {
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            BufferedFileHandle fh = this.fileInfoMap.get(fileId);
            if (fh != null) {
                this.ioManager.close(fh.getFileHandle());
                this.fileInfoMap.remove(fileId);
                this.fileMapManager.unregisterFile(fileId);
            }
        }
    }

    static class BufferCacheHeaderHelper {
        private static final int FRAME_MULTIPLIER_OFF = 0;
        private static final int EXTRA_BLOCK_PAGE_ID_OFF = 4;
        private final ByteBuffer buf;
        private final ByteBuffer[] array;

        private BufferCacheHeaderHelper(int pageSize) {
            this.buf = ByteBuffer.allocate(8 + pageSize);
            this.array = new ByteBuffer[]{this.buf, null};
        }

        private ByteBuffer[] prepareWrite(CachedPage cPage, ByteBuffer pageBuffer) {
            this.buf.position(0);
            this.buf.limit(8);
            this.buf.putInt(0, cPage.getFrameSizeMultiplier());
            this.buf.putInt(4, cPage.getExtraBlockPageId());
            this.array[1] = pageBuffer;
            return this.array;
        }

        private ByteBuffer prepareRead() {
            this.buf.position(0);
            this.buf.limit(this.buf.capacity());
            return this.buf;
        }

        private int processRead(CachedPage cPage) {
            this.buf.position(8);
            cPage.buffer.position(0);
            cPage.buffer.put(this.buf);
            int multiplier = this.buf.getInt(0);
            cPage.setFrameSizeMultiplier(multiplier);
            cPage.setExtraBlockPageId(this.buf.getInt(4));
            return multiplier;
        }
    }

    private class CleanerThread
    implements Runnable {
        private volatile boolean shutdownStart = false;
        private volatile boolean shutdownComplete = false;
        private final Object threadLock = new Object();
        private final Object cleanNotification = new Object();
        private volatile int cleanedCount = 0;

        private CleanerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanPage(CachedPage cPage, boolean force) {
            if (cPage.dirty.get() && !cPage.confiscated.get()) {
                boolean proceed = false;
                if (force) {
                    cPage.latch.writeLock().lock();
                    proceed = true;
                } else {
                    proceed = cPage.latch.readLock().tryLock();
                }
                if (proceed) {
                    try {
                        this.cleanPageLocked(cPage);
                    }
                    finally {
                        if (force) {
                            cPage.latch.writeLock().unlock();
                        } else {
                            cPage.latch.readLock().unlock();
                        }
                    }
                } else if (this.shutdownStart) {
                    throw new IllegalStateException("Cache closed, but unable to acquire read lock on dirty page: " + cPage.dpid);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanPageLocked(CachedPage cPage) {
            if (!cPage.dirty.get()) {
                return;
            }
            boolean cleaned = true;
            try {
                BufferCache.this.write(cPage);
            }
            catch (HyracksDataException e) {
                LOGGER.log(Level.WARNING, "Unable to write dirty page", e);
                cleaned = false;
            }
            if (cleaned) {
                cPage.dirty.set(false);
                cPage.pinCount.decrementAndGet();
                ++this.cleanedCount;
                Object object = this.cleanNotification;
                synchronized (object) {
                    this.cleanNotification.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.threadLock;
            synchronized (object) {
                try {
                    while (!this.shutdownStart) {
                        this.runCleanCycle();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.shutdownComplete = true;
                    this.threadLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runCleanCycle() throws InterruptedException {
            BufferCache.this.pageCleanerPolicy.notifyCleanCycleStart(this.threadLock);
            int curPage = 0;
            while (true) {
                List list = BufferCache.this.cachedPages;
                synchronized (list) {
                    if (curPage >= BufferCache.this.cachedPages.size()) {
                        break;
                    }
                    CachedPage cPage = (CachedPage)BufferCache.this.cachedPages.get(curPage);
                    if (cPage != null) {
                        this.cleanPage(cPage, false);
                    }
                }
                ++curPage;
            }
            if (!this.shutdownStart) {
                BufferCache.this.pageCleanerPolicy.notifyCleanCycleFinish(this.threadLock);
            }
        }
    }

    private static class CacheBucket {
        private final Lock bucketLock = new ReentrantLock();
        private CachedPage cachedPage;
    }
}

