/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.utils;

import java.io.File;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.MappedFileSplit;
import org.apache.hyracks.dataflow.std.file.ConstantFileSplitProvider;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class StoragePathUtil {
    private static final Logger LOGGER = Logger.getLogger((String)StoragePathUtil.class.getName());
    public static final String PARTITION_DIR_PREFIX = "partition_";
    public static final String TEMP_DATASETS_STORAGE_FOLDER = "temp";
    public static final String DATASET_INDEX_NAME_SEPARATOR = "_idx_";
    public static final String ADAPTER_INSTANCE_PREFIX = "adapter_";

    private StoragePathUtil() {
    }

    public static Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitProviderAndPartitionConstraints(FileSplit[] splits) {
        ConstantFileSplitProvider splitProvider = new ConstantFileSplitProvider(splits);
        String[] loc = new String[splits.length];
        for (int p = 0; p < splits.length; ++p) {
            loc[p] = splits[p].getNodeName();
        }
        AlgebricksAbsolutePartitionConstraint pc = new AlgebricksAbsolutePartitionConstraint(loc);
        return new Pair((Object)splitProvider, (Object)pc);
    }

    public static FileSplit getFileSplitForClusterPartition(ClusterPartition partition, String relativePath) {
        return new MappedFileSplit(partition.getActiveNodeId(), relativePath, partition.getIODeviceNum());
    }

    public static String prepareStoragePartitionPath(String storageDirName, int partitonId) {
        return storageDirName + File.separator + PARTITION_DIR_PREFIX + partitonId;
    }

    public static String prepareDataverseIndexName(String dataverseName, String datasetName, String idxName) {
        return StoragePathUtil.prepareDataverseIndexName(dataverseName, StoragePathUtil.prepareFullIndexName(datasetName, idxName));
    }

    public static String prepareDataverseIndexName(String dataverseName, String fullIndexName) {
        return dataverseName + File.separator + fullIndexName;
    }

    private static String prepareFullIndexName(String datasetName, String idxName) {
        return datasetName + DATASET_INDEX_NAME_SEPARATOR + idxName;
    }

    public static int getPartitionNumFromName(String name) {
        return Integer.parseInt(name.substring(PARTITION_DIR_PREFIX.length()));
    }

    public static String getIndexFileRelativePath(String fileAbsolutePath) {
        String[] tokens = fileAbsolutePath.split(File.separator);
        return tokens[tokens.length - 4] + File.separator + tokens[tokens.length - 3] + File.separator + tokens[tokens.length - 2] + File.separator + tokens[tokens.length - 1];
    }

    public static File createFile(String name, int count) throws HyracksDataException {
        try {
            String fileName = name + "_" + count;
            File file = new File(fileName);
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                boolean success = file.createNewFile();
                if (!success) {
                    throw new HyracksDataException("Unable to create spill file " + fileName);
                }
                if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
                    LOGGER.info((Object)("Created spill file " + file.getAbsolutePath()));
                }
            } else {
                throw new HyracksDataException("spill file " + fileName + " already exists");
            }
            return file;
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }
}

